/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.virtual.deployment;

import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.jboss.profileservice.spi.virtual.PathRestriction;

@XmlType(propOrder={"name"})
public class AntMatchRestriction
implements PathRestriction {
    private String name;

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean matches(String path) {
        return AntMatchRestriction.antMatch(path, this.getName());
    }

    public static Pattern getPattern(String matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Null matcher");
        }
        matcher = matcher.replace(".", "\\.");
        matcher = matcher.replace("*", ".*");
        matcher = matcher.replace("?", ".{1}");
        return Pattern.compile(matcher);
    }

    public static boolean antMatch(String path, String expression) {
        int p;
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Null expression");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (expression.endsWith("/")) {
            expression = expression + "**";
        }
        String[] paths = path.split("/");
        String[] expressions = expression.split("/");
        int x = 0;
        Pattern pattern = AntMatchRestriction.getPattern(expressions[0]);
        for (p = 0; p < paths.length && x < expressions.length; ++p) {
            String element;
            if (expressions[x].equals("**")) {
                while (++x < expressions.length && expressions[x].equals("**")) {
                }
                if (x == expressions.length) {
                    return true;
                }
                pattern = AntMatchRestriction.getPattern(expressions[x]);
            }
            if (pattern.matcher(element = paths[p]).matches()) {
                if (++x >= expressions.length) continue;
                pattern = AntMatchRestriction.getPattern(expressions[x]);
                continue;
            }
            if (x > 0 && expressions[x - 1].equals("**")) continue;
            return false;
        }
        return p >= paths.length && x >= expressions.length;
    }
}

