/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import org.jboss.deployers.vfs.spi.structure.modified.StructureCache;
import org.jboss.deployers.vfs.spi.structure.modified.SynchAdapter;
import org.jboss.deployers.vfs.spi.structure.modified.SynchVisitor;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDeleteVisitor
extends SynchVisitor {
    private VirtualFile originalRoot;
    private VirtualFile tempRoot;

    public UpdateDeleteVisitor(VisitorAttributes attributes, StructureCache<Long> cache, SynchAdapter synchAdapter, VirtualFile originalRoot, VirtualFile tempRoot) {
        this(null, attributes, cache, synchAdapter, originalRoot, tempRoot);
    }

    public UpdateDeleteVisitor(VirtualFileFilter filter, VisitorAttributes attributes, StructureCache<Long> cache, SynchAdapter synchAdapter, VirtualFile originalRoot, VirtualFile tempRoot) {
        super(filter, attributes, cache, synchAdapter);
        if (originalRoot == null) {
            throw new IllegalArgumentException("Null original root");
        }
        this.originalRoot = originalRoot;
        this.tempRoot = tempRoot;
    }

    @Override
    protected void doVisit(VirtualFile file) throws Exception {
        String path = file.getPathNameRelativeTo(this.tempRoot);
        VirtualFile child = this.originalRoot.getChild(path);
        if (!child.exists()) {
            if (this.getSynchAdapter().delete(file)) {
                this.getCache().removeCache(this.originalRoot, path);
            }
        } else {
            Long previous = this.getCache().getCacheValue(child);
            long lastModified = child.getLastModified();
            boolean updateCache = false;
            if (previous == null) {
                updateCache = true;
            } else if (lastModified > previous) {
                lastModified = this.getSynchAdapter().update(file, child);
                updateCache = true;
            }
            if (updateCache) {
                this.getCache().putCacheValue(child, lastModified);
            }
        }
    }
}

