/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBProvider;
import org.jboss.resteasy.plugins.providers.multipart.ContentIDUtils;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;

public class XopWithMultipartRelatedJAXBProvider
extends AbstractJAXBProvider<Object> {
    public XopWithMultipartRelatedJAXBProvider(Providers providers) {
        this.providers = providers;
    }

    protected boolean isReadWritable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        throw new UnsupportedOperationException("This provider and this method are not ment for stand alone usage.");
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream, MultipartRelatedInput xopPackage) throws IOException {
        try {
            InputPart rootPart = xopPackage.getRootPart();
            JAXBContext jaxb = this.findJAXBContext(type, annotations, rootPart.getMediaType(), true);
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new XopAttachmentUnmarshaller(xopPackage));
            return unmarshaller.unmarshal((Source)new StreamSource(rootPart.getBody(InputStream.class, null)));
        }
        catch (JAXBException e) {
            Response response = Response.serverError().build();
            throw new WebApplicationException((Throwable)e, response);
        }
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, MultipartRelatedOutput xopPackage) throws IOException {
        try {
            LinkedHashMap<String, String> mediaTypeParameters = new LinkedHashMap<String, String>();
            mediaTypeParameters.put("charset", "UTF-8");
            mediaTypeParameters.put("type", "text/xml");
            MediaType xopRootMediaType = new MediaType("application", "xop+xml", mediaTypeParameters);
            Marshaller marshaller = this.getMarshaller(type, annotations, xopRootMediaType);
            marshaller.setAttachmentMarshaller((AttachmentMarshaller)new XopAttachmentMarshaller(xopPackage));
            ByteArrayOutputStream xml = new ByteArrayOutputStream();
            marshaller.marshal(t, (OutputStream)xml);
            OutputPart outputPart = xopPackage.addPart((Object)xml.toString(), xopRootMediaType, ContentIDUtils.generateContentID(), null);
            List<OutputPart> outputParts = xopPackage.getParts();
            outputParts.remove(outputPart);
            outputParts.add(0, outputPart);
        }
        catch (JAXBException e) {
            Response response = Response.serverError().build();
            throw new WebApplicationException((Throwable)e, response);
        }
    }

    private static class XopAttachmentUnmarshaller
    extends AttachmentUnmarshaller {
        private final MultipartRelatedInput xopPackage;

        private XopAttachmentUnmarshaller(MultipartRelatedInput xopPackage) {
            this.xopPackage = xopPackage;
        }

        public byte[] getAttachmentAsByteArray(String cid) {
            InputPart inputPart = this.getInputPart(cid);
            try {
                return inputPart.getBody(byte[].class, null);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Exception while extracting attachment with cid = " + cid + " from xop message to a byte[].", e);
            }
        }

        public DataHandler getAttachmentAsDataHandler(String cid) {
            InputPart inputPart = this.getInputPart(cid);
            return new DataHandler((DataSource)new InputPartBackedDataSource(cid, inputPart));
        }

        protected InputPart getInputPart(String cid) {
            String contentID = ContentIDUtils.convertCidToContentID(cid);
            InputPart inputPart = this.xopPackage.getRelatedMap().get(contentID);
            if (inputPart == null) {
                throw new IllegalArgumentException("No attachment with cid = " + cid + " (Content-ID = " + contentID + ") found in xop message.");
            }
            return inputPart;
        }

        public boolean isXOPPackage() {
            return true;
        }
    }

    private static class InputPartBackedDataSource
    implements DataSource {
        private final String cid;
        private final InputPart inputPart;

        private InputPartBackedDataSource(String cid, InputPart inputPart) {
            this.cid = cid;
            this.inputPart = inputPart;
        }

        public String getContentType() {
            return this.inputPart.getMediaType().toString();
        }

        public String getName() {
            return this.cid;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputPart.getBody(InputStream.class, null);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("This DataSource represents an incoming xop message part. Getting an OutputStream on it is not allowed.");
        }
    }

    private static class XopAttachmentMarshaller
    extends AttachmentMarshaller {
        private final MultipartRelatedOutput xopPackage;

        private XopAttachmentMarshaller(MultipartRelatedOutput xopPackage) {
            this.xopPackage = xopPackage;
        }

        public String addMtomAttachment(DataHandler data, String elementNamespace, String elementLocalName) {
            return this.addBinary(data.getDataSource(), data.getContentType());
        }

        public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNamespace, String elementLocalName) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data, offset, length);
            return this.addBinary(byteArrayInputStream, mimeType);
        }

        protected String addBinary(Object object, String mimeType) {
            String addrSpec = ContentIDUtils.generateRFC822AddrSpec();
            String contentID = ContentIDUtils.generateContentIDFromAddrSpec(addrSpec);
            this.xopPackage.addPart(object, MediaType.valueOf((String)mimeType), contentID, "binary");
            return ContentIDUtils.generateCidFromAddrSpec(addrSpec);
        }

        public String addSwaRefAttachment(DataHandler data) {
            throw new UnsupportedOperationException("SwaRefs are not supported in xop creation.");
        }

        public boolean isXOPPackage() {
            return true;
        }
    }
}

