/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modcluster.mcmp.MCMPResponseParser;
import org.jboss.modcluster.mcmp.ResetRequestSource;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMCMPResponseParser
implements MCMPResponseParser {
    private static final String PARAMETER_DELIMITER = "&";
    private static final String NAME_VALUE_DELIMITER = "=";
    private static final Logger log = Logger.getLogger(DefaultMCMPResponseParser.class);

    @Override
    public Map<String, Set<ResetRequestSource.VirtualHost>> parseInfoResponse(String response) {
        if (response == null) {
            return Collections.emptyMap();
        }
        log.trace((Object)response);
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        HashMap virtualHostMap = new HashMap();
        block0: for (String line : response.split("\r\n|\r|\n")) {
            String hostId;
            String[] ids;
            String[] entries;
            if (line.startsWith("Node:")) {
                entries = line.split(",");
                String nodeId = this.parseIds(entries[0])[0];
                for (int i = 1; i < entries.length; ++i) {
                    String entry = entries[i];
                    int index = entry.indexOf(58);
                    if (index < 0) {
                        throw new IllegalArgumentException(response);
                    }
                    String key = entry.substring(0, index).trim();
                    String value = entry.substring(index + 1).trim();
                    if (!"Name".equals(key)) continue;
                    nodeMap.put(nodeId, value);
                    virtualHostMap.put(value, new HashMap());
                    continue block0;
                }
                continue;
            }
            if (line.startsWith("Vhost:")) {
                String hostId2;
                entries = line.split(",");
                ids = this.parseIds(entries[0]);
                if (ids.length != 3) {
                    throw new IllegalArgumentException(response);
                }
                String node = (String)nodeMap.get(ids[0]);
                if (node == null) {
                    throw new IllegalArgumentException(response);
                }
                Map hostMap = (Map)virtualHostMap.get(node);
                ResetRequestSource.VirtualHost host = (ResetRequestSource.VirtualHost)hostMap.get(hostId2 = ids[1]);
                if (host == null) {
                    host = new DefaultMCMPHandler.VirtualHostImpl();
                    hostMap.put(hostId2, host);
                }
                for (int i = 1; i < entries.length; ++i) {
                    String entry = entries[i];
                    int index = entry.indexOf(58);
                    if (index < 0) {
                        throw new IllegalArgumentException(response);
                    }
                    String key = entry.substring(0, index).trim();
                    String value = entry.substring(index + 1).trim();
                    if (!"Alias".equals(key)) continue;
                    host.getAliases().add(value);
                    continue block0;
                }
                continue;
            }
            if (!line.startsWith("Context:")) continue;
            entries = line.split(",");
            ids = this.parseIds(entries[0]);
            if (ids.length != 3) {
                throw new IllegalArgumentException(response);
            }
            String nodeId = ids[0];
            String node = (String)nodeMap.get(nodeId);
            if (node == null) {
                throw new IllegalArgumentException(response);
            }
            Map hostMap = (Map)virtualHostMap.get(node);
            ResetRequestSource.VirtualHost host = (ResetRequestSource.VirtualHost)hostMap.get(hostId = ids[1]);
            if (host == null) {
                throw new IllegalArgumentException(response);
            }
            String context = null;
            ResetRequestSource.Status status = null;
            for (int i = 1; i < entries.length; ++i) {
                String entry = entries[i];
                int index = entry.indexOf(58);
                if (index < 0) {
                    throw new IllegalArgumentException(response);
                }
                String key = entry.substring(0, index).trim();
                String value = entry.substring(index + 1).trim();
                if ("Context".equals(key)) {
                    context = value;
                    continue;
                }
                if (!"Status".equals(key)) continue;
                status = ResetRequestSource.Status.valueOf(value);
            }
            if (context == null || status == null) {
                throw new IllegalArgumentException(response);
            }
            host.getContexts().put(context, status);
        }
        HashMap<String, Set<ResetRequestSource.VirtualHost>> result = new HashMap<String, Set<ResetRequestSource.VirtualHost>>();
        for (Map.Entry entry : virtualHostMap.entrySet()) {
            result.put((String)entry.getKey(), new HashSet(((Map)entry.getValue()).values()));
        }
        log.trace(result);
        return result;
    }

    private String[] parseIds(String entry) {
        String[] stringArray;
        int end;
        int start = entry.indexOf(91) + 1;
        if (start >= (end = entry.indexOf(93))) {
            throw new IllegalArgumentException(entry);
        }
        String ids = entry.substring(start, end);
        if (ids.length() > 2) {
            stringArray = ids.split(":");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ids;
        }
        return stringArray;
    }

    @Override
    public boolean parsePingResponse(String response) {
        log.trace((Object)response);
        String value = this.findProperty("State", response);
        return value != null ? value.equals("OK") : false;
    }

    @Override
    public int parseStopAppResponse(String response) {
        log.trace((Object)response);
        String value = this.findProperty("Requests", response);
        try {
            return value != null ? Integer.parseInt(value) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private String findProperty(String name, String response) {
        if (response == null) {
            return null;
        }
        for (String value : response.trim().split(PARAMETER_DELIMITER)) {
            String[] pair = value.split(NAME_VALUE_DELIMITER);
            if (pair.length != 2 || !pair[0].equals(name)) continue;
            return pair[1];
        }
        return null;
    }
}

