/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util.units;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.rhq.core.clientapi.util.units.FormatSpecifics;
import org.rhq.core.clientapi.util.units.FormattedNumber;
import org.rhq.core.clientapi.util.units.ParseSpecifics;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.SimpleFormatter;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;

public class PercentageFormatter
extends SimpleFormatter {
    protected UnitsConstants getUnitType() {
        return UnitsConstants.UNIT_PERCENTAGE;
    }

    protected ScaleConstants getUnitScale() {
        return ScaleConstants.SCALE_NONE;
    }

    protected FormattedNumber formatNumber(double rawValue, NumberFormat fmt) {
        return new FormattedNumber(fmt.format(rawValue * 100.0), "%", "");
    }

    public UnitNumber parse(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        NumberFormat fmt = NumberFormat.getPercentInstance(locale);
        return new UnitNumber(fmt.parse(val).doubleValue(), this.getUnitType(), this.getUnitScale());
    }

    public FormattedNumber[] formatSame(double[] vals, UnitsConstants unitType, ScaleConstants scale, Locale locale, FormatSpecifics specifics) {
        if (unitType != this.getUnitType()) {
            throw new IllegalArgumentException("Invalid unit specified");
        }
        if (scale != this.getUnitScale()) {
            throw new IllegalArgumentException("Invalid scale specified");
        }
        NumberFormat fmt = NumberFormat.getInstance(locale);
        fmt.setMaximumFractionDigits(2);
        FormattedNumber[] res = new FormattedNumber[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            res[i] = this.formatNumber(vals[i], fmt);
        }
        return res;
    }
}

