/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.persistence;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.TableValue;
import org.jboss.profileservice.persistence.ManagedObjectPersistencePlugin;
import org.jboss.profileservice.persistence.xml.NullValue;
import org.jboss.profileservice.persistence.xml.PersistedArrayValue;
import org.jboss.profileservice.persistence.xml.PersistedCollectionValue;
import org.jboss.profileservice.persistence.xml.PersistedCompositeValue;
import org.jboss.profileservice.persistence.xml.PersistedEnumValue;
import org.jboss.profileservice.persistence.xml.PersistedGenericValue;
import org.jboss.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.profileservice.persistence.xml.PersistedPair;
import org.jboss.profileservice.persistence.xml.PersistedPropertiesValue;
import org.jboss.profileservice.persistence.xml.PersistedSimpleValue;
import org.jboss.profileservice.persistence.xml.PersistedTableValue;
import org.jboss.profileservice.persistence.xml.PersistedValue;

public class AbstractValuePersistence {
    private static final Logger log = Logger.getLogger(AbstractValuePersistence.class);
    private final MetaValueFactory metaValueFactory;
    private final ManagedObjectPersistencePlugin plugin;

    public AbstractValuePersistence(ManagedObjectPersistencePlugin callback, MetaValueFactory metaValueFactory) {
        if (callback == null) {
            throw new IllegalArgumentException("Null managed object persistence callback.");
        }
        if (metaValueFactory == null) {
            throw new IllegalArgumentException("Null meta value factory.");
        }
        this.plugin = callback;
        this.metaValueFactory = metaValueFactory;
    }

    public MetaValueFactory getMetaValueFactory() {
        return this.metaValueFactory;
    }

    protected ManagedObjectPersistencePlugin getPlugin() {
        return this.plugin;
    }

    protected PersistedValue createPersistedValue(MetaValue value, MetaType metaType) {
        return this.createPersistedValue(value, metaType, null);
    }

    protected PersistedValue createPersistedValue(MetaValue value, MetaType metaType, PersistedValue persisted) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("creating persisted value for : " + value + " with metaType " + metaType));
        }
        if (value == null) {
            return new NullValue();
        }
        metaType = value.getMetaType();
        PersistedValue persistedValue = null;
        if (metaType.isSimple()) {
            persistedValue = this.createSimpleValue((SimpleValue)value);
        } else if (metaType.isEnum()) {
            persistedValue = this.createEnumValue((EnumValue)value);
        } else if (metaType.isCollection()) {
            persistedValue = this.createCollectionValue((CollectionValue)value);
        } else if (metaType.isGeneric()) {
            persistedValue = this.createGenericValue((GenericValue)value);
        } else if (metaType.isComposite()) {
            persistedValue = this.createCompositeValue((CompositeValue)value, (CompositeMetaType)metaType);
        } else if (metaType.isArray()) {
            persistedValue = this.createArrayValue((ArrayValue)value, (ArrayMetaType)metaType);
        } else if (metaType.isTable()) {
            persistedValue = this.createTableValue((TableValue)value);
        } else if (metaType.isProperties()) {
            persistedValue = this.createPropertiesValue((PropertiesMetaValue)value);
        } else {
            throw new IllegalStateException("unknown metaType");
        }
        return persistedValue;
    }

    protected PersistedEnumValue createEnumValue(EnumValue value) {
        PersistedEnumValue persistedValue = new PersistedEnumValue();
        persistedValue.setValue(value.getValue());
        return persistedValue;
    }

    protected PersistedSimpleValue createSimpleValue(SimpleValue value) {
        PersistedSimpleValue persistedValue = new PersistedSimpleValue();
        persistedValue.setValue(this.convertSimple2String(value));
        return persistedValue;
    }

    protected PersistedCollectionValue createCollectionValue(CollectionValue value) {
        PersistedCollectionValue collection = new PersistedCollectionValue();
        for (MetaValue child : value.getElements()) {
            PersistedValue persistedValue = this.createPersistedValue(child, child.getMetaType());
            collection.addValue(persistedValue);
        }
        return collection;
    }

    protected PersistedGenericValue createGenericValue(GenericValue value) {
        PersistedGenericValue generic = new PersistedGenericValue();
        return this.createGenericValue(value, generic);
    }

    protected PersistedGenericValue createGenericValue(GenericValue value, PersistedGenericValue generic) {
        Serializable o = value.getValue();
        if (o == null) {
            return generic;
        }
        if (!(o instanceof ManagedObject)) {
            throw new IllegalStateException("The value of GenericValue must be a ManagedObject: " + value);
        }
        PersistedManagedObject mo = generic.getManagedObject() == null ? this.plugin.createPersistedManagedObject((ManagedObject)o) : this.plugin.createPersistedManagedObject(generic.getManagedObject(), (ManagedObject)o);
        generic.setManagedObject(mo);
        return generic;
    }

    protected PersistedArrayValue createArrayValue(ArrayValue value, ArrayMetaType metaType) {
        PersistedArrayValue array = new PersistedArrayValue();
        MetaType elementType = metaType.getElementType();
        for (int i = 0; i < value.getLength(); ++i) {
            PersistedValue persistedValue = null;
            Object subElement = value.getValue(i);
            if (subElement instanceof MetaValue) {
                persistedValue = this.createPersistedValue((MetaValue)subElement, elementType);
            } else if (subElement != null && subElement.getClass().isArray()) {
                persistedValue = this.unwrapArray(array, subElement, elementType);
            }
            array.addValue(persistedValue);
        }
        return array;
    }

    protected PersistedArrayValue unwrapArray(PersistedArrayValue array, Object element, MetaType type) {
        PersistedArrayValue newElement = new PersistedArrayValue();
        int subSize = Array.getLength(element);
        for (int i = 0; i < subSize; ++i) {
            PersistedValue persistedValue = null;
            Object subElement = Array.get(element, i);
            if (subElement instanceof MetaValue) {
                persistedValue = this.createPersistedValue((MetaValue)subElement, type);
            } else if (subElement != null && subElement.getClass().isArray()) {
                persistedValue = this.unwrapArray(newElement, subElement, type);
            }
            newElement.addValue(persistedValue);
        }
        return newElement;
    }

    protected PersistedCompositeValue createCompositeValue(CompositeValue value, CompositeMetaType metaType) {
        PersistedCompositeValue composite = new PersistedCompositeValue();
        List<PersistedValue> values = composite.getValues();
        if (values == null) {
            values = new ArrayList<PersistedValue>();
            composite.setValues(values);
        }
        for (String item : metaType.itemSet()) {
            MetaType itemType = metaType.getType(item);
            MetaValue itemValue = value.get(item);
            PersistedValue persistedValue = this.createPersistedValue(itemValue, itemType);
            persistedValue.setName(item);
            values.add(persistedValue);
        }
        return composite;
    }

    protected PersistedTableValue createTableValue(TableValue value) {
        PersistedTableValue table = new PersistedTableValue();
        List<PersistedCompositeValue> entries = table.getEntries();
        if (entries == null) {
            entries = new ArrayList<PersistedCompositeValue>();
            table.setEntries(entries);
        }
        Collection values = value.values();
        for (CompositeValue entry : values) {
            entries.add(this.createCompositeValue(entry, entry.getMetaType()));
        }
        return table;
    }

    protected PersistedValue createPropertiesValue(PropertiesMetaValue value) {
        PersistedPropertiesValue properties = new PersistedPropertiesValue();
        List<PersistedPair> pairs = properties.getEntries();
        if (pairs == null) {
            pairs = new ArrayList<PersistedPair>();
            properties.setEntries(pairs);
        }
        for (Map.Entry entry : value.entrySet()) {
            Object key = entry.getKey();
            Object kvalue = entry.getValue();
            PersistedPair pair = new PersistedPair(key.toString(), kvalue.toString());
            pairs.add(pair);
        }
        return properties;
    }

    protected static PersistedValue emtpyPersistedValue(MetaType metaType) {
        if (metaType.isSimple()) {
            return new PersistedSimpleValue();
        }
        if (metaType.isEnum()) {
            return new PersistedEnumValue();
        }
        if (metaType.isCollection()) {
            return new PersistedCollectionValue();
        }
        if (metaType.isGeneric()) {
            return new PersistedGenericValue();
        }
        if (metaType.isComposite()) {
            return new PersistedCompositeValue();
        }
        if (metaType.isTable()) {
            return new PersistedTableValue();
        }
        if (metaType.isArray()) {
            return new PersistedArrayValue();
        }
        if (metaType.isProperties()) {
            return new PersistedPropertiesValue();
        }
        throw new IllegalStateException("unknown metaType");
    }

    protected String convertSimple2String(SimpleValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value.");
        }
        Object unwrappedValue = this.getMetaValueFactory().unwrap((MetaValue)value);
        if (unwrappedValue == null) {
            return null;
        }
        return "" + unwrappedValue;
    }
}

