/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.application.ResourceHandlerSupport;
import org.apache.myfaces.resource.ClassLoaderResourceLoader;
import org.apache.myfaces.resource.ExternalContextResourceLoader;
import org.apache.myfaces.resource.InternalClassLoaderResourceLoader;
import org.apache.myfaces.resource.ResourceLoader;
import org.apache.myfaces.shared_impl.application.FacesServletMapping;

public class DefaultResourceHandlerSupport
implements ResourceHandlerSupport {
    public static final String RESOURCE_MAX_TIME_EXPIRES = "org.apache.myfaces.RESOURCE_MAX_TIME_EXPIRES";
    private static final String CACHED_SERVLET_MAPPING = DefaultResourceHandlerSupport.class.getName() + ".CACHED_SERVLET_MAPPING";
    private ResourceLoader[] _resourceLoaders;
    private Long _startupTime = System.currentTimeMillis();
    private Long _maxTimeExpires;

    public String calculateResourceBasePath(FacesContext facesContext) {
        FacesServletMapping mapping = this.getFacesServletMapping(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (mapping != null) {
            String resourceBasePath = null;
            if (mapping.isExtensionMapping()) {
                resourceBasePath = externalContext.getRequestServletPath();
                int stripPoint = resourceBasePath.lastIndexOf(46);
                if (stripPoint > 0) {
                    resourceBasePath = resourceBasePath.substring(0, stripPoint);
                }
            } else {
                resourceBasePath = externalContext.getRequestPathInfo();
            }
            return resourceBasePath;
        }
        return externalContext.getRequestPathInfo();
    }

    public ResourceLoader[] getResourceLoaders() {
        if (this._resourceLoaders == null) {
            this._resourceLoaders = FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development) ? new ResourceLoader[]{new ExternalContextResourceLoader("/resources"), new ClassLoaderResourceLoader("META-INF/resources"), new InternalClassLoaderResourceLoader("META-INF/internal-resources")} : new ResourceLoader[]{new ExternalContextResourceLoader("/resources"), new ClassLoaderResourceLoader("META-INF/resources")};
        }
        return this._resourceLoaders;
    }

    public boolean isExtensionMapping() {
        FacesServletMapping mapping = this.getFacesServletMapping(FacesContext.getCurrentInstance());
        return mapping != null && mapping.isExtensionMapping();
    }

    public String getMapping() {
        FacesServletMapping mapping = this.getFacesServletMapping(FacesContext.getCurrentInstance());
        if (mapping != null) {
            if (mapping.isExtensionMapping()) {
                return mapping.getExtension();
            }
            return mapping.getPrefix();
        }
        return "";
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CACHED_SERVLET_MAPPING);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            mapping = DefaultResourceHandlerSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
            attributes.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    protected static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    public long getStartupTime() {
        return this._startupTime;
    }

    public long getMaxTimeExpires() {
        if (this._maxTimeExpires == null) {
            String time = FacesContext.getCurrentInstance().getExternalContext().getInitParameter(RESOURCE_MAX_TIME_EXPIRES);
            if (time != null && time.length() > 0) {
                try {
                    this._maxTimeExpires = Long.parseLong(time);
                }
                catch (NumberFormatException e) {
                    this._maxTimeExpires = 604800000L;
                }
            } else {
                this._maxTimeExpires = 604800000L;
            }
        }
        return this._maxTimeExpires;
    }
}

