/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyCustomScopeEvent;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.ScopeContext;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;

public class ManagedBeanDestroyer
implements SystemEventListener {
    private static Logger log = Logger.getLogger(ManagedBeanDestroyer.class.getName());
    private RuntimeConfig runtimeConfig;

    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public RuntimeConfig getRuntimeConfig() {
        FacesContext facesContext;
        if (this.runtimeConfig == null && (facesContext = FacesContext.getCurrentInstance()) != null) {
            ExternalContext externalContext = facesContext.getExternalContext();
            this.runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        }
        return this.runtimeConfig;
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof ScopeContext || source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) {
        Map scope = null;
        if (event instanceof PreDestroyViewMapEvent) {
            UIViewRoot viewRoot = (UIViewRoot)((PreDestroyViewMapEvent)event).getComponent();
            scope = viewRoot.getViewMap(false);
            if (scope == null) {
                return;
            }
        } else if (event instanceof PreDestroyCustomScopeEvent) {
            ScopeContext scopeContext = ((PreDestroyCustomScopeEvent)event).getContext();
            scope = scopeContext.getScope();
        } else {
            return;
        }
        LifecycleProvider provider = this.getCurrentLifecycleProvider();
        for (String key : scope.keySet()) {
            Object value = scope.get(key);
            this.destroy(key, value, provider);
        }
    }

    public boolean isManagedBean(String name) {
        RuntimeConfig config = this.getRuntimeConfig();
        if (config != null) {
            return config.getManagedBean(name) != null;
        }
        return false;
    }

    public void destroy(String name, Object instance) {
        this.destroy(name, instance, this.getCurrentLifecycleProvider());
    }

    public void destroy(String name, Object instance, LifecycleProvider provider) {
        if (this.isManagedBean(name)) {
            if (provider == null) {
                provider = this.getCurrentLifecycleProvider();
            }
            try {
                provider.destroyInstance(instance);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, "Could not access @PreDestroy method of managed bean " + name, e);
            }
            catch (InvocationTargetException e) {
                log.log(Level.SEVERE, "An Exception occured while invoking @PreDestroy method of managed bean " + name, e);
            }
        }
    }

    public LifecycleProvider getCurrentLifecycleProvider() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return LifecycleProviderFactory.getLifecycleProviderFactory().getLifecycleProvider(null);
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        return LifecycleProviderFactory.getLifecycleProviderFactory().getLifecycleProvider(externalContext);
    }
}

