/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.as.lifecycle;

import org.jboss.bootstrap.api.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventHandler;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.bootstrap.api.mc.server.MCBasedServer;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.event.AbstractEvent;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.logging.Logger;

public abstract class AbstractKernelEventLifecycleEventHandler
implements LifecycleEventHandler {
    private static final Logger log = Logger.getLogger(AbstractKernelEventLifecycleEventHandler.class);
    private MCBasedServer<?, ?> server;

    public AbstractKernelEventLifecycleEventHandler(MCBasedServer<?, ?> server) throws IllegalArgumentException {
        if (server == null) {
            throw new IllegalArgumentException("server is required");
        }
        this.server = server;
    }

    public final void handleEvent(LifecycleState state) throws LifecycleEventException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Handling server state change to: " + state));
        }
        Kernel kernel = this.server.getKernel();
        KernelEventManager eventMgr = kernel.getEventManager();
        long currentTime = System.currentTimeMillis();
        String type = this.getNotificationType();
        AbstractEvent event = new AbstractEvent((Object)eventMgr, type, 0L, currentTime, (Object)new Long(currentTime));
        eventMgr.fireKernelEvent((KernelEvent)event);
        log.debug((Object)("Fired: " + event));
    }

    protected abstract String getNotificationType();
}

