/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.temp;

import java.io.File;
import org.jboss.bootstrap.api.config.ServerConfig;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventHandler;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.bootstrap.api.server.Server;

public class TmpDirCleanupService
implements LifecycleEventHandler {
    private Server server;
    private File tmp;

    public TmpDirCleanupService(Server server) {
        if (server == null) {
            throw new IllegalArgumentException("Null server");
        }
        this.server = server;
    }

    public void start() {
        this.server.registerEventHandler((LifecycleEventHandler)this, new LifecycleState[]{LifecycleState.STOPPED, LifecycleState.IDLE});
        ServerConfig config = this.server.getConfiguration();
        String property = config.getProperty("jboss.server.temp.dir");
        if (property != null) {
            this.tmp = new File(property);
        }
    }

    public void handleEvent(LifecycleState state) throws LifecycleEventException {
        if (state == LifecycleState.STOPPED) {
            File[] files;
            if (this.tmp != null && this.tmp.exists() && (files = this.tmp.listFiles()) != null) {
                for (File f : files) {
                    TmpDirCleanupService.delete(f);
                }
            }
        } else if (state == LifecycleState.IDLE) {
            this.server.unregisterEventHandler((LifecycleEventHandler)this, LifecycleState.STOPPED);
            this.server.unregisterEventHandler((LifecycleEventHandler)this, LifecycleState.IDLE);
            this.server = null;
        }
    }

    private static boolean delete(File dir) {
        boolean success = true;
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    if (TmpDirCleanupService.delete(f)) continue;
                    success = false;
                    continue;
                }
                if (f.delete()) continue;
                success = false;
            }
        }
        if (!dir.delete()) {
            success = false;
        }
        return success;
    }
}

