/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractNameIgnoreMechanism;
import org.jboss.deployers.spi.deployer.matchers.NameIgnoreMechanism;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer;
import org.jboss.deployment.JBossAppParsingDeployerMBean;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.ModulesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMX(name="jboss.j2ee:service=EARDeployer", exposedInterface=JBossAppParsingDeployerMBean.class)
public class JBossAppParsingDeployer
extends SchemaResolverDeployer<JBossAppMetaData>
implements JBossAppParsingDeployerMBean {
    private boolean callByValue = false;
    private String unauthenticatedIdentity = null;

    public JBossAppParsingDeployer() {
        super(JBossAppMetaData.class);
        this.addInput(EarMetaData.class);
        this.addInput(JBossAppMetaData.class);
        this.setName("jboss-app.xml");
        this.setTopLevelOnly(true);
        this.setNameIgnoreMechanism((NameIgnoreMechanism)new NonEarJBossAppNameIgnoreMechanism());
    }

    protected boolean allowsReparse() {
        return true;
    }

    public String getAppXmlPath() {
        return this.getName();
    }

    public void setAppXmlPath(String appXmlPath) {
        this.setName(appXmlPath);
    }

    @Override
    public boolean isCallByValue() {
        return this.callByValue;
    }

    @Override
    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    public String getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    public void setUnauthenticatedIdentity(String unauthenticatedIdentity) {
        this.unauthenticatedIdentity = unauthenticatedIdentity;
    }

    protected void createMetaData(DeploymentUnit unit, String name, String suffix) throws DeploymentException {
        ModulesMetaData mmd;
        EarMetaData specMetaData = (EarMetaData)unit.getAttachment(EarMetaData.class);
        JBossAppMetaData metaData = (JBossAppMetaData)unit.getAttachment(JBossAppMetaData.class);
        super.createMetaData(unit, name, suffix);
        JBossAppMetaData parsed = (JBossAppMetaData)unit.getAttachment(JBossAppMetaData.class);
        if (metaData != null && parsed != null && (mmd = metaData.getModules()) != null && !mmd.isEmpty()) {
            ModulesMetaData parsedMMD = parsed.getModules();
            if (parsedMMD == null) {
                parsedMMD = new ModulesMetaData();
                parsed.setModules(parsedMMD);
            }
            parsedMMD.merge(parsedMMD, mmd);
        }
        metaData = parsed;
        if (specMetaData == null && metaData == null) {
            return;
        }
        if (metaData == null) {
            metaData = new JBossAppMetaData();
        }
        JBossAppMetaData mergedMetaData = new JBossAppMetaData();
        mergedMetaData.merge(metaData, specMetaData);
        unit.getTransientManagedObjects().addAttachment(JBossAppMetaData.class, (Object)mergedMetaData);
        unit.addAttachment("Raw" + JBossAppMetaData.class.getName(), (Object)metaData, JBossAppMetaData.class);
        if (this.isCallByValue()) {
            unit.addAttachment("EAR.callByValue", (Object)Boolean.TRUE, Boolean.class);
        }
        if (this.unauthenticatedIdentity != null) {
            unit.addAttachment("EAR.unauthenticatedIdentity", (Object)this.unauthenticatedIdentity, String.class);
        }
    }

    private static class NonEarJBossAppNameIgnoreMechanism
    extends AbstractNameIgnoreMechanism {
        private NonEarJBossAppNameIgnoreMechanism() {
        }

        public boolean ignoreName(DeploymentUnit unit, String name) {
            return false;
        }

        public boolean ignorePath(DeploymentUnit unit, String path) {
            String simpleName = unit.getSimpleName();
            return !simpleName.endsWith(".ear");
        }
    }
}

