/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Constructor;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Map;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.BeanLockExt;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.plugins.AbstractInstanceCacheMBean;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.jboss.monitor.MetricsConstants;
import org.jboss.monitor.Monitorable;
import org.jboss.monitor.client.BeanCacheSnapshot;
import org.jboss.util.CachePolicy;
import org.w3c.dom.Element;

public abstract class AbstractInstanceCache
implements InstanceCache,
XmlLoadable,
Monitorable,
MetricsConstants,
AbstractInstanceCacheMBean {
    protected static Logger log = Logger.getLogger(AbstractInstanceCache.class);
    private CachePolicy m_cache;
    private final Object m_cacheLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(Object s) {
        if (this.m_cache == null) {
            return;
        }
        Object object = this.getCacheLock();
        synchronized (object) {
            BeanCacheSnapshot snapshot = (BeanCacheSnapshot)s;
            snapshot.m_passivatingBeans = 0;
            CachePolicy policy = this.getCache();
            if (policy instanceof Monitorable) {
                ((Monitorable)policy).sample(s);
            }
        }
    }

    public Map retrieveStatistic() {
        return null;
    }

    public void resetStatistic() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseContext get(Object id) throws RemoteException, NoSuchObjectException {
        EnterpriseContext ctx;
        if (id == null) {
            throw new IllegalArgumentException("Can't get an object with a null key");
        }
        Object object = this.getCacheLock();
        synchronized (object) {
            CachePolicy cache = this.getCache();
            ctx = (EnterpriseContext)cache.get(id);
            if (ctx == null) {
                try {
                    ctx = this.acquireContext();
                    this.setKey(id, ctx);
                    if (!this.doActivate(ctx)) {
                        return ctx;
                    }
                    this.logActivation(id);
                    cache.insert(id, (Object)ctx);
                }
                catch (Throwable x) {
                    log.debug((Object)"Activation failure", x);
                    throw new NoSuchObjectException(x.getMessage());
                }
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(EnterpriseContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Can't insert a null object in the cache");
        }
        Object key = this.getKey(ctx);
        Object object = this.getCacheLock();
        synchronized (object) {
            this.getCache().insert(key, (Object)ctx);
        }
    }

    protected void tryToPassivate(EnterpriseContext ctx) {
        this.tryToPassivate(ctx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryToPassivate(EnterpriseContext ctx, boolean passivateAfterCommit) {
        block18: {
            Object id = ctx.getId();
            if (id == null) {
                return;
            }
            BeanLock lock = this.getContainer().getLockManager().getLock(id);
            boolean lockedBean = false;
            try {
                if (lock instanceof BeanLockExt) {
                    BeanLockExt lock2 = (BeanLockExt)lock;
                    lockedBean = lock2.attemptSync();
                    if (!lockedBean) {
                        this.unableToPassivateDueToCtxLock(ctx, passivateAfterCommit);
                        return;
                    }
                } else {
                    lock.sync();
                    lockedBean = true;
                }
                if (this.canPassivate(ctx)) {
                    ClassLoader ccl = SecurityActions.getContextClassLoader();
                    SecurityActions.setContextClassLoader(this.getContainer().getClassLoader());
                    try {
                        this.remove(id);
                        this.passivate(ctx);
                        this.freeContext(ctx);
                        break block18;
                    }
                    catch (Exception ignored) {
                        log.warn((Object)("failed to passivate, id=" + id), (Throwable)ignored);
                        break block18;
                    }
                    finally {
                        SecurityActions.setContextClassLoader(ccl);
                    }
                }
                Object object = this.getCacheLock();
                synchronized (object) {
                    this.getCache().get(id);
                }
                this.unableToPassivateDueToCtxLock(ctx, passivateAfterCommit);
            }
            finally {
                if (lockedBean) {
                    lock.releaseSync();
                }
                this.getContainer().getLockManager().removeLockRef(id);
            }
        }
    }

    public void release(EnterpriseContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Can't release a null object");
        }
        this.tryToPassivate(ctx, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("Can't remove an object using a null key");
        }
        Object object = this.getCacheLock();
        synchronized (object) {
            if (this.getCache().peek(id) != null) {
                this.getCache().remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(Object id) {
        Object object = this.getCacheLock();
        synchronized (object) {
            return this.getCache().peek(id) != null;
        }
    }

    public long getCacheSize() {
        int cacheSize = this.m_cache != null ? this.m_cache.size() : 0;
        return cacheSize;
    }

    public void flush() {
        if (this.m_cache != null) {
            this.m_cache.flush();
        }
    }

    public long getPassivatedCount() {
        return 0L;
    }

    public String getCachePolicyString() {
        return this.m_cache.toString();
    }

    public void importXml(Element element) throws DeploymentException {
        String p = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)element, (String)"cache-policy"));
        try {
            Class<?> cls = SecurityActions.getContextClassLoader().loadClass(p);
            Constructor<?> ctor = cls.getConstructor(AbstractInstanceCache.class);
            this.m_cache = (CachePolicy)ctor.newInstance(this);
        }
        catch (Exception x) {
            throw new DeploymentException("Can't create cache policy", (Throwable)x);
        }
        Element policyConf = MetaData.getOptionalChild((Element)element, (String)"cache-policy-conf");
        if (policyConf != null && this.m_cache instanceof XmlLoadable) {
            try {
                ((XmlLoadable)this.m_cache).importXml(policyConf);
            }
            catch (Exception x) {
                throw new DeploymentException("Can't import policy configuration", (Throwable)x);
            }
        }
    }

    public void create() throws Exception {
        this.getCache().create();
    }

    public void start() throws Exception {
        this.getCache().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.getCacheLock();
        synchronized (object) {
            this.getCache().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.getCacheLock();
        synchronized (object) {
            this.getCache().destroy();
        }
    }

    protected void logActivation(Object id) {
        if (log.isTraceEnabled()) {
            StringBuffer m_buffer = new StringBuffer(100);
            m_buffer.append("Activated bean ");
            m_buffer.append(this.getContainer().getBeanMetaData().getEjbName());
            m_buffer.append(" with id = ");
            m_buffer.append(id);
            log.trace((Object)m_buffer.toString());
        }
    }

    protected void logPassivation(Object id) {
        if (log.isTraceEnabled()) {
            StringBuffer m_buffer = new StringBuffer(100);
            m_buffer.append("Passivated bean ");
            m_buffer.append(this.getContainer().getBeanMetaData().getEjbName());
            m_buffer.append(" with id = ");
            m_buffer.append(id);
            log.trace((Object)m_buffer.toString());
        }
    }

    protected void unableToPassivateDueToCtxLock(EnterpriseContext ctx, boolean passivateAfterCommit) {
        log.warn((Object)("Unable to passivate due to ctx lock, id=" + ctx.getId()));
    }

    protected abstract Container getContainer();

    protected CachePolicy getCache() {
        return this.m_cache;
    }

    public Object getCacheLock() {
        return this.m_cacheLock;
    }

    protected abstract void passivate(EnterpriseContext var1) throws RemoteException;

    protected abstract void activate(EnterpriseContext var1) throws RemoteException;

    protected boolean doActivate(EnterpriseContext ctx) throws RemoteException {
        this.activate(ctx);
        return true;
    }

    protected abstract EnterpriseContext acquireContext() throws Exception;

    protected abstract void freeContext(EnterpriseContext var1);

    protected abstract Object getKey(EnterpriseContext var1);

    protected abstract void setKey(Object var1, EnterpriseContext var2);

    protected abstract boolean canPassivate(EnterpriseContext var1);
}

