/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.Tag;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.annotation.creator.AnnotationContext;
import org.jboss.metadata.annotation.creator.web.Web30MetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.scanning.web.spi.ResourcesIndex;
import org.jboss.vfs.VirtualFile;
import org.jboss.web.deployers.WarAnnotationMetaDataDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecCompliantWarAnnotationDeployer
extends WarAnnotationMetaDataDeployer {
    @Override
    protected void processMetaData(VFSDeploymentUnit unit, List<VirtualFile> classpath) throws Exception {
        Collection<Class<?>> specEligibleResourceInjectionClasses;
        ResourcesIndex resourceIndex = (ResourcesIndex)unit.getAttachment(ResourcesIndex.class);
        if (resourceIndex == null) {
            return;
        }
        DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
        Web30MetaDataCreator creator = new Web30MetaDataCreator((AnnotationFinder)finder);
        HashSet annotations = new HashSet();
        AnnotationContext annotationContext = creator.getAnnotationContext();
        if (annotationContext.getTypeAnnotations() != null) {
            annotations.addAll(annotationContext.getTypeAnnotations());
        }
        if (annotationContext.getMethodAnnotations() != null) {
            annotations.addAll(annotationContext.getMethodAnnotations());
        }
        if (annotationContext.getFieldAnnotations() != null) {
            annotations.addAll(annotationContext.getFieldAnnotations());
        }
        if ((specEligibleResourceInjectionClasses = this.getResourceInjectionEligibleWebAppClasses(resourceIndex, classpath)).isEmpty()) {
            return;
        }
        boolean metaData = false;
        for (VirtualFile path : classpath) {
            HashSet eligibleAnnotatedClasses = new HashSet();
            for (Class annotation : annotations) {
                Set annotatedClasses = resourceIndex.getAnnotatedClasses(path, annotation);
                eligibleAnnotatedClasses.addAll(this.retainResourceInjectionEligibleWebAppClasses(specEligibleResourceInjectionClasses, annotatedClasses));
            }
            Web30MetaData annotationMetaData = creator.create(eligibleAnnotatedClasses);
            if (annotationMetaData == null) continue;
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME + ":" + path.getName(), (Object)annotationMetaData, WebMetaData.class);
            metaData = true;
        }
        if (metaData) {
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME, (Object)Boolean.TRUE);
        }
    }

    protected Collection<Class<?>> getResourceInjectionEligibleWebAppClasses(ResourcesIndex resourceIndex, List<VirtualFile> classpath) {
        HashSet eligibleClasses = new HashSet();
        for (VirtualFile file : classpath) {
            Set simpleTags;
            Set jspTags;
            Set asyncListeners;
            Set httpSessionAttrListeners;
            Set httpSessionListeners;
            Set servletRequestAttrListeners;
            Set servletRequestListeners;
            Set servletCtxAttributeListeners;
            Set servletContextListeners;
            Set filters;
            Set servlets = resourceIndex.getInheritedClasses(file, Servlet.class);
            if (servlets != null) {
                eligibleClasses.addAll(servlets);
            }
            if ((filters = resourceIndex.getInheritedClasses(file, Filter.class)) != null) {
                eligibleClasses.addAll(filters);
            }
            if ((servletContextListeners = resourceIndex.getInheritedClasses(file, ServletContextListener.class)) != null) {
                eligibleClasses.addAll(servletContextListeners);
            }
            if ((servletCtxAttributeListeners = resourceIndex.getInheritedClasses(file, ServletContextAttributeListener.class)) != null) {
                eligibleClasses.addAll(servletCtxAttributeListeners);
            }
            if ((servletRequestListeners = resourceIndex.getInheritedClasses(file, ServletRequestListener.class)) != null) {
                eligibleClasses.addAll(servletRequestListeners);
            }
            if ((servletRequestAttrListeners = resourceIndex.getInheritedClasses(file, ServletRequestAttributeListener.class)) != null) {
                eligibleClasses.addAll(servletRequestAttrListeners);
            }
            if ((httpSessionListeners = resourceIndex.getInheritedClasses(file, HttpSessionListener.class)) != null) {
                eligibleClasses.addAll(httpSessionListeners);
            }
            if ((httpSessionAttrListeners = resourceIndex.getInheritedClasses(file, HttpSessionAttributeListener.class)) != null) {
                eligibleClasses.addAll(httpSessionAttrListeners);
            }
            if ((asyncListeners = resourceIndex.getInheritedClasses(file, AsyncListener.class)) != null) {
                eligibleClasses.addAll(asyncListeners);
            }
            if ((jspTags = resourceIndex.getInheritedClasses(file, Tag.class)) != null) {
                eligibleClasses.addAll(jspTags);
            }
            if ((simpleTags = resourceIndex.getInheritedClasses(file, SimpleTag.class)) == null) continue;
            eligibleClasses.addAll(simpleTags);
        }
        return eligibleClasses;
    }

    private Collection<Class<?>> retainResourceInjectionEligibleWebAppClasses(Collection<Class<?>> specEligibleClasses, Collection<Class<?>> annotatedClasses) {
        HashSet eligibleClasses = new HashSet();
        block0: for (Class<?> annotatedClass : annotatedClasses) {
            for (Class<?> specEligibleClass : specEligibleClasses) {
                if (!annotatedClass.isAssignableFrom(specEligibleClass)) continue;
                eligibleClasses.add(annotatedClass);
                continue block0;
            }
        }
        return eligibleClasses;
    }
}

