/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.util.List;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HASingletonElectionPolicy;
import org.jboss.ha.singleton.HASingletonElectionPolicySimpleMBean;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HASingletonElectionPolicySimple
implements HASingletonElectionPolicy,
HASingletonElectionPolicySimpleMBean {
    private int mPosition = 0;
    private static Logger LOG = Logger.getLogger(HASingletonElectionPolicySimple.class);

    @Override
    public void setPosition(int pos) {
        this.mPosition = pos;
    }

    @Override
    public int getPosition() {
        return this.mPosition;
    }

    public ClusterNode elect(List<ClusterNode> candidates) {
        int size = candidates.size();
        int remainder = (this.mPosition % size + size) % size;
        ClusterNode result = candidates.get(remainder);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("election with " + size + " nodes and position=" + this.mPosition + ", will choose node[" + remainder + "] picked node ip=" + result.getIpAddress() + " port=" + result.getPort()));
        }
        return result;
    }
}

