/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.visitor;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.scanning.plugins.visitor.ReflectProvider;

public class CachingReflectProvider
implements ReflectProvider {
    private ReflectProvider delegate;
    private volatile Map<ResourceContext, TypeInfo> cache = new HashMap<ResourceContext, TypeInfo>();

    public CachingReflectProvider(ReflectProvider delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
    }

    public TypeInfo getTypeInfo(ResourceContext resource) throws Throwable {
        TypeInfo result = this.cache.get(resource);
        if (result == null) {
            result = this.delegate.getTypeInfo(resource);
            this.cache.put(resource, result);
        }
        return result;
    }

    public void reset() {
        Map<ResourceContext, TypeInfo> tmp = this.cache;
        this.cache = new AbstractMap<ResourceContext, TypeInfo>(){

            @Override
            public Set<Map.Entry<ResourceContext, TypeInfo>> entrySet() {
                return Collections.emptySet();
            }

            @Override
            public TypeInfo put(ResourceContext key, TypeInfo value) {
                return null;
            }
        };
        tmp.clear();
    }
}

