/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso;

import com.pugh.sockso.CachedObject;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ObjectCache {
    private static final Logger log = Logger.getLogger(ObjectCache.class);
    private Hashtable<String, CachedObject> data = new Hashtable();

    public boolean isCached(String key) {
        CachedObject object = this.readRaw(key);
        boolean isCached = object != null && !object.isExpired();
        log.debug((Object)("Cache " + (isCached ? "hit" : "miss") + " for " + key));
        return isCached;
    }

    public void write(String key, Object value) {
        this.write(key, value, -1);
    }

    public void write(String key, Object value, int timeout) {
        log.debug((Object)("Write key " + key + (timeout != -1 ? " expires in " + timeout + " seconds" : "")));
        this.data.put(key, new CachedObject(value, timeout));
    }

    public Object read(String key) {
        CachedObject object = this.data.get(key);
        return this.isCacheOk(object) ? object.getValue() : null;
    }

    private boolean isCacheOk(CachedObject object) {
        return object != null && !object.isExpired();
    }

    private CachedObject readRaw(String key) {
        return this.data.get(key);
    }
}

