/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.db;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.AbstractDatabase;
import com.pugh.sockso.db.Database;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public abstract class JDBCDatabase
extends AbstractDatabase
implements Database {
    private static final Logger log = Logger.getLogger(JDBCDatabase.class);

    public ResultSet query(String sql) throws SQLException {
        return this.query(sql, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet query(String sql, boolean closeStatement) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        log.debug((Object)sql);
        try {
            st = this.getConnection().createStatement();
            rs = st.executeQuery(sql);
        }
        finally {
            if (closeStatement) {
                Utils.close(st);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql) throws SQLException {
        int n;
        Statement st = null;
        log.debug((Object)sql);
        try {
            Connection cnn = this.getConnection();
            st = cnn.createStatement();
            n = st.executeUpdate(sql);
        }
        catch (Throwable throwable) {
            Utils.close(st);
            throw throwable;
        }
        Utils.close(st);
        return n;
    }

    protected boolean safeUpdate(String sql) {
        try {
            this.update(sql);
            return true;
        }
        catch (SQLException e) {
            log.debug((Object)e);
            return false;
        }
    }

    public PreparedStatement prepare(String sql) throws SQLException {
        Connection cnn = this.getConnection();
        return cnn.prepareStatement(sql);
    }

    protected boolean setProperty(String name, String value) {
        try {
            if (this.propertyExists(name)) {
                this.updateProperty(name, value);
            } else {
                this.createProperty(name, value);
            }
            return true;
        }
        catch (SQLException e) {
            log.error((Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean propertyExists(String name) throws SQLException {
        boolean bl;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = " select 1  from properties p  where p.name = ? ";
            st = this.prepare(" select 1  from properties p  where p.name = ? ");
            st.setString(1, name);
            rs = st.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateProperty(String name, String value) throws SQLException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = " update properties  set value = ?  where name = ? ";
            st = this.prepare(" update properties  set value = ?  where name = ? ");
            st.setString(1, value);
            st.setString(2, name);
            boolean bl = st.execute();
            return bl;
        }
        finally {
            Utils.close(rs);
            Utils.close(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createProperty(String name, String value) throws SQLException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = " insert into properties ( name, value )  values ( ?, ? ) ";
            st = this.prepare(" insert into properties ( name, value )  values ( ?, ? ) ");
            st.setString(1, name);
            st.setString(2, value);
            boolean bl = st.execute();
            return bl;
        }
        finally {
            Utils.close(rs);
            Utils.close(st);
        }
    }

    protected void setDefaultProperties() throws SQLException {
        this.update("insert into properties ( name, value ) values ( 'server.port', '4444' )");
        this.update("insert into properties ( name, value ) values ( 'server.basepath', '/' )");
        this.update("insert into properties ( name, value ) values ( 'www.title', 'Sockso' )");
        this.update("insert into properties ( name, value ) values ( 'www.tagline', 'Personal Music Server' )");
        this.update("insert into properties ( name, value ) values ( 'www.disableDownloads', 'no' )");
        this.update("insert into properties ( name, value ) values ( 'collman.scan.interval', 5 )");
        this.update("insert into properties ( name, value ) values ( 'collman.scan.onStart', 'yes' )");
        this.update("insert into properties ( name, value ) values ( 'app.confirmExit', 'yes' )");
        this.update("insert into properties ( name, value ) values ( 'app.startMinimized', 'no' )");
    }

    protected static String getDefaultDatabasePath(String dbType) {
        return new File(Utils.getApplicationDirectory()).getAbsolutePath() + "/database" + dbType;
    }

    protected void checkAlbumYearColumnExists() {
        String sql = " alter table albums  add year varchar(20) null";
        this.safeUpdate(" alter table albums  add year varchar(20) null");
    }

    protected void checkUserIsActiveColumnExists() {
        try {
            String sql = " alter table users  add is_active char(1) default '1' not null ";
            this.update(" alter table users  add is_active char(1) default '1' not null ");
        }
        catch (SQLException e) {
            log.info((Object)e.getMessage());
        }
    }
}

