/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.pugh.sockso.Main;
import com.pugh.sockso.Manager;
import com.pugh.sockso.Properties;
import com.pugh.sockso.PropertiesListener;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.events.LatestVersionEvent;
import com.pugh.sockso.gui.CollectionPanel;
import com.pugh.sockso.gui.ConsoleFrame;
import com.pugh.sockso.gui.EncodersPanel;
import com.pugh.sockso.gui.GeneralPanel;
import com.pugh.sockso.gui.MusicPanel;
import com.pugh.sockso.gui.Splash;
import com.pugh.sockso.gui.TrayIcon;
import com.pugh.sockso.gui.UrlLabelMouseAdapter;
import com.pugh.sockso.gui.UsersPanel;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.IpFinder;
import com.pugh.sockso.web.Server;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class AppFrame
extends JFrame
implements PropertiesListener,
Manager {
    private static final Logger log = Logger.getLogger(AppFrame.class);
    private final Database db;
    private final Properties p;
    private final CollectionManager cm;
    protected final Server sv;
    protected final Resources r;
    protected final IpFinder ipFinder;
    private TrayIcon tray = null;
    private JLabel urlLabel;
    private ConsoleFrame consoleFrame;

    public AppFrame(Database db, Properties p, Server sv, CollectionManager cm, Resources r, IpFinder ipFinder) {
        super(r == null ? "" : r.getCurrentLocale().getString("gui.window.main") + " (" + "1.3.3" + ")");
        this.db = db;
        this.p = p;
        this.sv = sv;
        this.cm = cm;
        this.r = r;
        this.ipFinder = ipFinder;
        this.urlLabel = new JLabel();
        this.tray = new TrayIcon(this, r);
    }

    protected void initComponents() {
        log.debug((Object)"Setting Look & Feel");
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        log.debug((Object)"Initialising TrayIcon");
        this.tray.init();
        log.debug((Object)"Initialising GUI components");
    }

    protected void layoutComponents() {
        log.debug((Object)"Laying out GUI components");
        this.setIconImage(this.r.getImage("icons/16x16/sockso.png"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPane(), "Center");
        this.add((Component)this.getBottomPane(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (AppFrame.this.tray.isActive()) {
                    AppFrame.this.toggleVisibility();
                } else {
                    AppFrame.this.exit();
                }
            }
        });
        this.setSize(new Dimension(700, 500));
        this.setLocationRelativeTo(null);
        this.p.addPropertiesListener(this);
        Splash.close();
    }

    public void open() {
        this.initComponents();
        this.layoutComponents();
        boolean setVisible = true;
        if (this.tray.isActive() && this.p.get("app.startMinimized").equals("yes")) {
            setVisible = false;
        }
        this.setVisible(setVisible);
    }

    public void exit() {
        if (this.p.get("app.confirmExit").equals("yes") && JOptionPane.showConfirmDialog(this, "Are you sure you want to exit?", "Exit Sockso", 0) != 0) {
            return;
        }
        Main.exit();
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    private JPanel getBottomPane() {
        Locale locale = this.r.getCurrentLocale();
        JButton exit = new JButton(locale.getString("gui.label.exit"), new ImageIcon(this.r.getImage("icons/22x22/exit.png")));
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AppFrame.this.exit();
            }
        });
        JButton hide = new JButton(locale.getString("gui.label.hide"), new ImageIcon(this.r.getImage("icons/22x22/hide.png")));
        hide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AppFrame.this.setVisible(false);
            }
        });
        JButton console = new JButton(locale.getString("gui.label.showConsoleWindow"), new ImageIcon(this.r.getImage("icons/22x22/console.png")));
        console.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (AppFrame.this.consoleFrame == null) {
                    AppFrame.this.consoleFrame = new ConsoleFrame(AppFrame.this.db, AppFrame.this.p, AppFrame.this.cm, AppFrame.this.r);
                    AppFrame.this.consoleFrame.setBounds(100, 100, 600, 500);
                }
                AppFrame.this.consoleFrame.setVisible(true);
            }
        });
        if (this.sv != null) {
            this.urlLabel.setText(locale.getString("gui.label.gettingIPAddress"));
            this.urlLabel.addMouseListener(new UrlLabelMouseAdapter(this, this.sv, this.r, this.ipFinder));
            this.urlLabel.setToolTipText("Click to open Sockso in your browser.");
            this.updateUrlLabel();
        }
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        buttons.add(console);
        buttons.add(exit);
        if (this.tray.isActive()) {
            buttons.add(hide);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)buttons, "East");
        panel.add((Component)this.urlLabel, "West");
        return panel;
    }

    protected void updateUrlLabel() {
        String myurl = this.sv.getProtocol() + "://" + this.sv.getHost();
        Locale locale = this.r.getCurrentLocale();
        this.urlLabel.setText("<html><head><title></title></head><body>&nbsp; " + locale.getString("gui.label.yourAddress") + ": <a href='" + myurl + "'>" + myurl + "</a>" + "</body></html>");
    }

    protected JLabel getUrlLabel() {
        return this.urlLabel;
    }

    private JTabbedPane getMainPane() {
        JTabbedPane pane = new JTabbedPane();
        Locale locale = this.r.getCurrentLocale();
        MusicPanel musicPanel = new MusicPanel(this, this.db, this.cm, this.r);
        musicPanel.init();
        UsersPanel usersPanel = new UsersPanel(this, this.db, this.p, this.r);
        usersPanel.init();
        pane.addTab(locale.getString("gui.label.music"), new ImageIcon(this.r.getImage("icons/22x22/music.png")), musicPanel, locale.getString("gui.tooltip.music"));
        pane.addTab(locale.getString("gui.label.collection"), new ImageIcon(this.r.getImage("icons/22x22/collection.png")), new CollectionPanel(this, this.db, this.cm, this.r, this.p), locale.getString("gui.tooltip.collection"));
        pane.addTab(locale.getString("gui.label.users"), new ImageIcon(this.r.getImage("icons/22x22/users.png")), usersPanel, locale.getString("gui.tooltip.users"));
        pane.addTab(locale.getString("gui.label.general"), new ImageIcon(this.r.getImage("icons/22x22/general.png")), new GeneralPanel(this, this.db, this.p, this.r, this.sv, this.cm), locale.getString("gui.tooltip.general"));
        pane.addTab(locale.getString("gui.label.encoders"), new ImageIcon(this.r.getImage("icons/22x22/encoders.png")), new EncodersPanel(this, this.p, this.r), locale.getString("gui.tooltip.encoders"));
        return pane;
    }

    public void close() {
        log.info((Object)"Closing GUI");
        this.setVisible(false);
        this.dispose();
    }

    public void propertiesSaved(Properties p) {
        this.updateUrlLabel();
    }

    public void latestVersionReceived(LatestVersionEvent evt) {
        String latestVersion = evt.getVersion();
        if (latestVersion != null && !latestVersion.equals("1.3.3")) {
            Locale locale = this.r.getCurrentLocale();
            String message = locale.getString("misc.msg.updateAvailable", new String[]{latestVersion});
            JOptionPane.showMessageDialog(this, message, "Sockso", 1);
        }
    }
}

