/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui.controls;

import com.pugh.sockso.Properties;
import com.pugh.sockso.resources.Locale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DirectoryOptionField
extends JPanel
implements ActionListener {
    private Properties p;
    private String name;
    private JFrame parent;
    private JButton browse;
    private JTextField field;

    public DirectoryOptionField(JFrame parent, Properties p, String name, Locale locale) {
        this.parent = parent;
        this.p = p;
        this.name = name;
        this.initComponents(locale);
        this.initLayout();
    }

    private void initComponents(Locale locale) {
        this.browse = new JButton(locale.getString("gui.label.browse"));
        this.browse.addActionListener(this);
        this.field = new JTextField();
        this.field.setEditable(false);
        this.setPath(this.p.get(this.name));
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.field, "Center");
        this.add((Component)this.browse, "East");
    }

    protected void setPath(String path) {
        this.field.setText(path);
    }

    public void actionPerformed(ActionEvent evt) {
        File folder = null;
        folder = this.chooseFolder();
        if (folder != null) {
            String path = folder.getAbsolutePath();
            this.p.set(this.name, path);
            this.p.save();
            this.setPath(path);
        }
    }

    protected File chooseFolder() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        return chooser.showOpenDialog(this.parent) == 0 ? chooser.getSelectedFile() : null;
    }
}

