/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.encoders;

import com.pugh.sockso.music.encoders.BuiltinEncoder;
import com.pugh.sockso.music.encoders.FfmpegToLame;
import com.pugh.sockso.music.encoders.FlacToLame;
import com.pugh.sockso.music.encoders.LameEncoder;
import com.pugh.sockso.music.encoders.OggDecToLame;
import java.util.Vector;

public class Encoders {
    public static Builtin[] getBuiltinEncoders(String format) {
        Vector<Builtin> builtins = new Vector<Builtin>();
        for (Builtin b : Builtin.values()) {
            for (String supportedFormat : b.getEncoder().getSupportedFormats()) {
                if (!format.toLowerCase().equals(supportedFormat.toLowerCase())) continue;
                builtins.addElement(b);
            }
        }
        return builtins.toArray(new Builtin[builtins.size()]);
    }

    public static Builtin getBuiltinEncoderByName(String name) {
        for (Builtin b : Builtin.values()) {
            if (!b.name().equals(name)) continue;
            return b;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Builtin {
        Lame(new LameEncoder()),
        OggDecToLame(new OggDecToLame()),
        FlacToLame(new FlacToLame()),
        FfmpegToLame(new FfmpegToLame());

        private BuiltinEncoder encoder;

        private Builtin(BuiltinEncoder encoder) {
            this.encoder = encoder;
        }

        public BuiltinEncoder getEncoder() {
            return this.encoder;
        }

        public String toString() {
            return this.encoder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NONE,
        BUILTIN,
        CUSTOM;

    }
}

