/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.Response;
import com.pugh.sockso.web.action.AmazonCoverSearch;
import com.pugh.sockso.web.action.WebAction;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class FileServer
extends WebAction {
    private static final Logger log = Logger.getLogger(FileServer.class);
    private static final String CACHE_IMAGE_TYPE = "jpg";
    private final Resources r;

    public FileServer(Resources r) {
        this.r = r;
    }

    public void handleRequest() throws IOException, BadRequestException, SQLException {
        Request req = this.getRequest();
        Response res = this.getResponse();
        String type = req.getUrlParam(1);
        res.setCookiesEnabled(false);
        if (type.equals("cover")) {
            this.serveCover();
        } else {
            this.serveFile();
        }
    }

    public boolean requiresLogin() {
        return false;
    }

    public void serveFile() throws IOException, BadRequestException {
        Request req = this.getRequest();
        String path = "htdocs";
        for (int i = 1; i < req.getParamCount(); ++i) {
            path = path + "/" + req.getUrlParam(i);
        }
        this.serveResource(path);
    }

    private void serveResource(String path) throws IOException, BadRequestException {
        DataInputStream in = null;
        Locale locale = this.getLocale();
        String ext = Utils.getExt(path).toLowerCase();
        for (String gzipExt : new String[]{"css", "js"}) {
            if (!gzipExt.equals(ext)) continue;
            this.getResponse().enableGzip();
        }
        try {
            in = new DataInputStream(this.r.getResourceAsStream(path));
            this.sendHeaders(path);
            this.getResponse().sendData(in);
        }
        catch (FileNotFoundException e) {
            try {
                throw new BadRequestException(locale.getString("www.error.fileNotFound"), 404);
            }
            catch (Throwable throwable) {
                Utils.close(in);
                throw throwable;
            }
        }
        Utils.close(in);
    }

    protected void sendHeaders(String filename) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        Date dateNow = new Date();
        Date dateModified = new Date(dateNow.getTime() - 604800000L);
        Date dateExpires = new Date(dateNow.getTime() + 604800000L);
        Response res = this.getResponse();
        Properties p = this.getProperties();
        if (!p.get("dev.enabled").equals("yes")) {
            res.addHeader("Date", formatter.format(dateNow));
            res.addHeader("Last-Modified", formatter.format(dateModified));
            res.addHeader("Expires", formatter.format(dateExpires));
        }
        res.addHeader("Cache-Control", "public");
        res.addHeader("Pragma", "public");
        res.addHeader("Content-type", FileServer.getMimeType(filename));
        res.sendHeaders();
    }

    public void serveCover() throws IOException, SQLException, BadRequestException {
        Database db;
        AmazonCoverSearch search;
        BufferedImage cover;
        Request req = this.getRequest();
        Properties p = this.getProperties();
        Locale locale = this.getLocale();
        String itemName = req.getUrlParam(2);
        if (p.get("www.covers.disable").equals("yes")) {
            throw new BadRequestException(locale.getString("www.error.coversDisabled"), 404);
        }
        if (this.serveCoverCache(itemName)) {
            return;
        }
        String localPath = this.getLocalCoverPath(itemName);
        if (localPath != null) {
            this.serveLocalCover(itemName, localPath);
            return;
        }
        if (!p.get("www.covers.disableRemoteFetching").equals("yes") && (cover = (search = new AmazonCoverSearch(db = this.getDatabase())).getCover(itemName)) != null) {
            this.serveCover(cover, itemName, true);
            return;
        }
        this.serveCover(this.getNoCoverImage(), "noCover", false);
    }

    private BufferedImage getNoCoverImage() {
        Locale locale = this.getLocale();
        BufferedImage cover = new BufferedImage(115, 115, 1);
        Graphics2D g = cover.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 115, 115);
        g.setColor(new Color(200, 200, 200));
        g.drawRect(0, 0, 114, 114);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.BLACK);
        g.setFont(new Font("Verdana", 2, 10));
        g.drawString(locale.getString("www.text.noCover"), 10, 20);
        return cover;
    }

    private void serveCover(BufferedImage cover, String itemName, boolean addToCache) throws IOException {
        Request req = this.getRequest();
        if (addToCache) {
            ImageIO.write((RenderedImage)cover, CACHE_IMAGE_TYPE, new File(this.getCoverCachePath(itemName)));
        }
        if (req.hasArgument("width") && req.hasArgument("height")) {
            int width = Integer.parseInt(req.getArgument("width"));
            int height = Integer.parseInt(req.getArgument("height"));
            log.debug((Object)("Scaling cover to " + width + ":" + height));
            cover = this.scale(cover, width, height);
        }
        this.sendHeaders(itemName + "." + CACHE_IMAGE_TYPE);
        ImageIO.write((RenderedImage)cover, CACHE_IMAGE_TYPE, this.getResponse().getOutputStream());
    }

    protected void serveLocalCover(String itemName, String localPath) throws IOException {
        Properties p = this.getProperties();
        BufferedImage originalImage = ImageIO.read(new File(localPath));
        BufferedImage resizedImage = this.scale(originalImage, (int)p.get("covers.defaultWidth", 115L), (int)p.get("covers.defaultHeight", 115L));
        this.serveCover(resizedImage, itemName, p.get("covers.cacheLocal").equals("yes"));
    }

    private BufferedImage scale(BufferedImage origImage, int width, int height) {
        int origWidth = origImage.getWidth();
        int origHeight = origImage.getHeight();
        if (width >= origWidth && height >= origHeight) {
            return origImage;
        }
        return this.scale(origImage, this.calcScalingFactor(origWidth, origHeight, width, height));
    }

    public BufferedImage scale(Image p_image, double p_dScaleFactor) {
        int iWidth = (int)((double)p_image.getWidth(null) * p_dScaleFactor);
        int iHeight = (int)((double)p_image.getHeight(null) * p_dScaleFactor);
        BufferedImage bufferedImage = new BufferedImage(iWidth, iHeight, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(p_image, 0, 0, iWidth, iHeight, null);
        return bufferedImage;
    }

    public double calcScalingFactor(int srcWidth, int srcHeight, int targetWidth, int targetHeight) {
        boolean tall = srcHeight > srcWidth;
        double factor = (double)(tall ? targetHeight : targetWidth) / (double)(tall ? srcHeight : srcWidth);
        return factor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File[] getLocalCoverDirectories(String itemName) throws SQLException {
        Vector<File> dirs = new Vector<File>();
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            HashSet<String> taken = new HashSet<String>();
            String type = itemName.substring(0, 2);
            int id = Integer.parseInt(itemName.substring(2));
            boolean isArtist = type.equals("ar");
            String typeName = isArtist ? "artist" : "album";
            String sql = " select t.path as path  from tracks t  where t." + typeName + "_id = " + id;
            Database db = this.getDatabase();
            st = db.prepare(sql);
            rs = st.executeQuery();
            while (rs.next()) {
                String path = rs.getString("path");
                if (taken.contains(path)) continue;
                dirs.add(new File(path));
                taken.add(path);
            }
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return dirs.toArray(new File[0]);
    }

    protected boolean isArtist(String itemName) {
        return itemName != null && itemName.length() > 2 && itemName.substring(0, 2).toLowerCase().equals("ar");
    }

    protected String getLocalCoverFileName(String itemName) {
        Properties p = this.getProperties();
        String typeName = this.isArtist(itemName) ? "artist" : "album";
        return p.get(this.isArtist(itemName) ? "covers.artist.file" : "covers.album.file", typeName);
    }

    protected File[] getLocalCoverFiles(File[] trackDirs, String coverFileName, boolean isArtist) {
        Vector<File> files = new Vector<File>();
        String[] exts = new String[]{CACHE_IMAGE_TYPE, "png", "gif"};
        for (File track : trackDirs) {
            String[] dirs;
            for (String directory : dirs = new String[]{track.getParent(), isArtist ? track.getParentFile().getParent() : null}) {
                if (directory == null) continue;
                for (String ext : exts) {
                    String path = directory + "/" + coverFileName + "." + ext;
                    files.add(new File(path));
                }
            }
        }
        return files.toArray(new File[0]);
    }

    protected String getLocalCoverPath(String itemName) throws SQLException {
        File[] possibleCovers;
        String coverFileName = this.getLocalCoverFileName(itemName);
        File[] trackDirs = this.getLocalCoverDirectories(itemName);
        for (File possibleCover : possibleCovers = this.getLocalCoverFiles(trackDirs, coverFileName, this.isArtist(itemName))) {
            if (!possibleCover.exists()) continue;
            return possibleCover.getAbsolutePath();
        }
        return null;
    }

    private boolean serveCoverCache(String itemName) throws IOException {
        File coverFile = new File(this.getCoverCachePath(itemName));
        if (coverFile.exists()) {
            this.serveCover(ImageIO.read(coverFile), itemName, false);
            return true;
        }
        return false;
    }

    private String getCoverCachePath(String name) {
        return Utils.getCoversDirectory() + "/" + name + "." + CACHE_IMAGE_TYPE;
    }

    public static String getMimeType(String path) {
        String ext = Utils.getExt(path);
        String[] mimes = new String[]{"css", "text/css", "js", "text/javascript", "png", "image/png", "gif", "image/gif", "ico", "image/x-icon", "swf", "application/x-shockwave-flash", CACHE_IMAGE_TYPE, "image/jpeg", "mp3", "audio/mpeg", "ogg", "application/ogg", "wma", "audio/x-ms-wma", "asf", "audio/x-ms-asf", "flac", "audio/flac", "xspf", "application/xspf+xml", "pls", "audio/x-scpls", "m3u", "audio/mpegurl", "xml", "text/xml", "m4a", "audio/mp4"};
        for (int i = 0; i < mimes.length; i += 2) {
            if (!mimes[i].equals(ext)) continue;
            return mimes[i + 1];
        }
        return "text/plain";
    }
}

