/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.Validater;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.web.TUpload;
import com.pugh.sockso.templates.web.TUploadComplete;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.UploadFile;
import com.pugh.sockso.web.User;
import com.pugh.sockso.web.action.WebAction;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class Uploader
extends WebAction {
    private static final Logger log = Logger.getLogger(Uploader.class);
    private final CollectionManager cm;

    public Uploader(CollectionManager cm) {
        this.cm = cm;
    }

    public void handleRequest() throws IOException, BadRequestException, SQLException {
        Request req = this.getRequest();
        String type = req.getUrlParam(1);
        this.checkPermissions();
        if (type.equals("do")) {
            this.uploadFile();
        } else {
            this.showUploadForm();
        }
    }

    private void uploadFile() throws BadRequestException {
        this.checkUploadLooksOk();
        Properties p = this.getProperties();
        Request req = this.getRequest();
        Locale locale = this.getLocale();
        UploadFile file = req.getFile("musicFile");
        String artist = req.getArgument("artist");
        String album = req.getArgument("album");
        String track = req.getArgument("title");
        try {
            Database db = this.getDatabase();
            File dir = new File(Utils.getUploadsPath(db, p) + "/" + artist + " - " + album);
            if (!dir.exists() && !dir.mkdir()) {
                throw new BadRequestException(locale.getString("www.error.cantCreateTrackFolder"), 500);
            }
            File tempFile = file.getTemporaryFile();
            File newFile = new File(this.getNewUploadFilename(dir, track, Utils.getExt(file.getFilename())));
            tempFile.renameTo(newFile);
            int collectionId = Integer.parseInt(p.get("uploads.collectionId"));
            this.cm.scanDirectory(collectionId, dir);
            this.cm.fireCollectionManagerEvent(6, "Collection Updated!");
            TUploadComplete tpl = new TUploadComplete();
            tpl.setProperties(p);
            tpl.setUser(this.getUser());
            tpl.setLocale(this.getLocale());
            this.getResponse().showHtml(tpl.makeRenderer());
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    private void checkUploadLooksOk() throws BadRequestException {
        Request req = this.getRequest();
        Locale locale = this.getLocale();
        UploadFile file = req.getFile("musicFile");
        if (file == null) {
            throw new BadRequestException(locale.getString("www.error.noFileUploaded"));
        }
        String contentType = file.getContentType();
        log.debug((Object)("File content type: " + contentType));
        if (!this.isValidContentType(contentType)) {
            throw new BadRequestException(locale.getString("www.error.unsupportedAudioFormat"));
        }
        Database db = this.getDatabase();
        Validater v = new Validater(db);
        String artist = req.getArgument("artist");
        String album = req.getArgument("album");
        String track = req.getArgument("title");
        if (!v.checkRequiredFields(new String[]{artist, album, track})) {
            throw new BadRequestException(locale.getString("www.error.missingField"));
        }
    }

    private String getNewUploadFilename(File dir, String track, String ext) throws BadRequestException {
        Locale locale = this.getLocale();
        int i = -1;
        while (i++ < 100) {
            File file = new File(dir.getAbsolutePath() + "/" + track + (i == 0 ? "" : Integer.valueOf(i)) + "." + ext);
            if (file.exists()) continue;
            return file.getAbsolutePath();
        }
        throw new BadRequestException(locale.getString("www.error.couldNotCreateUniqueFilename"), 500);
    }

    protected boolean isValidContentType(String contentType) {
        String[] validContentTypes;
        for (String validContentType : validContentTypes = new String[]{"audio/mpg", "audio/mpeg", "application/ogg", "audio/x-ms-wma"}) {
            if (!validContentType.equals(contentType)) continue;
            return true;
        }
        return false;
    }

    private void checkPermissions() throws BadRequestException {
        Database db;
        String uploadsPath;
        User user = this.getUser();
        Locale locale = this.getLocale();
        Properties p = this.getProperties();
        Utils.checkFeatureEnabled(p, "uploads.enabled");
        if (user == null) {
            if (!p.get("uploads.allowAnonymous").equals("yes")) {
                throw new BadRequestException(locale.getString("www.error.noAnonymousUploads"), 403);
            }
        }
        if ((uploadsPath = Utils.getUploadsPath(db = this.getDatabase(), p)).equals("")) {
            throw new BadRequestException(locale.getString("www.error.noUploadsDirectory"), 500);
        }
        File uploadsDir = new File(uploadsPath);
        if (!uploadsDir.canWrite()) {
            throw new BadRequestException(locale.getString("www.error.uploadsDirNotWritable"), 500);
        }
    }

    protected void showUploadForm() throws IOException, BadRequestException, SQLException {
        TUpload tpl = new TUpload();
        this.getResponse().showHtml(tpl);
    }
}

