/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action.browse;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.templates.web.browse.TArtist;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.action.WebAction;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artister
extends WebAction {
    @Override
    public void handleRequest() throws IOException, SQLException, BadRequestException {
        Request req = this.getRequest();
        int id = Integer.parseInt(req.getUrlParam(2));
        Artist artist = this.getArtist(id);
        Vector<Album> albums = this.getArtistAlbums(id);
        this.showArtist(artist, albums);
    }

    protected void showArtist(Artist artist, Vector<Album> albums) throws IOException, SQLException {
        TArtist tpl = new TArtist();
        tpl.setArtist(artist);
        tpl.setAlbums(albums);
        this.getResponse().showHtml(tpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Album> getArtistAlbums(int artistId) throws SQLException {
        Vector<Album> vector;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            String sql = " select ar.id as artistId, ar.name as artistName,  al.id as albumId, al.name as albumName, al.year as albumYear, count(t.id) as trackCount  from albums al  inner join artists ar  on ar.id = al.artist_id  left outer join tracks t  on t.album_id = al.id  where al.artist_id = ?  group by artistId, artistName, albumId, albumYear, albumName  order by al.year desc, al.name asc ";
            st = db.prepare(" select ar.id as artistId, ar.name as artistName,  al.id as albumId, al.name as albumName, al.year as albumYear, count(t.id) as trackCount  from albums al  inner join artists ar  on ar.id = al.artist_id  left outer join tracks t  on t.album_id = al.id  where al.artist_id = ?  group by artistId, artistName, albumId, albumYear, albumName  order by al.year desc, al.name asc ");
            st.setInt(1, artistId);
            rs = st.executeQuery();
            Vector<Album> albums = new Vector<Album>();
            while (rs.next()) {
                albums.addElement(new Album(new Artist(rs.getInt("artistId"), rs.getString("artistName")), rs.getInt("albumId"), rs.getString("albumName"), rs.getString("albumYear"), rs.getInt("trackCount")));
            }
            vector = albums;
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Artist getArtist(int artistId) throws SQLException, BadRequestException {
        Artist artist;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            String sql = " select ar.id as id, ar.name as name, ar.date_added as date_added,  count(t.id) as trackCount,  (  select count(*) as playCount  from play_log l  inner join tracks t  on t.id = l.track_id  where t.artist_id = ar.id  ) as playCount  from artists ar  left outer join tracks t  on t.artist_id = ar.id  where ar.id = ?  group by ar.id, ar.name, ar.date_added  limit 1 ";
            st = db.prepare(" select ar.id as id, ar.name as name, ar.date_added as date_added,  count(t.id) as trackCount,  (  select count(*) as playCount  from play_log l  inner join tracks t  on t.id = l.track_id  where t.artist_id = ar.id  ) as playCount  from artists ar  left outer join tracks t  on t.artist_id = ar.id  where ar.id = ?  group by ar.id, ar.name, ar.date_added  limit 1 ");
            st.setInt(1, artistId);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new BadRequestException("artist not found", 404);
            }
            artist = new Artist(rs.getInt("id"), rs.getString("name"), rs.getDate("date_added"), -1, rs.getInt("trackCount"), rs.getInt("playCount"));
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return artist;
    }
}

