/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action.browse;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Collection;
import com.pugh.sockso.templates.web.browse.TFolders;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.action.WebAction;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Folderer
extends WebAction {
    private static final Logger log = Logger.getLogger(Folderer.class);

    @Override
    public void handleRequest() throws IOException, SQLException, BadRequestException {
        Utils.checkFeatureEnabled(this.getProperties(), "browse.folders.enabled");
        this.showFolders(this.getCollections());
    }

    protected void showFolders(Vector<Collection> folders) throws IOException, SQLException {
        TFolders tpl = new TFolders();
        tpl.setFolders(folders);
        this.getResponse().showHtml(tpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Collection> getCollections() throws SQLException {
        Vector<Collection> vector;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            String sql = " select c.id, c.path  from collection c ";
            st = db.prepare(" select c.id, c.path  from collection c ");
            rs = st.executeQuery();
            Vector<Collection> folders = new Vector<Collection>();
            while (rs.next()) {
                folders.add(new Collection(rs.getInt("id"), rs.getString("path")));
            }
            vector = folders;
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }
}

