/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.CollectionChangeSupport;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.IllegalHomonymException;
import com.eteks.sweethome3d.model.TexturesCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexturesCatalog {
    private List<TexturesCategory> categories = new ArrayList<TexturesCategory>();
    private boolean sorted;
    private final CollectionChangeSupport<CatalogTexture> texturesChangeSupport = new CollectionChangeSupport(this);

    public List<TexturesCategory> getCategories() {
        this.checkCategoriesSorted();
        return Collections.unmodifiableList(this.categories);
    }

    private void checkCategoriesSorted() {
        if (!this.sorted) {
            Collections.sort(this.categories);
            this.sorted = true;
        }
    }

    public int getCategoriesCount() {
        return this.categories.size();
    }

    public TexturesCategory getCategory(int n) {
        this.checkCategoriesSorted();
        return this.categories.get(n);
    }

    public void addTexturesListener(CollectionListener<CatalogTexture> collectionListener) {
        this.texturesChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeTexturesListener(CollectionListener<CatalogTexture> collectionListener) {
        this.texturesChangeSupport.removeCollectionListener(collectionListener);
    }

    private void add(TexturesCategory texturesCategory) {
        if (this.categories.contains(texturesCategory)) {
            throw new IllegalHomonymException(texturesCategory.getName() + " already exists in catalog");
        }
        this.categories.add(texturesCategory);
        this.sorted = false;
    }

    public void add(TexturesCategory texturesCategory, CatalogTexture catalogTexture) {
        int n = this.categories.indexOf(texturesCategory);
        if (n == -1) {
            texturesCategory = new TexturesCategory(texturesCategory.getName());
            this.add(texturesCategory);
        } else {
            texturesCategory = this.categories.get(n);
        }
        texturesCategory.add(catalogTexture);
        this.texturesChangeSupport.fireCollectionChanged(catalogTexture, texturesCategory.getIndexOfTexture(catalogTexture), CollectionEvent.Type.ADD);
    }

    public void delete(CatalogTexture catalogTexture) {
        int n;
        TexturesCategory texturesCategory = catalogTexture.getCategory();
        if (texturesCategory != null && (n = texturesCategory.getIndexOfTexture(catalogTexture)) >= 0) {
            texturesCategory.delete(catalogTexture);
            if (texturesCategory.getTexturesCount() == 0) {
                this.categories = new ArrayList<TexturesCategory>(this.categories);
                this.categories.remove(texturesCategory);
            }
            this.texturesChangeSupport.fireCollectionChanged(catalogTexture, n, CollectionEvent.Type.DELETE);
            return;
        }
        throw new IllegalArgumentException("catalog doesn't contain texture " + catalogTexture.getName());
    }
}

