/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.PieceOfFurniture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.HomeFurnitureController;
import com.eteks.sweethome3d.viewcontroller.ImportedFurnitureWizardController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private View furnitureView;
    private HomePieceOfFurniture leadSelectedPieceOfFurniture;

    public FurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory) {
        this(home, userPreferences, viewFactory, null, null);
    }

    public FurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.contentManager = contentManager;
        this.addModelListeners();
    }

    @Override
    public View getView() {
        if (this.furnitureView == null) {
            this.furnitureView = this.viewFactory.createFurnitureView(this.home, this.preferences, this);
        }
        return this.furnitureView;
    }

    private void addModelListeners() {
        this.home.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                List<HomePieceOfFurniture> list = Home.getFurnitureSubList(FurnitureController.this.home.getSelectedItems());
                if (list.isEmpty()) {
                    FurnitureController.this.leadSelectedPieceOfFurniture = null;
                } else if (FurnitureController.this.leadSelectedPieceOfFurniture == null || list.size() == 1 || list.indexOf(FurnitureController.this.leadSelectedPieceOfFurniture) == -1) {
                    FurnitureController.this.leadSelectedPieceOfFurniture = list.get(0);
                }
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (HomePieceOfFurniture.Property.MOVABLE.name().equals(propertyChangeEvent.getPropertyName())) {
                    List<Selectable> list;
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)propertyChangeEvent.getSource();
                    if (FurnitureController.this.home.isBasePlanLocked() && FurnitureController.this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurniture) && (list = FurnitureController.this.home.getSelectedItems()).contains(homePieceOfFurniture)) {
                        list = new ArrayList<Selectable>(list);
                        list.remove(homePieceOfFurniture);
                        FurnitureController.this.home.setSelectedItems(list);
                    }
                }
            }
        };
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
        }
        this.home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener);
                }
            }
        });
    }

    public void addFurniture(List<HomePieceOfFurniture> list) {
        boolean bl;
        final boolean bl2 = this.home.isBasePlanLocked();
        final List<Selectable> list2 = this.home.getSelectedItems();
        final HomePieceOfFurniture[] homePieceOfFurnitureArray = list.toArray(new HomePieceOfFurniture[list.size()]);
        final int[] nArray = new int[list.size()];
        int n = this.home.getFurniture().size();
        boolean bl3 = bl2;
        for (bl = false; bl < nArray.length; bl += 1) {
            nArray[bl] = n++;
            bl3 &= !this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurnitureArray[bl]);
        }
        bl = bl3;
        final Level level = this.home.getSelectedLevel();
        this.doAddFurniture(homePieceOfFurnitureArray, nArray, level, null, bl);
        if (this.undoSupport != null) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    FurnitureController.this.doDeleteFurniture(homePieceOfFurnitureArray, bl2);
                    FurnitureController.this.home.setSelectedItems(list2);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    FurnitureController.this.doAddFurniture(homePieceOfFurnitureArray, nArray, level, null, bl);
                }

                public String getPresentationName() {
                    return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoAddFurnitureName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void doAddFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, int[] nArray, Level level, Level[] levelArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            this.home.addPieceOfFurniture(homePieceOfFurnitureArray[i], nArray[i]);
            homePieceOfFurnitureArray[i].setLevel(levelArray != null ? levelArray[i] : level);
        }
        this.home.setBasePlanLocked(bl);
        this.home.setSelectedItems(Arrays.asList(homePieceOfFurnitureArray));
    }

    public void deleteSelection() {
        this.deleteFurniture(Home.getFurnitureSubList(this.home.getSelectedItems()));
    }

    public void deleteFurniture(List<HomePieceOfFurniture> list) {
        final boolean bl = this.home.isBasePlanLocked();
        List<HomePieceOfFurniture> list2 = this.home.getFurniture();
        TreeMap<Integer, HomePieceOfFurniture> treeMap = new TreeMap<Integer, HomePieceOfFurniture>();
        for (HomePieceOfFurniture object2 : list) {
            if (!this.isPieceOfFurnitureDeletable(object2)) continue;
            treeMap.put(list2.indexOf(object2), object2);
        }
        final HomePieceOfFurniture[] homePieceOfFurnitureArray = treeMap.values().toArray(new HomePieceOfFurniture[treeMap.size()]);
        final int[] nArray = new int[homePieceOfFurnitureArray.length];
        final Level[] levelArray = new Level[homePieceOfFurnitureArray.length];
        int n = 0;
        Object object = treeMap.keySet().iterator();
        while (object.hasNext()) {
            int n2;
            nArray[n] = n2 = ((Integer)object.next()).intValue();
            levelArray[n] = homePieceOfFurnitureArray[n].getLevel();
            ++n;
        }
        this.doDeleteFurniture(homePieceOfFurnitureArray, bl);
        if (this.undoSupport != null) {
            object = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    FurnitureController.this.doAddFurniture(homePieceOfFurnitureArray, nArray, null, levelArray, bl);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    FurnitureController.this.home.setSelectedItems(Arrays.asList(homePieceOfFurnitureArray));
                    FurnitureController.this.doDeleteFurniture(homePieceOfFurnitureArray, bl);
                }

                public String getPresentationName() {
                    return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoDeleteSelectionName", new Object[0]);
                }
            };
            this.undoSupport.postEdit((UndoableEdit)object);
        }
    }

    private void doDeleteFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, boolean bl) {
        for (HomePieceOfFurniture homePieceOfFurniture : homePieceOfFurnitureArray) {
            this.home.deletePieceOfFurniture(homePieceOfFurniture);
        }
        this.home.setBasePlanLocked(bl);
    }

    public void setSelectedFurniture(List<HomePieceOfFurniture> list) {
        if (this.home.isBasePlanLocked()) {
            list = this.getFurnitureNotPartOfBasePlan(list);
        }
        this.home.setSelectedItems(list);
    }

    public void selectAll() {
        this.setSelectedFurniture(this.home.getFurniture());
    }

    protected boolean isPieceOfFurniturePartOfBasePlan(HomePieceOfFurniture homePieceOfFurniture) {
        return !homePieceOfFurniture.isMovable() || homePieceOfFurniture.isDoorOrWindow();
    }

    protected boolean isPieceOfFurnitureMovable(HomePieceOfFurniture homePieceOfFurniture) {
        return true;
    }

    protected boolean isPieceOfFurnitureDeletable(HomePieceOfFurniture homePieceOfFurniture) {
        return true;
    }

    public HomePieceOfFurniture createHomePieceOfFurniture(PieceOfFurniture pieceOfFurniture) {
        if (pieceOfFurniture instanceof DoorOrWindow) {
            return new HomeDoorOrWindow((DoorOrWindow)pieceOfFurniture);
        }
        if (pieceOfFurniture instanceof Light) {
            return new HomeLight((Light)pieceOfFurniture);
        }
        return new HomePieceOfFurniture(pieceOfFurniture);
    }

    private List<HomePieceOfFurniture> getFurnitureNotPartOfBasePlan(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurniture)) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public void toggleFurnitureSort(HomePieceOfFurniture.SortableProperty sortableProperty) {
        if (sortableProperty.equals((Object)this.home.getFurnitureSortedProperty())) {
            this.home.setFurnitureSortedProperty(null);
        } else {
            this.home.setFurnitureSortedProperty(sortableProperty);
        }
    }

    public void toggleFurnitureSortOrder() {
        this.home.setFurnitureDescendingSorted(!this.home.isFurnitureDescendingSorted());
    }

    public void sortFurniture(HomePieceOfFurniture.SortableProperty sortableProperty) {
        HomePieceOfFurniture.SortableProperty sortableProperty2 = this.home.getFurnitureSortedProperty();
        boolean bl = this.home.isFurnitureDescendingSorted();
        boolean bl2 = false;
        if (sortableProperty.equals((Object)sortableProperty2)) {
            if (bl) {
                sortableProperty = null;
            } else {
                bl2 = true;
            }
        }
        this.home.setFurnitureSortedProperty(sortableProperty);
        this.home.setFurnitureDescendingSorted(bl2);
    }

    public void setFurnitureVisibleProperties(List<HomePieceOfFurniture.SortableProperty> list) {
        this.home.setFurnitureVisibleProperties(list);
    }

    public void toggleFurnitureVisibleProperty(HomePieceOfFurniture.SortableProperty sortableProperty) {
        ArrayList<HomePieceOfFurniture.SortableProperty> arrayList = new ArrayList<HomePieceOfFurniture.SortableProperty>(this.home.getFurnitureVisibleProperties());
        if (arrayList.contains((Object)sortableProperty)) {
            arrayList.remove((Object)sortableProperty);
            if (arrayList.isEmpty()) {
                arrayList.add(HomePieceOfFurniture.SortableProperty.NAME);
            }
        } else {
            List<HomePieceOfFurniture.SortableProperty> list = Arrays.asList(HomePieceOfFurniture.SortableProperty.CATALOG_ID, HomePieceOfFurniture.SortableProperty.NAME, HomePieceOfFurniture.SortableProperty.WIDTH, HomePieceOfFurniture.SortableProperty.DEPTH, HomePieceOfFurniture.SortableProperty.HEIGHT, HomePieceOfFurniture.SortableProperty.X, HomePieceOfFurniture.SortableProperty.Y, HomePieceOfFurniture.SortableProperty.ELEVATION, HomePieceOfFurniture.SortableProperty.ANGLE, HomePieceOfFurniture.SortableProperty.LEVEL, HomePieceOfFurniture.SortableProperty.COLOR, HomePieceOfFurniture.SortableProperty.TEXTURE, HomePieceOfFurniture.SortableProperty.MOVABLE, HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW, HomePieceOfFurniture.SortableProperty.VISIBLE, HomePieceOfFurniture.SortableProperty.PRICE, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX, HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED);
            int n = list.indexOf((Object)sortableProperty) - 1;
            if (n > 0) {
                while (n > 0) {
                    int n2 = arrayList.indexOf((Object)list.get(n));
                    if (n2 >= 0) {
                        n = n2 + 1;
                        break;
                    }
                    --n;
                }
            }
            if (n < 0) {
                n = 0;
            }
            arrayList.add(n, sortableProperty);
        }
        this.home.setFurnitureVisibleProperties(arrayList);
    }

    public void modifySelectedFurniture() {
        if (!Home.getFurnitureSubList(this.home.getSelectedItems()).isEmpty()) {
            new HomeFurnitureController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
        }
    }

    public void toggleSelectedFurnitureVisibility() {
        if (Home.getFurnitureSubList(this.home.getSelectedItems()).size() == 1) {
            HomeFurnitureController homeFurnitureController;
            homeFurnitureController.setVisible((homeFurnitureController = new HomeFurnitureController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport)).getVisible() == false);
            homeFurnitureController.modifyFurniture();
        }
    }

    public void groupSelectedFurniture() {
        List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (!list.isEmpty()) {
            Object object;
            final boolean bl = this.home.isBasePlanLocked();
            final List<Selectable> list2 = this.home.getSelectedItems();
            List<HomePieceOfFurniture> list3 = this.home.getFurniture();
            TreeMap<Integer, HomePieceOfFurniture> treeMap = new TreeMap<Integer, HomePieceOfFurniture>();
            for (HomePieceOfFurniture object32 : list) {
                treeMap.put(list3.indexOf(object32), object32);
            }
            final HomePieceOfFurniture[] homePieceOfFurnitureArray = treeMap.values().toArray(new HomePieceOfFurniture[treeMap.size()]);
            final int[] nArray = new int[homePieceOfFurnitureArray.length];
            final Level[] levelArray = new Level[homePieceOfFurnitureArray.length];
            final float[] fArray = new float[homePieceOfFurnitureArray.length];
            final boolean[] blArray = new boolean[homePieceOfFurnitureArray.length];
            final boolean[] blArray2 = new boolean[homePieceOfFurnitureArray.length];
            Level level = this.home.getSelectedLevel();
            int n = 0;
            for (Map.Entry entry : treeMap.entrySet()) {
                nArray[n] = (Integer)entry.getKey();
                object = (HomePieceOfFurniture)entry.getValue();
                levelArray[n] = ((HomePieceOfFurniture)object).getLevel();
                fArray[n] = ((HomePieceOfFurniture)object).getElevation();
                blArray[n] = ((HomePieceOfFurniture)object).isMovable();
                blArray2[n] = ((HomePieceOfFurniture)object).isVisible();
                if (levelArray[n] != null && (level == null || levelArray[n].getElevation() < level.getElevation())) {
                    level = levelArray[n];
                }
                ++n;
            }
            int n2 = list.indexOf(this.leadSelectedPieceOfFurniture);
            if (n2 > 0) {
                list.remove(this.leadSelectedPieceOfFurniture);
                list.add(0, this.leadSelectedPieceOfFurniture);
            }
            final HomeFurnitureGroup homeFurnitureGroup = this.createHomeFurnitureGroup(list);
            object = new float[homePieceOfFurnitureArray.length];
            n = 0;
            for (HomePieceOfFurniture homePieceOfFurniture : treeMap.values()) {
                object[n++] = homePieceOfFurniture.getElevation();
            }
            int n3 = list3.size() - homePieceOfFurnitureArray.length;
            boolean bl2 = homeFurnitureGroup.isMovable();
            Level level2 = level;
            this.doGroupFurniture(homePieceOfFurnitureArray, new HomeFurnitureGroup[]{homeFurnitureGroup}, new int[]{n3}, new Level[]{level2}, bl);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit((float[])object, bl2, n3, level2){
                    final /* synthetic */ float[] val$groupPiecesNewElevation;
                    final /* synthetic */ boolean val$movable;
                    final /* synthetic */ int val$furnitureGroupIndex;
                    final /* synthetic */ Level val$groupLevel;
                    {
                        this.val$groupPiecesNewElevation = fArray2;
                        this.val$movable = bl2;
                        this.val$furnitureGroupIndex = n;
                        this.val$groupLevel = level;
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.doUngroupFurniture(homePieceOfFurnitureArray, nArray, new HomeFurnitureGroup[]{homeFurnitureGroup}, levelArray, bl);
                        for (int i = 0; i < homePieceOfFurnitureArray.length; ++i) {
                            homePieceOfFurnitureArray[i].setElevation(fArray[i]);
                            homePieceOfFurnitureArray[i].setMovable(blArray[i]);
                            homePieceOfFurnitureArray[i].setVisible(blArray2[i]);
                        }
                        FurnitureController.this.home.setSelectedItems(list2);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        for (int i = 0; i < homePieceOfFurnitureArray.length; ++i) {
                            homePieceOfFurnitureArray[i].setElevation(this.val$groupPiecesNewElevation[i]);
                            homePieceOfFurnitureArray[i].setLevel(null);
                        }
                        homeFurnitureGroup.setMovable(this.val$movable);
                        homeFurnitureGroup.setVisible(true);
                        FurnitureController.this.doGroupFurniture(homePieceOfFurnitureArray, new HomeFurnitureGroup[]{homeFurnitureGroup}, new int[]{this.val$furnitureGroupIndex}, new Level[]{this.val$groupLevel}, bl);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoGroupName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    protected HomeFurnitureGroup createHomeFurnitureGroup(List<HomePieceOfFurniture> list) {
        String string = this.preferences.getLocalizedString(FurnitureController.class, "groupName", this.getFurnitureGroupCount(this.home.getFurniture()) + 1);
        HomeFurnitureGroup homeFurnitureGroup = new HomeFurnitureGroup(list, string);
        return homeFurnitureGroup;
    }

    private int getFurnitureGroupCount(List<HomePieceOfFurniture> list) {
        int n = 0;
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            n += 1 + this.getFurnitureGroupCount(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture());
        }
        return n;
    }

    private void doGroupFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomeFurnitureGroup[] homeFurnitureGroupArray, int[] nArray, Level[] levelArray, boolean bl) {
        this.doDeleteFurniture(homePieceOfFurnitureArray, bl);
        this.doAddFurniture(homeFurnitureGroupArray, nArray, null, levelArray, bl);
    }

    private void doUngroupFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, int[] nArray, HomeFurnitureGroup[] homeFurnitureGroupArray, Level[] levelArray, boolean bl) {
        this.doDeleteFurniture(homeFurnitureGroupArray, bl);
        this.doAddFurniture(homePieceOfFurnitureArray, nArray, null, levelArray, bl);
    }

    public void ungroupSelectedFurniture() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Selectable object2 : this.home.getSelectedItems()) {
            if (!(object2 instanceof HomeFurnitureGroup) || !this.isPieceOfFurnitureMovable((HomePieceOfFurniture)(object = (HomeFurnitureGroup)object2))) continue;
            arrayList.add(object);
        }
        if (!arrayList.isEmpty()) {
            Object object22;
            boolean bl = this.home.isBasePlanLocked();
            List<Selectable> list = this.home.getSelectedItems();
            object = this.home.getFurniture();
            TreeMap<Integer, HomeFurnitureGroup> treeMap = new TreeMap<Integer, HomeFurnitureGroup>();
            for (Object object22 : arrayList) {
                treeMap.put(object.indexOf(object22), (HomeFurnitureGroup)object22);
            }
            final HomeFurnitureGroup[] homeFurnitureGroupArray = treeMap.values().toArray(new HomeFurnitureGroup[treeMap.size()]);
            object22 = new int[homeFurnitureGroupArray.length];
            int n = 0;
            Object object3 = treeMap.keySet().iterator();
            while (object3.hasNext()) {
                int homePieceOfFurnitureArray = (Integer)object3.next();
                object22[n++] = homePieceOfFurnitureArray;
            }
            object3 = new ArrayList();
            for (HomeFurnitureGroup n3 : homeFurnitureGroupArray) {
                object3.addAll(n3.getFurniture());
            }
            final HomePieceOfFurniture[] homePieceOfFurnitureArray = object3.toArray(new HomePieceOfFurniture[object3.size()]);
            int[] nArray = new int[homePieceOfFurnitureArray.length];
            Level[] levelArray = new Level[homePieceOfFurnitureArray.length];
            int n2 = object.size() - homeFurnitureGroupArray.length;
            boolean bl2 = bl;
            for (n = 0; n < homePieceOfFurnitureArray.length; ++n) {
                nArray[n] = n2++;
                levelArray[n] = homePieceOfFurnitureArray[n].getLevel();
                bl2 &= !this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurnitureArray[n]);
            }
            boolean bl3 = bl2;
            this.doUngroupFurniture(homePieceOfFurnitureArray, nArray, homeFurnitureGroupArray, levelArray, bl3);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit((int[])object22, levelArray, bl, list, nArray, bl3){
                    final /* synthetic */ int[] val$furnitureGroupsIndex;
                    final /* synthetic */ Level[] val$groupPiecesLevel;
                    final /* synthetic */ boolean val$oldBasePlanLocked;
                    final /* synthetic */ List val$oldSelection;
                    final /* synthetic */ int[] val$groupPiecesIndex;
                    final /* synthetic */ boolean val$newBasePlanLocked;
                    {
                        this.val$furnitureGroupsIndex = nArray;
                        this.val$groupPiecesLevel = levelArray;
                        this.val$oldBasePlanLocked = bl;
                        this.val$oldSelection = list;
                        this.val$groupPiecesIndex = nArray2;
                        this.val$newBasePlanLocked = bl2;
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.doGroupFurniture(homePieceOfFurnitureArray, homeFurnitureGroupArray, this.val$furnitureGroupsIndex, this.val$groupPiecesLevel, this.val$oldBasePlanLocked);
                        FurnitureController.this.home.setSelectedItems(this.val$oldSelection);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.doUngroupFurniture(homePieceOfFurnitureArray, this.val$groupPiecesIndex, homeFurnitureGroupArray, this.val$groupPiecesLevel, this.val$newBasePlanLocked);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoUngroupName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    public void importFurniture() {
        new ImportedFurnitureWizardController(this.home, this.preferences, this, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    public void importFurniture(String string) {
        new ImportedFurnitureWizardController(this.home, string, this.preferences, this, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    public void alignSelectedFurnitureOnTop() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float f = FurnitureController.this.getMinY(homePieceOfFurniture);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
                    float f2 = FurnitureController.this.getMinY(homePieceOfFurniture2);
                    homePieceOfFurniture2.setY(homePieceOfFurniture2.getY() + f - f2);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnBottom() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float f = FurnitureController.this.getMaxY(homePieceOfFurniture);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
                    float f2 = FurnitureController.this.getMaxY(homePieceOfFurniture2);
                    homePieceOfFurniture2.setY(homePieceOfFurniture2.getY() + f - f2);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnLeft() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float f = FurnitureController.this.getMinX(homePieceOfFurniture);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
                    float f2 = FurnitureController.this.getMinX(homePieceOfFurniture2);
                    homePieceOfFurniture2.setX(homePieceOfFurniture2.getX() + f - f2);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnRight() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float f = FurnitureController.this.getMaxX(homePieceOfFurniture);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
                    float f2 = FurnitureController.this.getMaxX(homePieceOfFurniture2);
                    homePieceOfFurniture2.setX(homePieceOfFurniture2.getX() + f - f2);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnFrontSide() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float[][] fArray = homePieceOfFurniture.getPoints();
                Line2D.Float float_ = new Line2D.Float(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1]);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    FurnitureController.this.alignPieceOfFurnitureAlongSides(alignedPieceOfFurniture.getPieceOfFurniture(), homePieceOfFurniture, float_, true, null, 0.0f);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnBackSide() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float[][] fArray = homePieceOfFurniture.getPoints();
                Line2D.Float float_ = new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    FurnitureController.this.alignPieceOfFurnitureAlongSides(alignedPieceOfFurniture.getPieceOfFurniture(), homePieceOfFurniture, float_, false, null, 0.0f);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnLeftSide() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float[][] fArray = homePieceOfFurniture.getPoints();
                Line2D.Float float_ = new Line2D.Float(fArray[3][0], fArray[3][1], fArray[0][0], fArray[0][1]);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    FurnitureController.this.alignPieceOfFurnitureAlongLeftOrRightSides(alignedPieceOfFurniture.getPieceOfFurniture(), homePieceOfFurniture, float_, false);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnRightSide() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float[][] fArray = homePieceOfFurniture.getPoints();
                Line2D.Float float_ = new Line2D.Float(fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    FurnitureController.this.alignPieceOfFurnitureAlongLeftOrRightSides(alignedPieceOfFurniture.getPieceOfFurniture(), homePieceOfFurniture, float_, true);
                }
            }
        });
    }

    public void alignSelectedFurnitureSideBySide() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                FurnitureController.this.alignFurnitureSideBySide(alignedPieceOfFurnitureArray, homePieceOfFurniture);
            }
        });
    }

    private void alignFurnitureSideBySide(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
        int n;
        float[][] fArray = homePieceOfFurniture.getPoints();
        Line2D.Float float_ = new Line2D.Float(homePieceOfFurniture.getX(), homePieceOfFurniture.getY(), (fArray[0][0] + fArray[1][0]) / 2.0f, (fArray[0][1] + fArray[1][1]) / 2.0f);
        List<HomePieceOfFurniture> list = this.sortFurniture(alignedPieceOfFurnitureArray, homePieceOfFurniture, float_);
        int n2 = list.indexOf(homePieceOfFurniture);
        Line2D.Float float_2 = new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
        float f = homePieceOfFurniture.getWidth() / 2.0f;
        for (n = n2 + 1; n < list.size(); ++n) {
            f = (float)((double)f + this.alignPieceOfFurnitureAlongSides(list.get(n), homePieceOfFurniture, float_2, false, float_, f));
        }
        f = -homePieceOfFurniture.getWidth() / 2.0f;
        for (n = n2 - 1; n >= 0; --n) {
            f = (float)((double)f - this.alignPieceOfFurnitureAlongSides(list.get(n), homePieceOfFurniture, float_2, false, float_, f));
        }
    }

    public List<HomePieceOfFurniture> sortFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture, final Line2D line2D) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(alignedPieceOfFurnitureArray.length + 1);
        if (homePieceOfFurniture != null) {
            arrayList.add(homePieceOfFurniture);
        }
        for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
            arrayList.add(alignedPieceOfFurniture.getPieceOfFurniture());
        }
        Collections.sort(arrayList, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return Double.compare(line2D.ptLineDistSq(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()) * (double)line2D.relativeCCW(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()), line2D.ptLineDistSq(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * (double)line2D.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()));
            }
        });
        return arrayList;
    }

    private double alignPieceOfFurnitureAlongSides(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2, Line2D line2D, boolean bl, Line2D line2D2, float f) {
        double d = (double)line2D.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * line2D.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) + this.getPieceBoundingRectangleHeight(homePieceOfFurniture, -homePieceOfFurniture2.getAngle()) / 2.0;
        if (bl) {
            d = -d;
        }
        double d2 = Math.sin(homePieceOfFurniture2.getAngle());
        double d3 = Math.cos(homePieceOfFurniture2.getAngle());
        float f2 = (float)(-d * d2);
        float f3 = (float)(d * d3);
        double d4 = this.getPieceBoundingRectangleWidth(homePieceOfFurniture, -homePieceOfFurniture2.getAngle());
        if (line2D2 != null) {
            d = (double)f + (double)line2D2.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * (line2D2.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) - d4 / 2.0);
            f2 += (float)(d * d3);
            f3 += (float)(d * d2);
        }
        homePieceOfFurniture.move(f2, f3);
        return d4;
    }

    private void alignPieceOfFurnitureAlongLeftOrRightSides(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2, Line2D line2D, boolean bl) {
        double d = (double)line2D.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * line2D.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) + this.getPieceBoundingRectangleWidth(homePieceOfFurniture, -homePieceOfFurniture2.getAngle()) / 2.0;
        if (bl) {
            d = -d;
        }
        homePieceOfFurniture.move((float)(d * Math.cos(homePieceOfFurniture2.getAngle())), (float)(d * Math.sin(homePieceOfFurniture2.getAngle())));
    }

    private double getPieceBoundingRectangleWidth(HomePieceOfFurniture homePieceOfFurniture, float f) {
        return Math.abs((double)homePieceOfFurniture.getWidth() * Math.cos(f + homePieceOfFurniture.getAngle())) + Math.abs((double)homePieceOfFurniture.getDepth() * Math.sin(f + homePieceOfFurniture.getAngle()));
    }

    private double getPieceBoundingRectangleHeight(HomePieceOfFurniture homePieceOfFurniture, float f) {
        return Math.abs((double)homePieceOfFurniture.getWidth() * Math.sin(f + homePieceOfFurniture.getAngle())) + Math.abs((double)homePieceOfFurniture.getDepth() * Math.cos(f + homePieceOfFurniture.getAngle()));
    }

    private void alignSelectedFurniture(final AlignmentAction alignmentAction) {
        final List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (list.size() >= 2) {
            final List<Selectable> list2 = this.home.getSelectedItems();
            final HomePieceOfFurniture homePieceOfFurniture = this.leadSelectedPieceOfFurniture;
            final AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = AlignedPieceOfFurniture.getAlignedFurniture(list, homePieceOfFurniture);
            this.home.setSelectedItems(list);
            alignmentAction.alignFurniture(alignedPieceOfFurnitureArray, homePieceOfFurniture);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.undoAlignFurniture(alignedPieceOfFurnitureArray);
                        FurnitureController.this.home.setSelectedItems(list2);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.home.setSelectedItems(list);
                        alignmentAction.alignFurniture(alignedPieceOfFurnitureArray, homePieceOfFurniture);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoAlignName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    private List<HomePieceOfFurniture> getMovableSelectedFurniture() {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (Selectable selectable : this.home.getSelectedItems()) {
            HomePieceOfFurniture homePieceOfFurniture;
            if (!(selectable instanceof HomePieceOfFurniture) || !this.isPieceOfFurnitureMovable(homePieceOfFurniture = (HomePieceOfFurniture)selectable)) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    private void undoAlignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray) {
        for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
            HomePieceOfFurniture homePieceOfFurniture = alignedPieceOfFurniture.getPieceOfFurniture();
            homePieceOfFurniture.setX(alignedPieceOfFurniture.getX());
            homePieceOfFurniture.setY(alignedPieceOfFurniture.getY());
        }
    }

    private float getMinX(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.POSITIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.min(f, fArray2[0]);
        }
        return f;
    }

    private float getMaxX(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.NEGATIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.max(f, fArray2[0]);
        }
        return f;
    }

    private float getMinY(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.POSITIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.min(f, fArray2[1]);
        }
        return f;
    }

    private float getMaxY(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.NEGATIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.max(f, fArray2[1]);
        }
        return f;
    }

    public void distributeSelectedFurnitureHorizontally() {
        this.distributeSelectedFurniture(true);
    }

    public void distributeSelectedFurnitureVertically() {
        this.distributeSelectedFurniture(false);
    }

    public void distributeSelectedFurniture(final boolean bl) {
        final List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (list.size() >= 3) {
            final List<Selectable> list2 = this.home.getSelectedItems();
            final AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = AlignedPieceOfFurniture.getAlignedFurniture(list, null);
            this.home.setSelectedItems(list);
            this.doDistributeFurnitureAlongAxis(alignedPieceOfFurnitureArray, bl);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.undoAlignFurniture(alignedPieceOfFurnitureArray);
                        FurnitureController.this.home.setSelectedItems(list2);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.home.setSelectedItems(list);
                        FurnitureController.this.doDistributeFurnitureAlongAxis(alignedPieceOfFurnitureArray, bl);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoDistributeName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    private void doDistributeFurnitureAlongAxis(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, boolean bl) {
        Line2D.Float float_ = bl ? new Line2D.Float(0.0f, 0.0f, 0.0f, -1.0f) : new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);
        List<HomePieceOfFurniture> list = this.sortFurniture(alignedPieceOfFurnitureArray, null, float_);
        float f = (float)(bl ? 0.0 : 1.5707963267948966);
        HomePieceOfFurniture homePieceOfFurniture = list.get(0);
        double d = this.getPieceBoundingRectangleWidth(homePieceOfFurniture, f) / 2.0;
        HomePieceOfFurniture homePieceOfFurniture2 = list.get(list.size() - 1);
        double d2 = this.getPieceBoundingRectangleWidth(homePieceOfFurniture2, f) / 2.0;
        double d3 = Math.abs(float_.ptLineDist(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()) * (double)float_.relativeCCW(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()) - float_.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * (double)float_.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY())) - d2 - d;
        double[] dArray = new double[list.size() - 2];
        for (int i = 1; i < list.size() - 1; ++i) {
            HomePieceOfFurniture homePieceOfFurniture3 = list.get(i);
            dArray[i - 1] = this.getPieceBoundingRectangleWidth(homePieceOfFurniture3, f);
            d3 -= dArray[i - 1];
        }
        float f2 = (bl ? homePieceOfFurniture.getX() : homePieceOfFurniture.getY()) + (float)(d + (d3 /= (double)(list.size() - 1)));
        for (int i = 1; i < list.size() - 1; ++i) {
            HomePieceOfFurniture homePieceOfFurniture4 = list.get(i);
            if (bl) {
                homePieceOfFurniture4.setX((float)((double)f2 + dArray[i - 1] / 2.0));
            } else {
                homePieceOfFurniture4.setY((float)((double)f2 + dArray[i - 1] / 2.0));
            }
            f2 = (float)((double)f2 + (d3 + dArray[i - 1]));
        }
    }

    private static interface AlignmentAction {
        public void alignFurniture(AlignedPieceOfFurniture[] var1, HomePieceOfFurniture var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlignedPieceOfFurniture {
        private HomePieceOfFurniture piece;
        private float x;
        private float y;

        public AlignedPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
            this.piece = homePieceOfFurniture;
            this.x = homePieceOfFurniture.getX();
            this.y = homePieceOfFurniture.getY();
        }

        public HomePieceOfFurniture getPieceOfFurniture() {
            return this.piece;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public static AlignedPieceOfFurniture[] getAlignedFurniture(List<HomePieceOfFurniture> list, HomePieceOfFurniture homePieceOfFurniture) {
            AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = new AlignedPieceOfFurniture[homePieceOfFurniture == null ? list.size() : list.size() - 1];
            int n = 0;
            for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
                if (homePieceOfFurniture2 == homePieceOfFurniture) continue;
                alignedPieceOfFurnitureArray[n++] = new AlignedPieceOfFurniture(homePieceOfFurniture2);
            }
            return alignedPieceOfFurnitureArray;
        }
    }
}

