/*
 * Decompiled with CFR 0.152.
 */
final class MathUtil {
    private static final double epsilon = Math.ulp(1.0);
    private static final double taylor_2_bound = Math.sqrt(epsilon);
    private static final double taylor_n_bound = Math.sqrt(taylor_2_bound);
    private static final double upper_taylor_2_bound = 1.0 / taylor_2_bound;
    private static final double upper_taylor_n_bound = 1.0 / taylor_n_bound;

    private MathUtil() {
        throw new AssertionError((Object)"MathUtil is a utility class.");
    }

    static double fact(double d, int n) {
        double d2 = (d + 0.5) * Math.log10(d) - d * Math.log10(Math.E);
        if (d2 > (double)n) {
            double d3 = 1.0 / (d + 1.0);
            return Math.exp(-d - 1.0) * Math.sqrt(Math.PI * 2) * Math.pow(d + 1.0, d + 0.5) * (1.0 + d3 * (0.08333333333333333 + d3 * (0.003472222222222222 + d3 * (-0.0026813271604938273 + d3 * -2.2947209362139917E-4))));
        }
        return MathUtil.factJr(d);
    }

    private static double factJr(double d) {
        if (d >= 1.0) {
            return d * MathUtil.factJr(d - 1.0);
        }
        return 1.0 + d * (-0.577191652 + d * (0.988205891 + d * (-0.897056937 + d * (0.918206857 + d * (-0.756704078 + d * (0.482199394 + d * (-0.193527818 + d * 0.035868343)))))));
    }

    static boolean factCanDo(double d, int n) {
        if (d <= 0.0) {
            return false;
        }
        double d2 = d * Math.log10(d) - d * Math.log10(Math.E) + 0.5 * Math.log10(Math.PI * 2 * d);
        return d2 < Math.pow(10.0, n);
    }

    static double asinh(double d) {
        if (d >= taylor_n_bound) {
            if (d > upper_taylor_n_bound) {
                if (d > upper_taylor_2_bound) {
                    return Math.log(d * 2.0);
                }
                return Math.log(d * 2.0 + 1.0 / (d * 2.0));
            }
            return Math.log(d + Math.sqrt(d * d + 1.0));
        }
        if (d <= -taylor_n_bound) {
            return -MathUtil.asinh(-d);
        }
        double d2 = d;
        if (Math.abs(d) >= taylor_2_bound) {
            double d3 = d * d * d;
            d2 -= d3 / 6.0;
        }
        return d2;
    }

    static double acosh(double d) {
        double d2;
        if (d < 1.0) {
            return Double.NaN;
        }
        if (d >= taylor_n_bound) {
            if (d > upper_taylor_2_bound) {
                return Math.log(d * 2.0);
            }
            return Math.log(d + Math.sqrt(d * d - 1.0));
        }
        double d3 = d2 = Math.sqrt(d - 1.0);
        if (d2 >= taylor_2_bound) {
            double d4 = d2 * d2 * d2;
            d3 -= d4 / 12.0;
        }
        return Math.sqrt(2.0) * d3;
    }

    static double atanh(double d) {
        if (d < -1.0) {
            return Double.NaN;
        }
        if (d < -1.0 + epsilon) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d > 1.0) {
            return Double.NaN;
        }
        if (d > 1.0 - epsilon) {
            return Double.POSITIVE_INFINITY;
        }
        if (Math.abs(d) >= taylor_n_bound) {
            return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
        }
        double d2 = d;
        if (Math.abs(d) >= taylor_2_bound) {
            double d3 = d * d * d;
            d2 += d3 / 3.0;
        }
        return d2;
    }

    static double smartSum(double d, double d2, int n) {
        double d3 = d + d2;
        double d4 = Math.abs(d3);
        double d5 = Math.max(Math.abs(d), Math.abs(d2));
        double d6 = Math.log10(n);
        if (Math.ceil(Math.log10(d5) / d6) <= Math.ceil(Math.log10(d4) / d6)) {
            return d3;
        }
        double d7 = Math.pow(n, Math.ceil(Math.log10(Math.ulp(d5)) / d6));
        return d7 * Math.rint(d3 / d7);
    }
}

