/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.JuifeUtils;
import net.sf.juife.OkCancelDialog;

public class JSColorButton
extends JPanel {
    private Color color;
    private final Vector<ActionListener> listeners = new Vector();

    public JSColorButton() {
        this(Color.WHITE);
    }

    public JSColorButton(Color color) {
        this.color = color;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setPreferredSize(new Dimension(42, 16));
        this.setMaximumSize(new Dimension(42, 16));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!JSColorButton.this.isEnabled()) {
                    return;
                }
                if (mouseEvent.getButton() == 1) {
                    JSColorButton.this.showColorChooser();
                }
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    private void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, null);
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setOpaque(bl);
        if (bl) {
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        } else {
            this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        }
        super.setEnabled(bl);
    }

    private void showColorChooser() {
        ColorDlg colorDlg = new ColorDlg((Dialog)JuifeUtils.getWindow(this), this.getColor());
        colorDlg.setVisible(true);
        if (!colorDlg.isCancelled()) {
            this.setColor(colorDlg.getColor());
            this.fireActionPerformed();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.setBackground(this.color);
    }

    protected static class ColorDlg
    extends OkCancelDialog {
        private final JColorChooser colorChooser = new JColorChooser();

        ColorDlg(Dialog dialog) {
            this(dialog, Color.WHITE);
        }

        ColorDlg(Dialog dialog, Color color) {
            super(dialog);
            this.colorChooser.setPreviewPanel(new JPanel());
            this.colorChooser.setColor(color);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.colorChooser);
            jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
            final JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(color);
            jPanel2.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jPanel.add(jPanel2);
            jPanel2.setPreferredSize(new Dimension(48, 8));
            jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, 8));
            this.setMainPane(jPanel);
            this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    jPanel2.setBackground(ColorDlg.this.getColor());
                }
            });
        }

        @Override
        protected void onOk() {
            this.setVisible(false);
        }

        @Override
        protected void onCancel() {
            this.setVisible(false);
        }

        public Color getColor() {
            return this.colorChooser.getColor();
        }
    }
}

