/*
 * Decompiled with CFR 0.152.
 */
package glguerin.authkit.imp.macosx;

import glguerin.authkit.Authorization;
import glguerin.authkit.Privilege;
import glguerin.authkit.UnauthorizedCancellation;
import glguerin.authkit.UnauthorizedException;
import glguerin.authkit.imp.macosx.AuthProcess;
import glguerin.util.LibLoader;
import java.util.Date;
import java.util.Enumeration;

public final class MacOSXAuthorization
extends Authorization {
    private static final int DEFAULT = 0;
    private static final int INTERACT = 1;
    private static final int EXTEND = 2;
    private static final int DESTROY = 8;
    private static final int PREAUTH = 16;
    private static final int[] paramErrors = new int[]{-1, -60001, -60002, -60003, -60004, -60011};
    private int mySession = 0;

    public int getCapabilities() {
        return 903;
    }

    public void authorize(Privilege privilege, boolean bl) {
        int n = 2;
        if (bl) {
            n |= 1;
        }
        this.check(this.claim(privilege, n));
        this.addGranted(privilege);
    }

    public void preauthorize(Privilege privilege) {
        this.authorize(privilege, true);
    }

    public boolean isAvailable(Privilege privilege) {
        return this.claim(privilege, 0) == 0;
    }

    private synchronized int claim(Privilege privilege, int n) {
        if (this.mySession == 0) {
            int[] nArray = new int[1];
            this.check(MacOSXAuthorization.makeSession(nArray));
            this.mySession = nArray[0];
        }
        return MacOSXAuthorization.request(this.mySession, n, privilege.getName(), privilege.getValue(), privilege.getFlags());
    }

    private void check(int n) {
        if (n == 0) {
            return;
        }
        if (n == -2147418111) {
            n = -60010;
        }
        int n2 = 0;
        while (n2 < paramErrors.length) {
            if (n == paramErrors[n2]) {
                throw new IllegalArgumentException("Authorization error: " + n);
            }
            ++n2;
        }
        if (n == -60006) {
            throw new UnauthorizedCancellation("Authorization cancelled");
        }
        throw new UnauthorizedException("Authorization denied: " + n);
    }

    public synchronized void detach(boolean bl) {
        int n = 0;
        if (bl) {
            n = 8;
        }
        if (this.mySession != 0) {
            this.clearGranted();
            int n2 = this.mySession;
            this.mySession = 0;
            this.check(MacOSXAuthorization.killSession(n2, n));
        }
    }

    public Enumeration getPastGrantedPrivileges() {
        return this.keysGranted();
    }

    public Date getPastGrantedDate(Privilege privilege, int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("Don't know when: " + n);
        }
        return this.whenGranted(privilege, n);
    }

    public Privilege makeExecPrivilege(String string) {
        return new Privilege("system.privilege.admin", string, 0);
    }

    public Process execPrivileged(String[] stringArray) {
        this.claim(Privilege.EMPTY, 0);
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Null or empty String[]");
        }
        String string = stringArray[0];
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Null or empty command");
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        int[] nArray = new int[2];
        this.check(MacOSXAuthorization.rootExec(this.mySession, 0, string, stringArray2, nArray));
        AuthProcess authProcess = new AuthProcess(string, nArray[0], nArray[1]);
        this.addGranted(this.makeExecPrivilege(string));
        return authProcess;
    }

    public int getSecretLength() {
        return 32;
    }

    public synchronized byte[] getSecretIdentifier() {
        int n = this.mySession;
        if (n == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[32];
        this.check(MacOSXAuthorization.externalize(n, byArray));
        return byArray;
    }

    public synchronized void attach(byte[] byArray) {
        if (byArray == null || byArray.length < 32) {
            throw new IllegalArgumentException("Null or insufficient byte[]");
        }
        if (this.mySession != 0) {
            throw new IllegalStateException("Session active");
        }
        this.clearGranted();
        int[] nArray = new int[1];
        this.check(MacOSXAuthorization.internalize(byArray, nArray));
        this.mySession = nArray[0];
    }

    public synchronized void attachPrivileged() {
        if (this.mySession != 0) {
            throw new IllegalStateException("Session active");
        }
        this.clearGranted();
        int[] nArray = new int[1];
        this.check(MacOSXAuthorization.internalizePriv(0, nArray));
        this.mySession = nArray[0];
    }

    private static synchronized native int makeSession(int[] var0);

    private static synchronized native int killSession(int var0, int var1);

    private static synchronized native int request(int var0, int var1, String var2, byte[] var3, int var4);

    private static synchronized native int rootExec(int var0, int var1, String var2, String[] var3, int[] var4);

    private static synchronized native int externalize(int var0, byte[] var1);

    private static synchronized native int internalize(byte[] var0, int[] var1);

    private static synchronized native int internalizePriv(int var0, int[] var1);

    static {
        LibLoader.getLoader().loadLibrary("AuthKit");
    }
}

