/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.MacFontUtils;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class EmphasizedLabelUI
extends BasicLabelUI {
    private Color fShadowColor;
    private Color fFocusedTextColor;
    private Color fUnfocusedTextColor;
    public static final Color DEFAULT_EMPHASIS_COLOR = new Color(255, 255, 255, 110);
    public static final Color DEFAULT_FOCUSED_FONT_COLOR = new Color(0);
    public static final Color DEFAULT_UNFOCUSED_FONT_COLOR = new Color(0x3F3F3F);
    public static final Color DEFAULT_DISABLED_FONT_COLOR = new Color(0x3F3F3F);

    public EmphasizedLabelUI() {
        this(DEFAULT_FOCUSED_FONT_COLOR, DEFAULT_UNFOCUSED_FONT_COLOR, DEFAULT_EMPHASIS_COLOR);
    }

    public EmphasizedLabelUI(Color focusedTextColor, Color unfocusedTextColor, Color emphasisColor) {
        this.fFocusedTextColor = focusedTextColor;
        this.fUnfocusedTextColor = unfocusedTextColor;
        this.fShadowColor = emphasisColor;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    protected void paintEnabledText(JLabel label, Graphics g, String s, int textX, int textY) {
        MacFontUtils.enableAntialiasing((Graphics2D)g);
        g.setColor(this.fShadowColor);
        g.setFont(label.getFont());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, -1, textX, textY + 1);
        g.setColor(WindowUtils.isParentWindowFocused(label) ? this.fFocusedTextColor : this.fUnfocusedTextColor);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, -1, textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel label, Graphics g, String s, int textX, int textY) {
        MacFontUtils.enableAntialiasing((Graphics2D)g);
        g.setColor(this.fShadowColor);
        g.setFont(label.getFont());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, -1, textX, textY + 1);
        g.setColor(DEFAULT_DISABLED_FONT_COLOR);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, -1, textX, textY);
    }
}

