/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.tool.MVReplaceList;
import msearch.filmlisten.DatenFilmlisteUrl;

public class IoXmlSchreiben {
    private static XMLStreamWriter writer;
    private static OutputStreamWriter out;
    private static Path xmlFilePath;

    public static synchronized void datenSchreiben() {
        xmlFilePath = Daten.getMediathekXmlFilePath();
        Log.systemMeldung("Daten Schreiben nach: " + xmlFilePath.toString());
        IoXmlSchreiben.xmlDatenSchreiben();
    }

    public static synchronized void exportPset(DatenPset[] pSet, String datei) {
        try {
            xmlFilePath = Paths.get(datei, new String[0]);
            Log.systemMeldung("Pset exportieren nach: " + xmlFilePath.toString());
            IoXmlSchreiben.xmlSchreibenStart();
            IoXmlSchreiben.xmlSchreibenPset(pSet);
            IoXmlSchreiben.xmlSchreibenEnde();
        }
        catch (Exception ex) {
            Log.fehlerMeldung(392846204, ex, "nach: " + datei);
        }
    }

    private static void xmlDatenSchreiben() {
        try {
            IoXmlSchreiben.xmlSchreibenStart();
            writer.writeCharacters("\n\n");
            writer.writeComment("Abos");
            writer.writeCharacters("\n");
            IoXmlSchreiben.xmlSchreibenAbo();
            writer.writeCharacters("\n\n");
            writer.writeComment("Blacklist");
            writer.writeCharacters("\n");
            IoXmlSchreiben.xmlSchreibenBlackList();
            writer.writeCharacters("\n\n");
            writer.writeComment("Programmeinstellungen");
            writer.writeCharacters("\n");
            IoXmlSchreiben.xmlSchreibenConfig("system", Daten.mVConfig.getAll(), true);
            writer.writeCharacters("\n");
            writer.writeCharacters("\n\n");
            writer.writeComment("Programmsets");
            writer.writeCharacters("\n");
            IoXmlSchreiben.xmlSchreibenProg();
            writer.writeCharacters("\n\n");
            writer.writeComment("Ersetzungstabelle");
            writer.writeCharacters("\n");
            IoXmlSchreiben.xmlSchreibenErsetzungstabelle();
            writer.writeCharacters("\n\n");
            writer.writeComment("Downloads");
            writer.writeCharacters("\n");
            IoXmlSchreiben.xmlSchreibenDownloads();
            writer.writeCharacters("\n\n");
            writer.writeComment("Update Filmliste");
            writer.writeCharacters("\n");
            IoXmlSchreiben.xmlSchreibenFilmUpdateServer();
            writer.writeCharacters("\n\n");
            IoXmlSchreiben.xmlSchreibenEnde();
        }
        catch (Exception ex) {
            Log.fehlerMeldung(656328109, ex);
        }
    }

    private static void xmlSchreibenStart() throws IOException, XMLStreamException {
        Log.systemMeldung("Start Schreiben nach: " + xmlFilePath.toAbsolutePath());
        out = new OutputStreamWriter(Files.newOutputStream(xmlFilePath, new OpenOption[0]), "UTF-8");
        XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
        writer = outFactory.createXMLStreamWriter(out);
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeCharacters("\n");
        writer.writeStartElement("Mediathek");
        writer.writeCharacters("\n");
    }

    private static void xmlSchreibenErsetzungstabelle() {
        for (String[] sa : Daten.mVReplaceList.list) {
            IoXmlSchreiben.xmlSchreibenDaten("Ersetzungstabelle", MVReplaceList.COLUMN_NAMES, sa, false);
        }
    }

    private static void xmlSchreibenProg() {
        for (DatenPset datenPset : Daten.listePset) {
            IoXmlSchreiben.xmlSchreibenDaten("Programmset", DatenPset.COLUMN_NAMES_, datenPset.arr, false);
            for (DatenProg datenProg : datenPset.getListeProg()) {
                IoXmlSchreiben.xmlSchreibenDaten("Programm", DatenProg.COLUMN_NAMES_, datenProg.arr, false);
            }
        }
    }

    private static void xmlSchreibenPset(DatenPset[] psetArray) throws XMLStreamException {
        writer.writeCharacters("\n\n");
        for (DatenPset pset : psetArray) {
            IoXmlSchreiben.xmlSchreibenDaten("Programmset", DatenPset.COLUMN_NAMES_, pset.arr, true);
            for (DatenProg datenProg : pset.getListeProg()) {
                IoXmlSchreiben.xmlSchreibenDaten("Programm", DatenProg.COLUMN_NAMES_, datenProg.arr, true);
            }
            writer.writeCharacters("\n\n");
        }
    }

    private static void xmlSchreibenDownloads() {
        for (DatenDownload download : Daten.listeDownloads) {
            if (download.isInterrupted()) {
                IoXmlSchreiben.xmlSchreibenDaten("Downlad", DatenDownload.COLUMN_NAMES_, download.arr, false);
                continue;
            }
            if (download.istAbo() || download.isFinished()) continue;
            IoXmlSchreiben.xmlSchreibenDaten("Downlad", DatenDownload.COLUMN_NAMES_, download.arr, false);
        }
    }

    private static void xmlSchreibenAbo() {
        for (DatenAbo datenAbo : Daten.listeAbo) {
            IoXmlSchreiben.xmlSchreibenDaten("Abonnement", DatenAbo.COLUMN_NAMES, datenAbo.arr, false);
        }
    }

    private static void xmlSchreibenBlackList() {
        for (DatenBlacklist blacklist : Daten.listeBlacklist) {
            IoXmlSchreiben.xmlSchreibenDaten("Blacklist", DatenBlacklist.BLACKLIST_COLUMN_NAMES, blacklist.arr, false);
        }
    }

    private static void xmlSchreibenFilmUpdateServer() throws XMLStreamException {
        writer.writeCharacters("\n");
        writer.writeComment("Akt-Filmliste");
        writer.writeCharacters("\n");
        for (DatenFilmlisteUrl datenUrlFilmliste : Daten.filmeLaden.getDownloadUrlsFilmlisten_akt()) {
            datenUrlFilmliste.arr[5] = "akt";
            IoXmlSchreiben.xmlSchreibenDaten("film-update-server", DatenFilmlisteUrl.FILM_UPDATE_SERVER_COLUMN_NAMES, datenUrlFilmliste.arr, false);
        }
        writer.writeCharacters("\n");
        writer.writeComment("Diff-Filmliste");
        writer.writeCharacters("\n");
        for (DatenFilmlisteUrl datenUrlFilmliste : Daten.filmeLaden.getDownloadUrlsFilmlisten_diff()) {
            datenUrlFilmliste.arr[5] = "diff";
            IoXmlSchreiben.xmlSchreibenDaten("film-update-server", DatenFilmlisteUrl.FILM_UPDATE_SERVER_COLUMN_NAMES, datenUrlFilmliste.arr, false);
        }
    }

    private static void xmlSchreibenDaten(String xmlName, String[] xmlSpalten, String[] datenArray, boolean newLine) {
        int xmlMax = datenArray.length;
        try {
            writer.writeStartElement(xmlName);
            if (newLine) {
                writer.writeCharacters("\n");
            }
            for (int i = 0; i < xmlMax; ++i) {
                if (datenArray[i].equals("")) continue;
                if (newLine) {
                    writer.writeCharacters("\t");
                }
                writer.writeStartElement(xmlSpalten[i]);
                writer.writeCharacters(datenArray[i]);
                writer.writeEndElement();
                if (!newLine) continue;
                writer.writeCharacters("\n");
            }
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            Log.fehlerMeldung(198325017, ex);
        }
    }

    private static void xmlSchreibenConfig(String xmlName, String[][] xmlSpalten, boolean newLine) {
        try {
            writer.writeStartElement(xmlName);
            if (newLine) {
                writer.writeCharacters("\n");
            }
            for (String[] xmlSpalte : xmlSpalten) {
                if (xmlSpalte[1].equals("")) continue;
                if (newLine) {
                    writer.writeCharacters("\t");
                }
                writer.writeStartElement(xmlSpalte[0]);
                writer.writeCharacters(xmlSpalte[1]);
                writer.writeEndElement();
                if (!newLine) continue;
                writer.writeCharacters("\n");
            }
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            Log.fehlerMeldung(951230478, ex);
        }
    }

    private static void xmlSchreibenEnde() throws Exception {
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
        out.close();
        Log.systemMeldung("geschrieben!");
    }

    static {
        out = null;
    }
}

