/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenBlacklist;
import mediathek.gui.GuiFilme;
import mediathek.tool.Filter;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVListeFilme;
import msearch.daten.DatenFilm;
import msearch.daten.ListeFilme;

public class ListeBlacklist
extends LinkedList<DatenBlacklist> {
    private long tage = 0L;
    private long jetzt;
    private boolean zukunftNichtAnzeigen;
    private boolean geoNichtAnzeigen;
    private boolean blacklistOn;
    private long filmlaengeSoll = 0L;
    private int nr = 0;
    private final Daten daten;

    public ListeBlacklist(Daten d) {
        this.daten = d;
    }

    @Override
    public boolean add(DatenBlacklist b) {
        b.arr[0] = this.getNr(this.nr++);
        boolean ret = super.add(b);
        this.notifyBlack();
        return ret;
    }

    private void notifyBlack() {
        MVListeFilme.checkBlacklist();
        ListenerMediathekView.notify(39, ListeBlacklist.class.getSimpleName());
    }

    @Override
    public boolean remove(Object b) {
        boolean ret = super.remove(b);
        this.notifyBlack();
        return ret;
    }

    @Override
    public DatenBlacklist remove(int idx) {
        DatenBlacklist ret = (DatenBlacklist)super.remove(idx);
        this.notifyBlack();
        return ret;
    }

    public DatenBlacklist remove(String idx) {
        DatenBlacklist bl = this.get(idx);
        if (bl != null) {
            this.remove(bl);
        }
        this.notifyBlack();
        return bl;
    }

    @Override
    public DatenBlacklist get(int idx) {
        return (DatenBlacklist)super.get(idx);
    }

    public DatenBlacklist get(String nr) {
        for (DatenBlacklist b : this) {
            if (!b.arr[0].equals(nr)) continue;
            return b;
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.notifyBlack();
    }

    public Object[][] getObjectData() {
        int i = 0;
        ListIterator iterator = this.listIterator();
        Object[][] object = new Object[this.size()][5];
        while (iterator.hasNext()) {
            DatenBlacklist blacklist = (DatenBlacklist)iterator.next();
            object[i] = blacklist.arr;
            ++i;
        }
        return object;
    }

    public void filterListe(ListeFilme listeFilme, ListeFilme listeRet) {
        listeRet.clear();
        this.setFilter();
        if (listeFilme != null) {
            listeRet.setMeta(listeFilme);
            for (DatenFilm filmEntry : listeFilme) {
                if (!this.checkFilm(filmEntry)) continue;
                listeRet.add((Object)filmEntry);
                if (!filmEntry.neuerFilm) continue;
                listeRet.neueFilme = true;
            }
            listeRet.themenLaden();
        }
    }

    public boolean checkBlackOkFilme_Downloads(DatenFilm film) {
        this.setFilter();
        this.tage = 0L;
        this.blacklistOn = true;
        this.zukunftNichtAnzeigen = Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-Zukunft-nicht-anzeigen"));
        this.geoNichtAnzeigen = Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-Geo-nicht-anzeigen"));
        this.jetzt = ListeBlacklist.getZeitZukunftBlacklist();
        return this.checkFilm(film);
    }

    private void setFilter() {
        try {
            if (this.daten.guiFilme.getFilterTage() == 0) {
                this.tage = 0L;
            } else {
                long max = 86400000L * (long)GuiFilme.COMBO_ZEIT_INT[this.daten.guiFilme.getFilterTage()];
                this.tage = new Date().getTime() - max;
            }
        }
        catch (Exception ex) {
            this.tage = 0L;
        }
        try {
            this.filmlaengeSoll = Long.valueOf(Daten.mVConfig.get("Blacklist-Filmlaenge")) * 60L;
        }
        catch (Exception ex) {
            this.filmlaengeSoll = 0L;
        }
        this.blacklistOn = Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-ausgeschaltet"));
        this.zukunftNichtAnzeigen = Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-Zukunft-nicht-anzeigen"));
        this.geoNichtAnzeigen = Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-Geo-nicht-anzeigen"));
        this.jetzt = ListeBlacklist.getZeitZukunftBlacklist();
    }

    private static long getZeitZukunftBlacklist() {
        return new Date().getTime();
    }

    private boolean checkFilm(DatenFilm film) {
        if (!this.checkDate(film)) {
            return false;
        }
        if (!this.blacklistOn) {
            return true;
        }
        if (this.geoNichtAnzeigen && !film.arr[11].isEmpty() && !film.arr[11].contains(Daten.mVConfig.get("Geo-Standort"))) {
            return false;
        }
        if (!this.checkZukunft(film)) {
            return false;
        }
        if (!this.checkFilmlaenge(film)) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        for (DatenBlacklist blacklistEntry : this) {
            String[] stringArray;
            String[] stringArray2;
            String string = blacklistEntry.arr[1];
            String string2 = blacklistEntry.arr[2];
            if (Filter.isPattern(blacklistEntry.arr[3])) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = blacklistEntry.arr[3];
            } else {
                stringArray2 = blacklistEntry.arr[3].toLowerCase().split(",");
            }
            if (Filter.isPattern(blacklistEntry.arr[4])) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = blacklistEntry.arr[4];
            } else {
                stringArray = blacklistEntry.arr[4].toLowerCase().split(",");
            }
            if (!Filter.filterAufFilmPruefen(string, string2, stringArray2, stringArray, new String[]{""}, 0, film, true)) continue;
            return Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-ist-Whitelist"));
        }
        return !Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-ist-Whitelist"));
    }

    private boolean checkDate(DatenFilm film) {
        try {
            if (this.tage != 0L && film.datumFilm.getTime() != 0L && film.datumFilm.getTime() < this.tage) {
                return false;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(462558700, ex);
        }
        return true;
    }

    private boolean checkZukunft(DatenFilm film) {
        try {
            if (this.zukunftNichtAnzeigen && film.datumFilm.getTime() > this.jetzt) {
                return false;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(696987123, ex);
        }
        return true;
    }

    private boolean checkFilmlaenge(DatenFilm film) {
        try {
            if (this.filmlaengeSoll != 0L && film.dauerL != 0L && this.filmlaengeSoll > film.dauerL) {
                return false;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(912304894, ex);
        }
        return true;
    }

    private String getNr(int nr) {
        int MAX_STELLEN = 3;
        String FUELL_ZEICHEN = "0";
        String str = String.valueOf(nr);
        while (str.length() < 3) {
            str = "0" + str;
        }
        return str;
    }
}

