/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.Timer;
import mediathek.tool.MVFunctionSys;

public class MVMemoryUsageButton
extends JButton {
    private final Runtime rt = Runtime.getRuntime();
    private final String MEMORY_STRING;
    private static final int MEGABYTE = 1000000;
    private static final int BAR_HEIGHT = 16;

    public MVMemoryUsageButton() {
        long maxMemory = Math.min(this.rt.maxMemory() / 1000000L, 9999L);
        this.MEMORY_STRING = maxMemory + " von " + maxMemory + "MiB ";
        this.setOpaque(false);
        this.setFocusable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        this.updateUI();
        Timer updateTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MVMemoryUsageButton.this.repaint();
            }
        });
        updateTimer.start();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        long maxMem = MVFunctionSys.getOs() == MVFunctionSys.OperatingSystemType.LINUX ? this.rt.totalMemory() : this.rt.maxMemory();
        long totalMemory = this.rt.totalMemory();
        long freeMemory = this.rt.freeMemory();
        long usedMem = totalMemory - freeMemory;
        Insets insets = this.getInsets();
        Dimension size = this.getSize();
        int totalBarLength = size.width - insets.left - insets.right;
        int yOffset = (size.height - 16) / 2;
        int xOffset = insets.left;
        g2d.setColor(new Color(190, 190, 190));
        g2d.fillRect(xOffset, yOffset, totalBarLength, 16);
        g2d.setColor(Color.RED);
        int usedBarLength = (int)((long)totalBarLength * usedMem / maxMem);
        g2d.fillRect(xOffset, yOffset, usedBarLength, 16);
        g2d.setColor(Color.GREEN);
        int unusedBarLength = (int)((long)totalBarLength * freeMemory / maxMem);
        g2d.fillRect(xOffset + usedBarLength, yOffset, unusedBarLength, 16);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(xOffset, yOffset, totalBarLength, 16);
        g2d.setFont(this.getFont());
        long used = usedMem / 1000000L;
        long total = maxMem / 1000000L;
        String info = used + " von " + total + "MB";
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int infoWidth = fontMetrics.charsWidth(info.toCharArray(), 0, info.length());
        int infoHeight = fontMetrics.getAscent();
        g2d.setColor(Color.BLACK);
        g2d.drawString(info, xOffset + (totalBarLength - infoWidth) / 2, yOffset + infoHeight + (16 - infoHeight) / 2 - 1);
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int width = this.getFontMetrics(this.getFont()).stringWidth(this.MEMORY_STRING) + insets.left + insets.right + 2;
        int height = this.getFontMetrics(this.getFont()).getHeight() + insets.top + insets.bottom + 2;
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

