/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import com.explodingpixels.macwidgets.BottomBar;
import com.explodingpixels.macwidgets.BottomBarSize;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.gui.MVMemoryUsageButton;
import mediathek.res.GetIcon;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.ListenerMediathekView;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;

public final class MVStatusBar
extends JPanel {
    private boolean stopTimer = false;
    private final EnumMap<StatusbarIndex, String> displayListForLeftLabel = new EnumMap(StatusbarIndex.class);
    private StatusbarIndex currentIndex = StatusbarIndex.NONE;
    private final JLabel lblLeft;
    private final JLabel lblRight;
    private final JProgressBar progress;
    private final JButton stopButton;
    private final BottomBar bottomBar;
    private final Daten daten;

    public MVStatusBar(Daten daten) {
        this.daten = daten;
        this.bottomBar = new BottomBar(BottomBarSize.LARGE);
        this.lblLeft = new JLabel();
        this.bottomBar.addComponentToLeft(this.lblLeft);
        if (Daten.debug) {
            this.bottomBar.addComponentToCenter(new MVMemoryUsageButton());
        }
        JPanel progressPanel = new JPanel();
        progressPanel.setBackground(this.bottomBar.getComponent().getBackground());
        progressPanel.setLayout(new FlowLayout());
        progressPanel.setOpaque(false);
        this.lblRight = new JLabel();
        progressPanel.add(this.lblRight);
        this.progress = new JProgressBar();
        progressPanel.add(this.progress);
        this.stopButton = new JButton();
        this.stopButton.setIcon(GetIcon.getProgramIcon("close.png"));
        this.stopButton.setToolTipText("Abbrechen");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.filmeLaden.setStop(true);
            }
        });
        progressPanel.add(this.stopButton);
        this.bottomBar.addComponentToRight(progressPanel);
        this.hideProgressIndicators();
        ListenerMediathekView.addListener(new ListenerMediathekView(30, MVStatusBar.class.getSimpleName()){

            @Override
            public void ping() {
                MVStatusBar.this.setTextForLeftDisplay();
                try {
                    if (!MVStatusBar.this.stopTimer) {
                        MVStatusBar.this.setTextForRightDisplay();
                    }
                }
                catch (Exception ex) {
                    Log.fehlerMeldung(936251087, ex);
                }
            }
        });
        Daten.filmeLaden.addAdListener(new MSListenerFilmeLaden(){

            public void start(MSListenerFilmeLadenEvent event) {
            }

            public void progress(MSListenerFilmeLadenEvent event) {
                MVStatusBar.this.updateProgressBar(event);
            }

            public void fertig(MSListenerFilmeLadenEvent event) {
                MVStatusBar.this.hideProgressIndicators();
            }
        });
    }

    public JComponent getComponent() {
        return this.bottomBar.getComponent();
    }

    private void hideProgressIndicators() {
        this.stopTimer = false;
        this.progress.setVisible(false);
        this.stopButton.setVisible(false);
        this.lblRight.setVisible(true);
        this.setTextForRightDisplay();
    }

    private void updateProgressBar(MSListenerFilmeLadenEvent event) {
        this.stopTimer = true;
        if (!this.progress.isVisible()) {
            this.progress.setVisible(true);
            this.stopButton.setVisible(true);
        }
        if (event.max == 0 || event.progress == event.max) {
            this.progress.setIndeterminate(true);
            this.progress.setMaximum(0);
            this.progress.setMinimum(0);
            this.progress.setValue(0);
            this.progress.setStringPainted(true);
            this.progress.setString(event.text);
        } else {
            this.progress.setIndeterminate(false);
            this.progress.setMaximum(event.max);
            this.progress.setMinimum(0);
            this.progress.setValue(event.progress);
            this.progress.setStringPainted(true);
            this.progress.setString(event.text);
        }
        if (Daten.debug) {
            this.lblRight.setText(GuiFunktionen.textLaenge(60, event.senderUrl, true, true));
        } else {
            this.lblRight.setVisible(false);
        }
    }

    public void setIndexForLeftDisplay(StatusbarIndex i) {
        this.currentIndex = i;
        String displayString = this.displayListForLeftLabel.get((Object)i);
        this.lblLeft.setText(displayString);
    }

    public void setTextForLeftDisplay() {
        switch (this.currentIndex) {
            case FILME: {
                this.setInfoFilme();
                break;
            }
            case DOWNLOAD: {
                this.setInfoDownload();
                break;
            }
            case ABO: {
                this.setInfoAbo();
                break;
            }
        }
        String displayString = this.displayListForLeftLabel.get((Object)this.currentIndex);
        this.lblLeft.setText(displayString);
    }

    private void setInfoFilme() {
        String textLinks;
        String TRENNER = "  ||  ";
        int gesamt = Daten.listeFilme.size();
        int anzListe = this.daten.guiFilme.getTableRowCount();
        int runs = Daten.listeDownloadsButton.getListOfStartsNotFinished(1).size();
        if (gesamt == anzListe) {
            textLinks = anzListe == 1 ? "1 Film" : anzListe + " Filme";
        } else {
            textLinks = anzListe == 1 ? "1 Film" : anzListe + " Filme";
            textLinks = textLinks + " (Insgesamt: " + gesamt + " )";
        }
        if (runs == 1) {
            textLinks = textLinks + "  ||  ";
            textLinks = textLinks + runs + " laufender Film";
        } else if (runs > 1) {
            textLinks = textLinks + "  ||  ";
            textLinks = textLinks + runs + " laufende Filme";
        }
        textLinks = textLinks + "  ||  ";
        textLinks = textLinks + this.getInfoTextDownloads(false);
        this.displayListForLeftLabel.put(StatusbarIndex.FILME, textLinks);
    }

    private void setInfoDownload() {
        String textLinks = this.getInfoTextDownloads(true);
        this.displayListForLeftLabel.put(StatusbarIndex.DOWNLOAD, textLinks);
    }

    private void setInfoAbo() {
        int ein = 0;
        int aus = 0;
        int gesamt = Daten.listeAbo.size();
        for (DatenAbo abo : Daten.listeAbo) {
            if (abo.aboIstEingeschaltet()) {
                ++ein;
                continue;
            }
            ++aus;
        }
        String textLinks = gesamt == 1 ? "1 Abo, " : gesamt + " Abos, ";
        textLinks = textLinks + "(" + ein + " eingeschaltet, " + aus + " ausgeschaltet)";
        this.displayListForLeftLabel.put(StatusbarIndex.ABO, textLinks);
    }

    private String getInfoTextDownloads(boolean mitAbo) {
        int[] starts = Daten.downloadInfos.downloadStarts;
        String textLinks = starts[0] == 1 ? "1 Download" : starts[0] + " Downloads";
        if (mitAbo) {
            textLinks = starts[1] == 1 ? textLinks + " (1 Abo, " : textLinks + " (" + starts[1] + " Abos, ";
            textLinks = starts[2] == 1 ? textLinks + "1 Download)" : textLinks + starts[2] + " Downloads)";
        }
        boolean print = false;
        for (int ii = 1; ii < starts.length; ++ii) {
            if (starts[ii] <= 0) continue;
            print = true;
            break;
        }
        if (print) {
            textLinks = textLinks + ": ";
            textLinks = starts[4] == 1 ? textLinks + "1 l\u00e4uft" : textLinks + starts[4] + " laufen";
            if (starts[4] > 0) {
                textLinks = textLinks + " (" + Daten.downloadInfos.bandwidthStr + ")";
            }
            textLinks = starts[3] == 1 ? textLinks + ", 1 wartet" : textLinks + ", " + starts[3] + " warten";
            if (starts[5] > 0) {
                textLinks = starts[5] == 1 ? textLinks + ", 1 fertig" : textLinks + ", " + starts[5] + " fertig";
            }
            if (starts[6] > 0) {
                textLinks = starts[6] == 1 ? textLinks + ", 1 fehlerhaft" : textLinks + ", " + starts[6] + " fehlerhaft";
            }
        }
        return textLinks;
    }

    private void setTextForRightDisplay() {
        String strText = "Filmliste erstellt: ";
        strText = strText + Daten.listeFilme.genDate();
        strText = strText + " Uhr  ";
        int sekunden = Daten.listeFilme.getAge();
        if (sekunden != 0) {
            strText = strText + "||  Alter: ";
            int minuten = sekunden / 60;
            String strSekunde = String.valueOf(sekunden % 60);
            String strMinute = String.valueOf(minuten % 60);
            String strStunde = String.valueOf(minuten / 60);
            if (strSekunde.length() < 2) {
                strSekunde = "0" + strSekunde;
            }
            if (strMinute.length() < 2) {
                strMinute = "0" + strMinute;
            }
            if (strStunde.length() < 2) {
                strStunde = "0" + strStunde;
            }
            strText = strText + strStunde + ":" + strMinute + ":" + strSekunde + " ";
        }
        this.lblRight.setText(strText);
    }

    public static enum StatusbarIndex {
        NONE,
        FILME,
        DOWNLOAD,
        ABO;

    }
}

