/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URISyntaxException;
import java.nio.file.Path;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.UrlHyperlinkAction;
import org.jdesktop.swingx.JXHyperlink;

public class PanelProgrammInfos
extends PanelVorlage {
    private JXHyperlink jXHyperlinkAnleitung;
    private JXHyperlink jXHyperlinkForum;
    private JXHyperlink jXHyperlinkWebsite;
    private JLabel lblFilmlistpath;
    private JLabel lblFreeMemory;
    private JLabel lblMaxVmMemory;
    private JLabel lblProgramPath;
    private JLabel lblProgrammversion;
    private JLabel lblSettingsPath;
    private JLabel lblVmMemory;

    public PanelProgrammInfos(Daten dd, JFrame parentComponent) {
        super(dd, parentComponent);
        this.initComponents();
        try {
            this.lblProgrammversion.setText(MVFunctionSys.getProgVersionString() + " vom: " + MVFunctionSys.getCompileDate());
        }
        catch (Exception ignored) {
            this.lblProgrammversion.setText("11");
        }
        this.lblProgramPath.setText(MVFunctionSys.getPathJar());
        try {
            Path xmlFilePath = Daten.getMediathekXmlFilePath();
            this.lblSettingsPath.setText(xmlFilePath.toAbsolutePath().toString());
            this.lblFilmlistpath.setText(Daten.getDateiFilmliste());
            this.jXHyperlinkWebsite.setText("http://zdfmediathk.sourceforge.net/");
            this.jXHyperlinkWebsite.addActionListener((ActionListener)new UrlHyperlinkAction(parentComponent, "http://zdfmediathk.sourceforge.net/"));
            this.jXHyperlinkAnleitung.setText("http://sourceforge.net/p/zdfmediathk/wiki/Home/");
            this.jXHyperlinkAnleitung.addActionListener((ActionListener)new UrlHyperlinkAction(parentComponent, "http://sourceforge.net/p/zdfmediathk/wiki/Home/"));
            this.jXHyperlinkForum.setText("http://zdfmediathk.sourceforge.net/forum/");
            this.jXHyperlinkForum.addActionListener((ActionListener)new UrlHyperlinkAction(parentComponent, "http://zdfmediathk.sourceforge.net/forum/"));
        }
        catch (URISyntaxException xmlFilePath) {
            // empty catch block
        }
        this.updateMemory();
        Timer memUpdateTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelProgrammInfos.this.updateMemory();
            }
        });
        memUpdateTimer.setRepeats(true);
        memUpdateTimer.start();
    }

    private void updateMemory() {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory() / 1000000L;
        long maxMem = rt.maxMemory() / 1000000L;
        long freeMem = rt.freeMemory() / 1000000L;
        this.lblVmMemory.setText(totalMem + " MB");
        this.lblMaxVmMemory.setText(maxMem + " MB");
        this.lblFreeMemory.setText(freeMem + " MB");
    }

    private void initComponents() {
        JLabel jLabel3 = new JLabel();
        JTextField jTextField1 = new JTextField();
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabelSpeicher1 = new JLabel();
        JLabel jLabelSpeicher2 = new JLabel();
        JLabel jLabelSpeicher3 = new JLabel();
        this.lblVmMemory = new JLabel();
        this.lblMaxVmMemory = new JLabel();
        this.lblFreeMemory = new JLabel();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel9 = new JLabel();
        this.jXHyperlinkWebsite = new JXHyperlink();
        this.jXHyperlinkAnleitung = new JXHyperlink();
        this.jXHyperlinkForum = new JXHyperlink();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.lblProgrammversion = new JLabel();
        this.lblFilmlistpath = new JLabel();
        this.lblProgramPath = new JLabel();
        this.lblSettingsPath = new JLabel();
        jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/MediathekView_k.png")));
        jTextField1.setEditable(false);
        jTextField1.setBackground(new Color(204, 204, 255));
        jTextField1.setFont(new Font("Dialog", 1, 14));
        jTextField1.setHorizontalAlignment(0);
        jTextField1.setText("MediathekView");
        jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jLabelSpeicher1.setFont(jLabelSpeicher1.getFont().deriveFont(jLabelSpeicher1.getFont().getStyle() | 1));
        jLabelSpeicher1.setText("Speicher der VM:");
        jLabelSpeicher2.setFont(jLabelSpeicher2.getFont().deriveFont(jLabelSpeicher2.getFont().getStyle() | 1));
        jLabelSpeicher2.setText("Max. Speicher der VM:");
        jLabelSpeicher3.setFont(jLabelSpeicher3.getFont().deriveFont(jLabelSpeicher3.getFont().getStyle() | 1));
        jLabelSpeicher3.setText("Freier Speicher:");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabelSpeicher1).addComponent(jLabelSpeicher2).addComponent(jLabelSpeicher3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblVmMemory, -1, 507, Short.MAX_VALUE).addComponent(this.lblMaxVmMemory, -1, -1, Short.MAX_VALUE).addComponent(this.lblFreeMemory, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabelSpeicher1).addComponent(this.lblVmMemory)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabelSpeicher2).addComponent(this.lblMaxVmMemory)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabelSpeicher3).addComponent(this.lblFreeMemory)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jLabel5.setFont(jLabel5.getFont().deriveFont(jLabel5.getFont().getStyle() | 1));
        jLabel5.setText("Website:");
        jLabel7.setFont(jLabel7.getFont().deriveFont(jLabel7.getFont().getStyle() | 1));
        jLabel7.setText("Anleitung:");
        jLabel9.setFont(jLabel9.getFont().deriveFont(jLabel9.getFont().getStyle() | 1));
        jLabel9.setText("Forum:");
        this.jXHyperlinkWebsite.setText("http://zdfmediathk.sourceforge.net/");
        this.jXHyperlinkAnleitung.setText("http://sourceforge.net/p/zdfmediathk/wiki/Home/");
        this.jXHyperlinkForum.setText("http://zdfmediathk.sourceforge.net/forum/");
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel5).addComponent(jLabel7).addComponent(jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jXHyperlinkWebsite, -2, -1, -2).addComponent((Component)this.jXHyperlinkAnleitung, -2, -1, -2).addComponent((Component)this.jXHyperlinkForum, -2, -1, -2)).addContainerGap(253, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent((Component)this.jXHyperlinkWebsite, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel9).addComponent((Component)this.jXHyperlinkForum, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent((Component)this.jXHyperlinkAnleitung, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jLabel1.setFont(jLabel1.getFont().deriveFont(jLabel1.getFont().getStyle() | 1));
        jLabel1.setText("Programmversion:");
        jLabel6.setFont(jLabel6.getFont().deriveFont(jLabel6.getFont().getStyle() | 1));
        jLabel6.setText("Filmeliste:");
        jLabel2.setFont(jLabel2.getFont().deriveFont(jLabel2.getFont().getStyle() | 1));
        jLabel2.setText("Programmpfad:");
        jLabel4.setFont(jLabel4.getFont().deriveFont(jLabel4.getFont().getStyle() | 1));
        jLabel4.setText("Einstellungen:");
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel6).addComponent(jLabel2).addComponent(jLabel4).addComponent(jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblProgrammversion, GroupLayout.Alignment.TRAILING, -1, 531, Short.MAX_VALUE).addComponent(this.lblFilmlistpath, -1, -1, Short.MAX_VALUE).addComponent(this.lblProgramPath, -1, -1, Short.MAX_VALUE).addComponent(this.lblSettingsPath, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.lblProgrammversion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(this.lblFilmlistpath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.lblProgramPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.lblSettingsPath)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel3, -1, -1, Short.MAX_VALUE).addComponent(jPanel2, -1, -1, Short.MAX_VALUE).addComponent(jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel4, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(jLabel3).addGap(4, 4, 4).addComponent(jPanel1, -1, -1, Short.MAX_VALUE)).addComponent(jTextField1, -1, 756, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(jLabel3).addGap(0, 0, Short.MAX_VALUE)).addComponent(jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }
}

