/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import com.apple.eawt.Application;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;

class OsxIndicatorThread
extends Thread {
    private Image OsxApplicationIconImage = null;
    private BufferedImage newApplicationIcon = null;
    private final int appIconWidth;
    private final int appIconHeight;
    private double oldPercentage;
    private boolean bFirstUpdate = true;
    private final Application application = Application.getApplication();

    public OsxIndicatorThread() {
        this.setName("OSX dock icon update thread");
        this.OsxApplicationIconImage = this.application.getDockIconImage();
        this.appIconWidth = this.OsxApplicationIconImage.getWidth(null);
        this.appIconHeight = this.OsxApplicationIconImage.getHeight(null);
        this.newApplicationIcon = new BufferedImage(this.appIconWidth, this.appIconHeight, 2);
    }

    private void drawAndSetApplicationIconWithProgress(int progressBarWidth) {
        Graphics g = this.newApplicationIcon.getGraphics();
        g.drawImage(this.OsxApplicationIconImage, 0, 0, null);
        g.setColor(Color.RED);
        g.fillRect(0, this.appIconHeight - 20, this.appIconWidth, 20);
        g.setColor(Color.GREEN);
        g.fillRect(0, this.appIconHeight - 20, progressBarWidth, 20);
        g.dispose();
        this.application.setDockIconImage((Image)this.newApplicationIcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                int numOfDownloadsActive = 0;
                double accumPercentage = 0.0;
                LinkedList<DatenDownload> activeDownloadList = Daten.listeDownloads.getListOfStartsNotFinished(-1);
                for (DatenDownload download : activeDownloadList) {
                    if (download.start == null || download.start.status != 2) continue;
                    ++numOfDownloadsActive;
                    accumPercentage += (double)download.start.percent / 10.0;
                }
                double percentage = accumPercentage / (double)numOfDownloadsActive;
                int progressBarWidth = (int)((double)this.appIconWidth / 100.0 * percentage);
                if (this.bFirstUpdate) {
                    this.drawAndSetApplicationIconWithProgress(progressBarWidth);
                    this.bFirstUpdate = false;
                }
                if (percentage % 1.0 == 0.0) {
                    if (this.oldPercentage != percentage) {
                        this.drawAndSetApplicationIconWithProgress(progressBarWidth);
                    }
                    this.oldPercentage = percentage;
                }
                OsxIndicatorThread.sleep(500L);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.application.setDockIconImage(this.OsxApplicationIconImage);
        }
    }
}

