/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JFrame;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.gui.dialog.DialogZiel;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionen;
import msearch.daten.DatenFilm;

public class MVInfoFile {
    public static void writeInfoFile(JFrame paFrame, Daten daten, DatenFilm film) {
        String titel = film.arr[3];
        titel = FilenameUtils.replaceLeerDateiname(titel, false);
        String pfad = "";
        ListePset lp = Daten.listePset.getListeSpeichern();
        if (lp.size() > 0) {
            DatenPset p = (DatenPset)lp.get(0);
            pfad = p.getZielPfad();
        }
        if (pfad.isEmpty()) {
            pfad = GuiFunktionen.getStandardDownloadPath();
        }
        titel = titel.isEmpty() ? film.arr[1].replace(" ", "-") + ".txt" : titel + ".txt";
        pfad = GuiFunktionen.addsPfad(pfad, titel);
        DialogZiel dialog = new DialogZiel(paFrame, true, pfad, "Infos speichern");
        dialog.setVisible(true);
        if (!dialog.ok) {
            return;
        }
        Path path = Paths.get(dialog.ziel, new String[0]);
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter(new DataOutputStream(Files.newOutputStream(path, new OpenOption[0]))));){
            br.write("Sender:      " + film.arr[1]);
            br.write("\n");
            br.write("Thema:       " + film.arr[2]);
            br.write("\n\n");
            br.write("Titel:       " + film.arr[3]);
            br.write("\n\n");
            br.write("Datum:       " + film.arr[6]);
            br.write("\n");
            br.write("Zeit:        " + film.arr[7]);
            br.write("\n");
            br.write("Dauer:       " + film.arr[8]);
            br.write("\n");
            br.write("Gr\u00f6\u00dfe [MB]:  " + film.arr[9]);
            br.write("\n\n");
            br.write("Website\n");
            br.write(film.arr[13]);
            br.write("\n\n");
            br.write("Url\n");
            br.write(film.arr[12]);
            br.write("\n\n");
            if (!film.arr[16].isEmpty()) {
                br.write("UrlRTMP\n");
                br.write(film.arr[16]);
                br.write("\n\n");
            }
            int anz = 0;
            for (String s : film.arr[10].split(" ")) {
                br.write(s + " ");
                if ((anz += s.length()) <= 50) continue;
                br.write("\n");
                anz = 0;
            }
            br.write("\n\n");
            br.flush();
        }
        catch (IOException ex) {
            Log.fehlerMeldung(632656214, dialog.ziel);
        }
    }

    public static void writeInfoFile(DatenDownload datenDownload) {
        try {
            Log.systemMeldung(new String[]{"Infofile schreiben nach: ", datenDownload.arr[28]});
            new File(datenDownload.arr[28]).mkdirs();
            Path path = Paths.get(datenDownload.arr[29] + ".txt", new String[0]);
            BufferedWriter br = new BufferedWriter(new OutputStreamWriter(new DataOutputStream(Files.newOutputStream(path, new OpenOption[0]))));
            if (datenDownload.film != null) {
                br.write("Sender:      " + datenDownload.film.arr[1]);
                br.write("\n");
                br.write("Thema:       " + datenDownload.film.arr[2]);
                br.write("\n\n");
                br.write("Titel:       " + datenDownload.film.arr[3]);
                br.write("\n\n");
                br.write("Datum:       " + datenDownload.film.arr[6]);
                br.write("\n");
                br.write("Zeit:        " + datenDownload.film.arr[7]);
                br.write("\n");
                br.write("Dauer:       " + datenDownload.film.arr[8]);
                br.write("\n");
                br.write("Gr\u00f6\u00dfe [MB]:  " + datenDownload.mVFilmSize);
                br.write("\n\n");
                br.write("Website\n");
                br.write(datenDownload.film.arr[13]);
                br.write("\n\n");
            }
            br.write("URL\n");
            br.write(datenDownload.arr[19]);
            br.write("\n\n");
            if (!datenDownload.arr[20].isEmpty() && !datenDownload.arr[20].equals(datenDownload.arr[19])) {
                br.write("URL-rtmp\n");
                br.write(datenDownload.arr[20]);
                br.write("\n\n");
            }
            if (datenDownload.film != null) {
                int anz = 0;
                for (String s : datenDownload.film.arr[10].split(" ")) {
                    br.write(s + " ");
                    if ((anz += s.length()) <= 50) continue;
                    br.write("\n");
                    anz = 0;
                }
            }
            br.write("\n\n");
            br.flush();
            br.close();
            Log.systemMeldung(new String[]{"Infofile", "  geschrieben"});
        }
        catch (IOException ex) {
            Log.fehlerMeldung(975410369, datenDownload.arr[29]);
        }
    }
}

