/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcarrierpigeon;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JWindow;
import net.sf.jcarrierpigeon.AnimationFrame;
import net.sf.jcarrierpigeon.WindowPosition;
import net.sf.jcarrierpigeon.WindowType;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class Notification
implements TimingTarget {
    private WindowPosition windowPosition;
    private WindowType windowType;
    private int thisHeight;
    private int thisWidth;
    private JFrame windowJFrame;
    private JWindow windowJWindow;
    private double borderX;
    private double borderY;
    private double boundX;
    private double boundY;
    private double positionX;
    private double positionY;
    private int duration;
    private AnimationFrame animationFrame;
    private Animator animatorHandlerOnShow;
    private Animator animatorHandlerOnDisplay;
    private Animator animatorHandlerOnClose;
    private int timeToAnimate = 500;

    public Notification(JFrame window, WindowPosition windowPosition, int borderX, int borderY, int duration) {
        this.windowType = WindowType.JFRAME;
        this.windowJWindow = null;
        this.windowPosition = windowPosition;
        this.windowJFrame = window;
        this.borderX = borderX;
        this.borderY = borderY;
        this.thisHeight = this.windowJFrame.getHeight();
        this.thisWidth = this.windowJFrame.getWidth();
        this.duration = duration;
        Rectangle rect = this.getScreenResolution();
        this.boundX = rect.getWidth();
        this.boundY = rect.getHeight();
        switch (this.windowPosition) {
            case BOTTOMRIGHT: {
                this.positionX = this.boundX - ((double)this.thisWidth + this.borderX);
                this.positionY = this.boundY - ((double)this.thisHeight + this.borderY);
                break;
            }
            case BOTTOMLEFT: {
                this.positionX = this.borderX;
                this.positionY = this.boundY - ((double)this.thisHeight + this.borderY);
                break;
            }
            case TOPRIGHT: {
                this.positionX = this.boundX - ((double)this.thisWidth + this.borderX);
                this.positionY = this.borderY;
                break;
            }
            case TOPLEFT: {
                this.positionX = this.borderX;
                this.positionY = this.borderY;
            }
        }
    }

    public Notification(JWindow window, WindowPosition windowPosition, int borderX, int borderY, int duration) {
        this.windowType = WindowType.JWINDOW;
        this.windowJFrame = null;
        this.windowPosition = windowPosition;
        this.windowJWindow = window;
        this.borderX = borderX;
        this.borderY = borderY;
        this.thisHeight = this.windowJWindow.getHeight();
        this.thisWidth = this.windowJWindow.getWidth();
        this.duration = duration;
        Rectangle rect = this.getScreenResolution();
        this.boundX = rect.getWidth();
        this.boundY = rect.getHeight();
        switch (this.windowPosition) {
            case BOTTOMRIGHT: {
                this.positionX = this.boundX - ((double)this.thisWidth + this.borderX);
                this.positionY = this.boundY - ((double)this.thisHeight + this.borderY);
                break;
            }
            case BOTTOMLEFT: {
                this.positionX = this.borderX;
                this.positionY = this.boundY - ((double)this.thisHeight + this.borderY);
                break;
            }
            case TOPRIGHT: {
                this.positionX = this.boundX - ((double)this.thisWidth + this.borderX);
                this.positionY = this.borderY;
                break;
            }
            case TOPLEFT: {
                this.positionX = this.borderX;
                this.positionY = this.borderY;
            }
        }
    }

    private Rectangle getScreenResolution() {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return environment.getMaximumWindowBounds();
    }

    private int calculateCurrentPositionOnY(float x) {
        int result = 0;
        if (this.animationFrame == AnimationFrame.ONSHOW) {
            switch (this.windowPosition) {
                case BOTTOMRIGHT: 
                case BOTTOMLEFT: {
                    result = (int)(this.positionY + (this.boundY - this.positionY) * (double)(1.0f - x));
                    break;
                }
                case TOPRIGHT: 
                case TOPLEFT: {
                    result = (int)(this.positionY - ((double)this.thisHeight + this.borderY) * (double)(1.0f - x));
                }
            }
        } else if (this.animationFrame == AnimationFrame.ONCLOSE) {
            switch (this.windowPosition) {
                case BOTTOMRIGHT: 
                case BOTTOMLEFT: {
                    result = (int)(this.positionY + (this.boundY - this.positionY) * (double)x);
                    break;
                }
                case TOPRIGHT: 
                case TOPLEFT: {
                    result = (int)(this.positionY - ((double)this.thisHeight + this.borderY) * (double)x);
                }
            }
        } else {
            result = (int)this.positionY;
        }
        return result;
    }

    @Override
    public void timingEvent(float f) {
        this.setCurrentWindowBounds((int)this.positionX, this.calculateCurrentPositionOnY(f), this.thisWidth, this.thisHeight);
    }

    @Override
    public void begin() {
    }

    @Override
    public void end() {
        if (this.animationFrame == AnimationFrame.ONSHOW) {
            this.animatorHandlerOnDisplay = new Animator(this.duration, 1.0, Animator.RepeatBehavior.LOOP, this);
            this.animationFrame = AnimationFrame.ONDISPLAY;
            this.animatorHandlerOnDisplay.start();
        } else if (this.animationFrame == AnimationFrame.ONDISPLAY) {
            this.animatorHandlerOnClose = new Animator(this.timeToAnimate, 1.0, Animator.RepeatBehavior.LOOP, this);
            this.animationFrame = AnimationFrame.ONCLOSE;
            this.animatorHandlerOnClose.start();
        } else {
            this.setCurrentWindowVisible(false);
            this.disposeCurrentWindow();
        }
    }

    @Override
    public void repeat() {
    }

    public synchronized void animate() {
        this.animationFrame = AnimationFrame.ONSHOW;
        this.setCurrentWindowAlwaysOnTop(true);
        this.setCurrentWindowVisible(true);
        this.animatorHandlerOnShow = new Animator(this.timeToAnimate, 1.0, Animator.RepeatBehavior.LOOP, this);
        this.animatorHandlerOnShow.start();
    }

    public boolean isRunning() {
        return this.animatorHandlerOnShow.isRunning() || this.animatorHandlerOnDisplay.isRunning() || this.animatorHandlerOnClose.isRunning();
    }

    private void setCurrentWindowBounds(int x, int y, int width, int height) {
        switch (this.windowType) {
            case JFRAME: {
                this.windowJFrame.setBounds(x, y, width, height);
                break;
            }
            case JWINDOW: {
                this.windowJWindow.setBounds(x, y, width, height);
            }
        }
    }

    private void setCurrentWindowVisible(boolean value) {
        switch (this.windowType) {
            case JFRAME: {
                this.windowJFrame.setVisible(value);
                break;
            }
            case JWINDOW: {
                this.windowJWindow.setVisible(value);
            }
        }
    }

    private void setCurrentWindowAlwaysOnTop(boolean value) {
        switch (this.windowType) {
            case JFRAME: {
                this.windowJFrame.setAlwaysOnTop(value);
                break;
            }
            case JWINDOW: {
                this.windowJWindow.setAlwaysOnTop(value);
            }
        }
    }

    private void disposeCurrentWindow() {
        switch (this.windowType) {
            case JFRAME: {
                this.windowJFrame.dispose();
                break;
            }
            case JWINDOW: {
                this.windowJWindow.dispose();
            }
        }
    }

    public void setAnimationSpeed(int milliseconds) {
        this.timeToAnimate = milliseconds;
    }
}

