/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Overlayable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DefaultOverlayable
extends JPanel
implements Overlayable,
ComponentListener {
    private JComponent _actualComponent;
    private Insets _overlayLocationInsets = new Insets(0, 0, 0, 0);
    private List<JComponent> _overlayComponents;
    private Map<JComponent, Integer> _overlayLocations;

    public DefaultOverlayable() {
        this.initComponents();
    }

    public DefaultOverlayable(JComponent component) {
        this.initComponents();
        this.setActualComponent(component);
    }

    public DefaultOverlayable(JComponent actualComponent, JComponent overlayComponent, int overlayLocation) {
        this.initComponents();
        this.setActualComponent(actualComponent);
        this.addOverlayComponent(overlayComponent, overlayLocation);
    }

    public DefaultOverlayable(JComponent actualComponent, JComponent overlayComponent) {
        this.initComponents();
        this.setActualComponent(actualComponent);
        this.addOverlayComponent(overlayComponent, 0);
    }

    private void initComponents() {
        this.setLayout(null);
        this._overlayComponents = new Vector<JComponent>();
        this._overlayLocations = new Hashtable<JComponent, Integer>();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.getActualComponent() == null ? new Dimension(0, 0) : this.getActualComponent().getPreferredSize();
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            size.width += Math.max(0, insets.left) + Math.max(0, insets.right);
            size.height += Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        return size;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        if (this.getActualComponent() != null) {
            Insets insets;
            if (preferredSize != null && (insets = this.getOverlayLocationInsets()) != null) {
                preferredSize.width -= Math.max(0, insets.left) + Math.max(0, insets.right);
                preferredSize.width = Math.max(0, preferredSize.width);
                preferredSize.height -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
                preferredSize.height = Math.max(0, preferredSize.height);
            }
            this.getActualComponent().setPreferredSize(preferredSize);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = this.getActualComponent() == null ? new Dimension(0, 0) : this.getActualComponent().getMinimumSize();
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            size.width += Math.max(0, insets.left) + Math.max(0, insets.right);
            size.height += Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        return size;
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        super.setMinimumSize(minimumSize);
        if (this.getActualComponent() != null) {
            Insets insets;
            if (minimumSize != null && (insets = this.getOverlayLocationInsets()) != null) {
                minimumSize.width -= Math.max(0, insets.left) + Math.max(0, insets.right);
                minimumSize.width = Math.max(0, minimumSize.width);
                minimumSize.height -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
                minimumSize.height = Math.max(0, minimumSize.height);
            }
            this.getActualComponent().setMinimumSize(minimumSize);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            x = Math.max(0, insets.left);
            y = Math.max(0, insets.top);
            width -= Math.max(0, insets.left) + Math.max(0, insets.right);
            height -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        if (this.getActualComponent() != null) {
            this.getActualComponent().setBounds(x, y, width, height);
        }
        this.updateLocation();
    }

    private void updateLocation() {
        JComponent[] components;
        for (JComponent c : components = this.getOverlayComponents()) {
            if (c == null) {
                return;
            }
            Rectangle r = this.getOverlayComponentBounds(c);
            c.setBounds(r);
        }
    }

    protected Rectangle getOverlayComponentBounds(JComponent component) {
        JComponent relativeComponent = this.getActualComponent();
        Rectangle bounds = relativeComponent.getBounds();
        if (relativeComponent != this.getActualComponent()) {
            bounds = SwingUtilities.convertRectangle(relativeComponent.getParent(), bounds, this.getActualComponent());
        }
        Rectangle overlayBounds = new Rectangle(bounds);
        Insets insets = this.getOverlayLocationInsets();
        overlayBounds.x -= insets.left;
        overlayBounds.y -= insets.top;
        overlayBounds.width += insets.left + insets.right;
        overlayBounds.height += insets.top + insets.bottom;
        int cx = 0;
        int cy = 0;
        Dimension size = component.getPreferredSize();
        int cw = size.width;
        int ch = size.height;
        switch (this.getOverlayLocation(component)) {
            case 0: {
                cx = bounds.x + (bounds.width - cw) / 2;
                cy = bounds.y + (bounds.height - ch) / 2;
                break;
            }
            case 1: {
                cx = bounds.x + (bounds.width - cw) / 2;
                cy = overlayBounds.y;
                break;
            }
            case 5: {
                cx = bounds.x + (bounds.width - cw) / 2;
                cy = overlayBounds.y + overlayBounds.height - ch;
                break;
            }
            case 7: {
                cx = overlayBounds.x;
                cy = bounds.y + (bounds.height - ch) / 2;
                break;
            }
            case 3: {
                cx = overlayBounds.x + overlayBounds.width - cw;
                cy = bounds.y + (bounds.height - ch) / 2;
                break;
            }
            case 8: {
                cx = overlayBounds.x;
                cy = overlayBounds.y;
                break;
            }
            case 2: {
                cx = overlayBounds.x + overlayBounds.width - cw;
                cy = overlayBounds.y;
                break;
            }
            case 6: {
                cx = overlayBounds.x;
                cy = overlayBounds.y + overlayBounds.height - ch;
                break;
            }
            case 4: {
                cx = overlayBounds.x + overlayBounds.width - cw;
                cy = overlayBounds.y + overlayBounds.height - ch;
            }
        }
        return new Rectangle(cx, cy, cw, ch);
    }

    @Override
    public int getOverlayLocation(JComponent component) {
        Integer location = this._overlayLocations.get(component);
        if (location != null) {
            return location;
        }
        return -1;
    }

    @Override
    public void setOverlayLocation(JComponent component, int location) {
        this.setOverlayLocation(component, null, location);
    }

    private void setOverlayLocation(JComponent component, Component relativeComponent, int location) {
        boolean updated = false;
        int old = this.getOverlayLocation(component);
        if (old != location) {
            this._overlayLocations.put(component, location);
            updated = true;
        }
        if (updated) {
            this.updateLocation();
        }
    }

    @Override
    public void addOverlayComponent(JComponent component) {
        this.addOverlayComponent(component, 0, -1);
    }

    @Override
    public void addOverlayComponent(JComponent component, int location) {
        this.addOverlayComponent(component, location, -1);
    }

    @Override
    public void addOverlayComponent(JComponent component, int location, int index) {
        this.addOverlayComponent(component, null, location, index);
    }

    private void addOverlayComponent(JComponent component, Component relativeComponent, int location, int index) {
        if (this._overlayComponents.contains(component)) {
            this._overlayComponents.remove(component);
        }
        if (index == -1) {
            this._overlayComponents.add(component);
            this.add((Component)component, this.getComponentCount() - 1);
        } else {
            this._overlayComponents.add(index, component);
            this.add((Component)component, index);
        }
        this.setOverlayLocation(component, relativeComponent, location);
    }

    @Override
    public void removeOverlayComponent(JComponent component) {
        if (this._overlayComponents.contains(component)) {
            this._overlayComponents.remove(component);
            this._overlayLocations.remove(component);
            this.remove(component);
        }
    }

    @Override
    public JComponent[] getOverlayComponents() {
        return this._overlayComponents.toArray(new JComponent[this._overlayComponents.size()]);
    }

    public JComponent getActualComponent() {
        return this._actualComponent;
    }

    public void setActualComponent(JComponent actualComponent) {
        if (this._actualComponent != null) {
            this.remove(this._actualComponent);
            this._actualComponent.putClientProperty("Overlayable.overlayable", null);
        }
        this._actualComponent = actualComponent;
        this._actualComponent.putClientProperty("Overlayable.overlayable", this);
        this.add(this._actualComponent);
        Container container = this.getParent();
        if (container != null) {
            this.invalidate();
            container.validate();
        }
    }

    @Override
    public Insets getOverlayLocationInsets() {
        return this._overlayLocationInsets;
    }

    @Override
    public void setOverlayLocationInsets(Insets overlayLocationInsets) {
        this._overlayLocationInsets = overlayLocationInsets;
        Container container = this.getParent();
        if (container != null) {
            this.invalidate();
            container.validate();
        }
    }

    @Override
    public void setOverlayVisible(boolean visible) {
        JComponent[] components;
        for (JComponent component : components = this.getOverlayComponents()) {
            component.setVisible(visible);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateLocation();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.updateLocation();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.updateLocation();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.updateLocation();
    }
}

