/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.SimpleDateFormat;
import java.util.Date;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.filmeSuchen.sender.MediathekZdf;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class Mediathek3Sat
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "3Sat";

    public Mediathek3Sat(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 500, startPrio);
    }

    @Override
    void addToList() {
        this.listeThemen.clear();
        this.meldungStart();
        this.sendungenLaden();
        this.tageLaden();
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            Mediathek3Sat.listeSort(this.listeThemen, 1);
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void tageLaden() {
        for (int i = 0; i < (MSConfig.loadLongMax() ? 21 : 7); ++i) {
            String date = new SimpleDateFormat("yyyyMMdd").format(new Date().getTime() - (long)(i * 86400000));
            String url = "https://www.3sat.de/mediathek/index.php?datum=" + date + "&cx=134";
            this.listeThemen.add(new String[]{url, ""});
        }
    }

    private void sendungenLaden() {
        String ADRESSE = "http://www.3sat.de/mediathek/";
        String MUSTER_URL = "<a class=\"SubItem\" href=\"http://www.3sat.de/mediathek/?red=";
        MSStringBuilder seite = new MSStringBuilder(65536);
        seite = this.getUrlIo.getUri_Utf(SENDERNAME, "http://www.3sat.de/mediathek/", seite, "");
        int pos1 = 0;
        String url = "";
        String thema = "";
        while ((pos1 = seite.indexOf("<a class=\"SubItem\" href=\"http://www.3sat.de/mediathek/?red=", pos1)) != -1) {
            try {
                int pos2 = seite.indexOf("\"", pos1 += "<a class=\"SubItem\" href=\"http://www.3sat.de/mediathek/?red=".length());
                if (pos2 != -1) {
                    url = seite.substring(pos1, pos2);
                }
                if (url.equals("")) continue;
                if ((pos1 = seite.indexOf(">", pos1)) != -1 && (pos2 = seite.indexOf("<", ++pos1)) != -1) {
                    thema = seite.substring(pos1, pos2);
                }
                String[] add = new String[]{"http://www.3sat.de/mediathek/?red=" + url + "&type=1", thema};
                this.listeThemen.addUrl(add);
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(915237874, ex);
            }
        }
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private MSStringBuilder seite1;
        private final MSStringBuilder seite2;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(Mediathek3Sat.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
        }

        @Override
        public synchronized void run() {
            try {
                String[] link;
                Mediathek3Sat.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = Mediathek3Sat.this.listeThemen.getListeThemen()) != null) {
                    Mediathek3Sat.this.meldungProgress(link[0]);
                    this.laden(link[0], link[1], true);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(987452384, ex);
            }
            Mediathek3Sat.this.meldungThreadUndFertig();
        }

        void laden(String urlThema, String thema, boolean weiter) {
            String MUSTER_START = "<div class=\"BoxPicture MediathekListPic\">";
            for (int i = 0; i < (MSConfig.loadLongMax() ? 40 : 5); ++i) {
                String url;
                if (thema.isEmpty()) {
                    url = urlThema;
                    i = 9999;
                } else {
                    weiter = false;
                    url = urlThema + "&mode=verpasst" + i;
                }
                Mediathek3Sat.this.meldung(url);
                this.seite1 = Mediathek3Sat.this.getUrlIo.getUri_Utf(Mediathek3Sat.SENDERNAME, url, this.seite1, "");
                if (this.seite1.indexOf("<div class=\"BoxPicture MediathekListPic\">") == -1) break;
                int pos1 = 0;
                while ((pos1 = this.seite1.indexOf("<div class=\"BoxPicture MediathekListPic\">", pos1)) != -1) {
                    DatenFilm film;
                    boolean ok = false;
                    String titel = this.seite1.extract("<a class=\"MediathekLink\"  title='Video abspielen:", "'", pos1 += "<div class=\"BoxPicture MediathekListPic\">".length()).trim();
                    String urlId = this.seite1.extract("href=\"http://www.3sat.de/mediathek/?mode=play&amp;obj=", "\"", pos1);
                    if (urlId.isEmpty()) {
                        urlId = this.seite1.extract("href=\"?obj=", "\"", pos1);
                    }
                    String urlFilm = "http://www.3sat.de/mediathek/?mode=play&obj=" + urlId;
                    if (!urlId.isEmpty() && (film = MediathekZdf.filmHolenId(this.getUrl, this.seite2, Mediathek3Sat.SENDERNAME, thema, titel, urlFilm, urlId = "http://www.3sat.de/mediathek/xmlservice/web/beitragsDetails?ak=web&id=" + urlId)) != null) {
                        MediathekZdf.urlTauschen(film, url, Mediathek3Sat.this.mSearchFilmeSuchen);
                        Mediathek3Sat.this.addFilm(film);
                        ok = true;
                    }
                    if (ok) continue;
                    MSLog.fehlerMeldung(462313269, "Thema: " + url);
                }
            }
            if (weiter && this.seite1.indexOf("mode=verpasst1") != -1) {
                this.laden(urlThema + "&mode=verpasst1", thema, false);
            }
        }
    }
}

