/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.ApplicationServer;
import org.rssowl.ui.internal.ApplicationWorkbenchAdvisor;
import org.rssowl.ui.internal.ApplicationWorkbenchWindowAdvisor;
import org.rssowl.ui.internal.Messages;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.NewBookMarkAction;
import org.rssowl.ui.internal.dialogs.fatal.FatalErrorWizard;
import org.rssowl.ui.internal.util.JobRunner;

public class Application
implements IApplication {
    private ApplicationWorkbenchAdvisor fWorkbenchAdvisor;
    public static final boolean IS_WINDOWS = "win32".equals(SWT.getPlatform());
    public static final boolean IS_LINUX = "gtk".equals(SWT.getPlatform());
    public static final boolean IS_MAC = "carbon".equals(SWT.getPlatform());
    public static final boolean IS_ECLIPSE = false;
    private static final String OPEN_RESTORE_WIZARD_PROPERTY = "restoreOwlProfile";

    public Object start(IApplicationContext context) throws Exception {
        ApplicationServer server = ApplicationServer.getDefault();
        server.setHandshakeHandler(new ApplicationServer.HandshakeHandler(){

            public void handle(String token) {
                if (StringUtils.isSet((String)token)) {
                    Application.this.restoreApplication();
                    if (Application.this.hasProtocolHandler(token)) {
                        Application.this.handleLinkSupplied(token);
                    }
                }
            }
        });
        Display display = PlatformUI.createDisplay();
        try {
            Runnable runAfterUIStartup = new Runnable(){

                public void run() {
                    String link = Application.this.parseLink(Platform.getCommandLineArgs());
                    if (StringUtils.isSet((String)link)) {
                        Application.this.handleLinkSupplied(link);
                    }
                }
            };
            Activator activator = Activator.getDefault();
            IStatus startupStatus = activator.getStartupStatus();
            if (startupStatus.getSeverity() == 4) {
                Integer n = this.handleStartupError(startupStatus, false);
                return n;
            }
            if (System.getProperty(OPEN_RESTORE_WIZARD_PROPERTY) != null) {
                Integer n = this.handleStartupError(startupStatus, true);
                return n;
            }
            this.fWorkbenchAdvisor = new ApplicationWorkbenchAdvisor(runAfterUIStartup);
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)this.fWorkbenchAdvisor);
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    private int handleStartupError(IStatus errorStatus, boolean forceAllowRestore) {
        FatalErrorWizard wizard = new FatalErrorWizard(errorStatus, forceAllowRestore);
        OwlUI.openWizard(null, wizard, true, false, null, true, IS_WINDOWS && !forceAllowRestore ? Messages.Application_RESTART_RSSOWL : Messages.Application_QUIT_RSSOWL);
        return wizard.getReturnCode();
    }

    private boolean hasProtocolHandler(String link) {
        if (!StringUtils.isSet((String)link)) {
            return false;
        }
        try {
            return Owl.getConnectionService().getHandler(new URI(URIUtils.fastEncode((String)link))) != null;
        }
        catch (ConnectionException connectionException) {
            return false;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    private String parseLink(String[] commandLineArgs) {
        String[] stringArray = commandLineArgs;
        int n = commandLineArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (this.hasProtocolHandler(arg)) {
                return arg;
            }
            ++n2;
        }
        return null;
    }

    private void restoreApplication() {
        final Shell shell = OwlUI.getPrimaryShell();
        if (shell != null) {
            JobRunner.runInUIThread((Widget)shell, new Runnable(){

                public void run() {
                    ApplicationWorkbenchWindowAdvisor advisor = Application.this.fWorkbenchAdvisor.getPrimaryWorkbenchWindowAdvisor();
                    if (advisor != null && advisor.isMinimizedToTray()) {
                        advisor.restoreFromTray(shell);
                    } else {
                        shell.forceActive();
                        shell.setMinimized(false);
                    }
                }
            });
        }
    }

    private void handleLinkSupplied(String link) {
        final Shell shell = OwlUI.getPrimaryShell();
        if (shell == null) {
            return;
        }
        final String normalizedLink = link.startsWith("feed:https://") ? "https://" + link.substring("feed:https://".length()) : link;
        final IBookMark existingBookMark = this.getBookMark(normalizedLink);
        JobRunner.runInUIThread((Widget)shell, new Runnable(){

            public void run() {
                if (existingBookMark == null) {
                    new NewBookMarkAction(shell, null, null, normalizedLink).run(null);
                } else {
                    IWorkbenchPage page = OwlUI.getPage();
                    if (page != null) {
                        OwlUI.openInFeedView(page, (IStructuredSelection)new StructuredSelection((Object)existingBookMark));
                    }
                }
            }
        });
    }

    private IBookMark getBookMark(String link) {
        URI linkAsURI;
        try {
            linkAsURI = new URI(URIUtils.fastEncode((String)link));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        Collection existingBookmarks = ((IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class)).loadAll(new FeedLinkReference(linkAsURI));
        if (existingBookmarks.size() > 0) {
            return (IBookMark)existingBookmarks.iterator().next();
        }
        if (link.startsWith("feed://") || link.startsWith("http://")) {
            if (link.startsWith("feed://")) {
                link = "http://" + link.substring("feed://".length());
            } else if (link.startsWith("http://")) {
                link = "feed://" + link.substring("http://".length());
            }
            try {
                linkAsURI = new URI(URIUtils.fastEncode((String)link));
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            existingBookmarks = ((IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class)).loadAll(new FeedLinkReference(linkAsURI));
            if (existingBookmarks.size() > 0) {
                return (IBookMark)existingBookmarks.iterator().next();
            }
        }
        return null;
    }

    public static boolean isWindows7() {
        return "6.1".equals(System.getProperty("os.version"));
    }
}

