/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.dialogs.properties.EntityPropertyDialog;
import org.rssowl.ui.internal.dialogs.properties.EntityPropertyPageWrapper;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityPropertyDialogAction
extends Action
implements IObjectActionDelegate {
    private IShellProvider fShellProvider;
    private ISelectionProvider fSelectionProvider;
    private IStructuredSelection fSelection;

    public EntityPropertyDialogAction() {
    }

    public EntityPropertyDialogAction(IShellProvider shellProvider, ISelectionProvider selectionProvider) {
        this.fShellProvider = shellProvider;
        this.fSelectionProvider = selectionProvider;
    }

    public void run() {
        IStructuredSelection selection = this.fSelection != null ? this.fSelection : (IStructuredSelection)this.fSelectionProvider.getSelection();
        if (!selection.isEmpty()) {
            List<IEntity> selectedEntities = ModelUtils.getEntities(selection);
            Set<EntityPropertyPageWrapper> pages = Controller.getDefault().getEntityPropertyPagesFor(selectedEntities);
            if (!pages.isEmpty()) {
                IEntity entity;
                EntityPropertyDialog dialog = new EntityPropertyDialog(this.fShellProvider.getShell(), selectedEntities);
                dialog.setTitle(this.getTitle(selectedEntities));
                for (EntityPropertyPageWrapper page : pages) {
                    page.createPage();
                    dialog.addPage(page);
                }
                if (dialog.open() == 0 && dialog.entitiesUpdated() && selectedEntities.size() == 1 && (entity = selectedEntities.get(0)) instanceof IFolderChild && ((IFolderChild)entity).getParent() != null) {
                    IFolder parent = ((IFolderChild)entity).getParent();
                    BookMarkExplorer explorer = OwlUI.getOpenedBookMarkExplorer();
                    if (explorer != null && explorer.isSortByNameEnabled()) {
                        ((StructuredViewer)explorer.getViewSite().getSelectionProvider()).refresh((Object)parent);
                    }
                }
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fShellProvider = targetPart.getSite();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    private String getTitle(List<IEntity> entities) {
        if (entities.size() == 1) {
            IEntity entity = entities.get(0);
            if (entity instanceof IFolder) {
                return NLS.bind((String)Messages.EntityPropertyDialogAction_PROPERTIES_FOR_N, (Object)((IFolder)entity).getName());
            }
            if (entity instanceof IMark) {
                return NLS.bind((String)Messages.EntityPropertyDialogAction_PROPERTIES_FOR_N, (Object)((IMark)entity).getName());
            }
        } else if (entities.size() > 1) {
            int folderCount = 0;
            int bookMarkCount = 0;
            int searchMarkCount = 0;
            int newsBinCount = 0;
            for (IEntity entity : entities) {
                if (entity instanceof IFolder) {
                    ++folderCount;
                    continue;
                }
                if (entity instanceof IBookMark) {
                    ++bookMarkCount;
                    continue;
                }
                if (entity instanceof INewsBin) {
                    ++newsBinCount;
                    continue;
                }
                if (!(entity instanceof ISearchMark)) continue;
                ++searchMarkCount;
            }
            StringBuilder buf = new StringBuilder();
            if (folderCount > 0) {
                buf.append(folderCount == 1 ? NLS.bind((String)Messages.EntityPropertyDialogAction_N_FOLDER, (Object)folderCount) : NLS.bind((String)Messages.EntityPropertyDialogAction_N_FOLDERS, (Object)folderCount)).append(", ");
            }
            if (bookMarkCount > 0) {
                buf.append(bookMarkCount == 1 ? NLS.bind((String)Messages.EntityPropertyDialogAction_N_BOOKMARK, (Object)bookMarkCount) : NLS.bind((String)Messages.EntityPropertyDialogAction_N_BOOKMARKS, (Object)bookMarkCount)).append(", ");
            }
            if (searchMarkCount > 0) {
                buf.append(searchMarkCount == 1 ? NLS.bind((String)Messages.EntityPropertyDialogAction_N_SEARCH, (Object)searchMarkCount) : NLS.bind((String)Messages.EntityPropertyDialogAction_N_SEARCHES, (Object)searchMarkCount)).append(", ");
            }
            if (newsBinCount > 0) {
                buf.append(newsBinCount == 1 ? NLS.bind((String)Messages.EntityPropertyDialogAction_N_BIN, (Object)newsBinCount) : NLS.bind((String)Messages.EntityPropertyDialogAction_N_BINS, (Object)newsBinCount)).append(", ");
            }
            if (buf.length() > 0) {
                buf.delete(buf.length() - 2, buf.length());
            }
            return buf.toString();
        }
        return null;
    }
}

