/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.ITreeNode;
import org.rssowl.core.util.ModelTreeNode;
import org.rssowl.core.util.TreeTraversal;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.editors.feed.PerformAfterInputSet;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

public class NavigationActionFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    private String fId;

    public Object create() {
        if (NavigationActionType.NEXT_NEWS.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.NEXT_NEWS);
        }
        if (NavigationActionType.NEXT_UNREAD_NEWS.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.NEXT_UNREAD_NEWS);
        }
        if (NavigationActionType.NEXT_FEED.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.NEXT_FEED);
        }
        if (NavigationActionType.NEXT_UNREAD_FEED.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.NEXT_UNREAD_FEED);
        }
        if (NavigationActionType.NEXT_FEED_NEXT_NEWS.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.NEXT_FEED_NEXT_NEWS);
        }
        if (NavigationActionType.NEXT_UNREAD_FEED_NEXT_UNREAD_NEWS.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.NEXT_UNREAD_FEED_NEXT_UNREAD_NEWS);
        }
        if (NavigationActionType.PREVIOUS_NEWS.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.PREVIOUS_NEWS);
        }
        if (NavigationActionType.PREVIOUS_UNREAD_NEWS.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.PREVIOUS_UNREAD_NEWS);
        }
        if (NavigationActionType.PREVIOUS_FEED.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.PREVIOUS_FEED);
        }
        if (NavigationActionType.PREVIOUS_UNREAD_FEED.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.PREVIOUS_UNREAD_FEED);
        }
        if (NavigationActionType.PREVIOUS_FEED_PREVIOUS_NEWS.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.PREVIOUS_FEED_PREVIOUS_NEWS);
        }
        if (NavigationActionType.PREVIOUS_UNREAD_FEED_PREVIOUS_UNREAD_NEWS.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.PREVIOUS_UNREAD_FEED_PREVIOUS_UNREAD_NEWS);
        }
        if (NavigationActionType.NEXT_TAB.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.NEXT_TAB);
        }
        if (NavigationActionType.PREVIOUS_TAB.getId().equals(this.fId)) {
            return new NavigationAction(NavigationActionType.PREVIOUS_TAB);
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (!(data instanceof String)) {
            throw new CoreException(Activator.getDefault().createErrorStatus("Data argument must be a String for " + this.getClass(), null));
        }
        this.fId = (String)data;
    }

    public static class NavigationAction
    implements IWorkbenchWindowActionDelegate {
        private final NavigationActionType fType;

        public NavigationAction(NavigationActionType type) {
            this.fType = type;
        }

        public void dispose() {
        }

        public void init(IWorkbenchWindow window) {
        }

        public void run(IAction action) {
            if (this.fType == NavigationActionType.NEXT_TAB || this.fType == NavigationActionType.PREVIOUS_TAB) {
                this.navigateInTabs();
            } else {
                if (this.fType.isNewsScoped() && this.navigateOnActiveFeedView()) {
                    return;
                }
                if (this.navigateOnOpenExplorer()) {
                    return;
                }
                if (this.navigateOnModel()) {
                    return;
                }
            }
        }

        private void navigateInTabs() {
            IEditorPart activeEditor = OwlUI.getActiveEditor();
            if (activeEditor == null) {
                return;
            }
            List<IEditorReference> editors = OwlUI.getEditorReferences();
            int index = -1;
            int i = 0;
            while (i < editors.size()) {
                try {
                    if (activeEditor.getEditorInput().equals(editors.get(i).getEditorInput())) {
                        index = i;
                        break;
                    }
                }
                catch (PartInitException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                ++i;
            }
            if (index < 0) {
                return;
            }
            IEditorPart tab = null;
            if (this.fType == NavigationActionType.NEXT_TAB) {
                tab = editors.get(index + 1 < editors.size() ? index + 1 : 0).getEditor(true);
            } else if (this.fType == NavigationActionType.PREVIOUS_TAB) {
                tab = editors.get(index - 1 >= 0 ? index - 1 : editors.size() - 1).getEditor(true);
            }
            if (tab != null) {
                IWorkbenchPage page = tab.getSite().getPage();
                page.activate(tab.getSite().getPart());
                page.activate((IWorkbenchPart)tab);
            }
        }

        private boolean navigateOnActiveFeedView() {
            FeedView activeFeedView = OwlUI.getActiveFeedView();
            if (activeFeedView != null) {
                boolean success = activeFeedView.navigate(true, false, this.fType.isNext(), this.fType.isUnread());
                if (!success && this.fType.isNewsScoped() && this.fType.isUnread() && this.fType.isNext()) {
                    success = activeFeedView.navigate(false, false, this.fType.isNext(), this.fType.isUnread());
                }
                if (success) {
                    IWorkbenchPage page = activeFeedView.getSite().getPage();
                    page.activate(activeFeedView.getSite().getPart());
                    page.activate((IWorkbenchPart)activeFeedView);
                    return true;
                }
            }
            return false;
        }

        private boolean navigateOnOpenExplorer() {
            BookMarkExplorer bookmarkExplorer = OwlUI.getOpenedBookMarkExplorer();
            if (bookmarkExplorer == null) {
                return false;
            }
            bookmarkExplorer.navigate(this.fType.isNext(), this.fType.isUnread(), this.fType.performOnFeedView());
            return true;
        }

        private boolean navigateOnModel() {
            INewsMark iNewsMark;
            IEditorInput input;
            ArrayList<INewsMark> startingNodes = new ArrayList<INewsMark>();
            FeedView activeFeedView = OwlUI.getActiveFeedView();
            if (activeFeedView != null && (input = activeFeedView.getEditorInput()) != null && input instanceof FeedViewInput && (iNewsMark = ((FeedViewInput)input).getMark()) != null) {
                startingNodes.add((INewsMark)(iNewsMark instanceof FolderNewsMark ? ((FolderNewsMark)iNewsMark).getFolder() : iNewsMark));
            }
            startingNodes.addAll(CoreUtils.loadRootFolders());
            ITreeNode targetNode = null;
            for (IFolderChild iFolderChild : startingNodes) {
                TreeTraversal traversal = new TreeTraversal((ITreeNode)(iFolderChild instanceof IFolder ? new ModelTreeNode((IFolder)iFolderChild) : new ModelTreeNode((IMark)iFolderChild))){

                    public boolean select(ITreeNode node) {
                        Object data = node.getData();
                        if (data instanceof INewsMark) {
                            INewsMark newsmark = (INewsMark)data;
                            if (NavigationAction.this.fType.isUnread() && newsmark.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED)) == 0) {
                                return false;
                            }
                        } else if (data instanceof IFolder) {
                            return false;
                        }
                        return true;
                    }
                };
                ITreeNode iTreeNode = targetNode = this.fType.isNext() ? traversal.nextNode() : traversal.previousNode();
                if (targetNode != null) break;
            }
            if (targetNode != null) {
                INewsMark iNewsMark2 = (INewsMark)targetNode.getData();
                PerformAfterInputSet perform = null;
                if (this.fType.isNewsScoped() && this.fType.isUnread()) {
                    perform = PerformAfterInputSet.SELECT_UNREAD_NEWS;
                } else if (this.fType.isNewsScoped()) {
                    perform = PerformAfterInputSet.SELECT_FIRST_NEWS;
                }
                IWorkbenchPage page = OwlUI.getPage();
                if (page != null) {
                    OwlUI.openInFeedView(page, (IStructuredSelection)new StructuredSelection((Object)iNewsMark2), true, false, perform);
                }
            }
            return targetNode != null;
        }

        public void selectionChanged(IAction action, ISelection selection) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NavigationActionType {
        NEXT_NEWS("nextNews", "org.rssowl.ui.NextNews", Messages.NavigationActionFactory_NEXT_NEWS, true, true, false),
        NEXT_UNREAD_NEWS("nextUnreadNews", "org.rssowl.ui.NextUnreadNews", Messages.NavigationActionFactory_NEXT_UNREAD_NEWS, true, true, true),
        NEXT_FEED("nextFeed", "org.rssowl.ui.NextFeed", Messages.NavigationActionFactory_NEXT_FEED, false, true, false),
        NEXT_UNREAD_FEED("nextUnreadFeed", "org.rssowl.ui.NextUnreadFeed", Messages.NavigationActionFactory_NEXT_UNREAD_FEED, false, true, true),
        PREVIOUS_NEWS("previousNews", "org.rssowl.ui.PreviousNews", Messages.NavigationActionFactory_PREVIOUS_NEWS, true, false, false),
        PREVIOUS_UNREAD_NEWS("previousUnreadNews", "org.rssowl.ui.PreviousUnreadNews", Messages.NavigationActionFactory_PREVIOUS_UNREAD_NEWS, true, false, true),
        PREVIOUS_FEED("previousFeed", "org.rssowl.ui.PreviousFeed", Messages.NavigationActionFactory_PREVIOUS_FEED, false, false, false),
        PREVIOUS_UNREAD_FEED("previousUnreadFeed", "org.rssowl.ui.PreviousUnreadFeed", Messages.NavigationActionFactory_PREVIOUS_UNREAD_FEED, false, false, true),
        NEXT_TAB("nextTab", "org.rssowl.ui.NextTab", Messages.NavigationActionFactory_NEXT_TAB, false, false, false),
        PREVIOUS_TAB("previousTab", "org.rssowl.ui.PreviousTab", Messages.NavigationActionFactory_PREVIOUS_TAB, false, false, false),
        NEXT_FEED_NEXT_NEWS("nextFeedNextNews", null, null, false, true, false, true),
        NEXT_UNREAD_FEED_NEXT_UNREAD_NEWS("nextUnreadFeedNextUnreadNews", null, null, false, true, true, true),
        PREVIOUS_FEED_PREVIOUS_NEWS("previousFeedPreviousNews", null, null, false, false, false, true),
        PREVIOUS_UNREAD_FEED_PREVIOUS_UNREAD_NEWS("previousUnreadFeedPreviousUnreadNews", null, null, false, false, true, true);

        String fId;
        String fCommandId;
        private String fName;
        boolean fIsNewsScoped;
        boolean fIsNext;
        boolean fIsUnread;
        boolean fPerformOnFeedView;

        private NavigationActionType(String id, String commandId, String name, boolean isNewsScoped, boolean isNext, boolean isUnread) {
            this(id, commandId, name, isNewsScoped, isNext, isUnread, isNewsScoped);
        }

        private NavigationActionType(String id, String commandId, String name, boolean isNewsScoped, boolean isNext, boolean isUnread, boolean performOnFeedView) {
            this.fId = id;
            this.fCommandId = commandId;
            this.fName = name;
            this.fIsNewsScoped = isNewsScoped;
            this.fIsNext = isNext;
            this.fIsUnread = isUnread;
            this.fPerformOnFeedView = performOnFeedView;
        }

        public String getId() {
            return this.fId;
        }

        public String getCommandId() {
            return this.fCommandId;
        }

        public String getName() {
            return this.fName;
        }

        boolean isNewsScoped() {
            return this.fIsNewsScoped;
        }

        boolean isUnread() {
            return this.fIsUnread;
        }

        boolean isNext() {
            return this.fIsNext;
        }

        public boolean performOnFeedView() {
            return this.fPerformOnFeedView;
        }
    }
}

