/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.preferences.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class MiscPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.rssowl.ui.MiscPreferences";
    private IPreferenceScope fGlobalScope;
    private IPreferenceScope fEclipseScope;
    private Button fMinimizeToTray;
    private Button fMoveToTrayOnStart;
    private Button fMoveToTrayOnExit;
    private Spinner fAutoCloseTabsSpinner;
    private Button fAutoCloseTabsCheck;
    private Button fUseMultipleTabsCheck;
    private Button fReopenFeedsOnStartupCheck;
    private Button fAlwaysReuseFeedView;
    private Button fOpenOnSingleClick;
    private Button fUpdateOnStartup;
    private Button fSingleClickRestore;
    private Button fDoubleClickRestore;

    public MiscPreferencePage() {
        this.fGlobalScope = Owl.getPreferenceService().getGlobalScope();
        this.fEclipseScope = Owl.getPreferenceService().getEclipseScope();
        this.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/view.gif"));
    }

    public MiscPreferencePage(String title) {
        super(title);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateApplyEnablement(false);
    }

    protected Control createContents(Composite parent) {
        Composite container = this.createComposite(parent);
        this.createTabOptions(container);
        this.createTrayOptions(container);
        this.createMiscOptions(container);
        this.applyDialogFont(container);
        OwlUI.runOnSelection(new Runnable(){

            public void run() {
                MiscPreferencePage.this.updateApplyEnablement(true);
            }
        }, new Control[]{container});
        return container;
    }

    private void createTabOptions(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.MiscPreferencePage_TABBED_BROWSING);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Composite group = new Composite(container, 0);
        group.setLayout((Layout)LayoutUtils.createGridLayout(1, 7, 3));
        ((GridLayout)group.getLayout()).marginBottom = 5;
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fAlwaysReuseFeedView = new Button(group, 32);
        this.fAlwaysReuseFeedView.setText(Messages.MiscPreferencePage_SAME_TAB);
        this.fAlwaysReuseFeedView.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.ALWAYS_REUSE_FEEDVIEW));
        this.fUseMultipleTabsCheck = new Button(group, 32);
        this.fUseMultipleTabsCheck.setText(Messages.MiscPreferencePage_MULTIPLE_TABS);
        this.fUseMultipleTabsCheck.setSelection(this.fEclipseScope.getBoolean(DefaultPreferences.ECLIPSE_MULTIPLE_TABS));
        Composite autoCloseTabsContainer = new Composite(group, 0);
        autoCloseTabsContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0, 0, 2, false));
        this.fAutoCloseTabsCheck = new Button(autoCloseTabsContainer, 32);
        this.fAutoCloseTabsCheck.setText(Messages.MiscPreferencePage_TAB_LIMIT);
        this.fAutoCloseTabsCheck.setSelection(this.fEclipseScope.getBoolean(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS));
        this.fAutoCloseTabsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MiscPreferencePage.this.fAutoCloseTabsSpinner.setEnabled(MiscPreferencePage.this.fAutoCloseTabsCheck.getSelection());
                MiscPreferencePage.this.fAlwaysReuseFeedView.setEnabled(!MiscPreferencePage.this.fAutoCloseTabsCheck.getSelection() || MiscPreferencePage.this.fAutoCloseTabsSpinner.getSelection() > 1);
            }
        });
        this.fAutoCloseTabsSpinner = new Spinner(autoCloseTabsContainer, 2048);
        this.fAutoCloseTabsSpinner.setMinimum(1);
        this.fAutoCloseTabsSpinner.setMaximum(100);
        this.fAutoCloseTabsSpinner.setSelection(this.fEclipseScope.getInteger(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS_THRESHOLD));
        this.fAutoCloseTabsSpinner.setEnabled(this.fAutoCloseTabsCheck.getSelection());
        this.fAutoCloseTabsSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MiscPreferencePage.this.fAlwaysReuseFeedView.setEnabled(!MiscPreferencePage.this.fAutoCloseTabsCheck.getSelection() || MiscPreferencePage.this.fAutoCloseTabsSpinner.getSelection() > 1);
            }
        });
        label = new Label(autoCloseTabsContainer, 0);
        label.setText(Messages.MiscPreferencePage_TABS);
        this.fAlwaysReuseFeedView.setEnabled(!this.fAutoCloseTabsCheck.getSelection() || this.fAutoCloseTabsSpinner.getSelection() > 1);
    }

    private void createMiscOptions(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.MiscPreferencePage_MISC);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Composite miscGroup = new Composite(container, 0);
        miscGroup.setLayout((Layout)LayoutUtils.createGridLayout(1, 7, 3));
        miscGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fReopenFeedsOnStartupCheck = new Button(miscGroup, 32);
        this.fReopenFeedsOnStartupCheck.setText(Messages.MiscPreferencePage_REOPEN_LAST_OPENED);
        this.fReopenFeedsOnStartupCheck.setSelection(this.fEclipseScope.getBoolean(DefaultPreferences.ECLIPSE_RESTORE_TABS));
        this.fOpenOnSingleClick = new Button(miscGroup, 32);
        this.fOpenOnSingleClick.setText(Messages.MiscPreferencePage_SINGLE_CLICK);
        this.fOpenOnSingleClick.setSelection(this.fEclipseScope.getBoolean(DefaultPreferences.ECLIPSE_SINGLE_CLICK_OPEN));
        this.fUpdateOnStartup = new Button(miscGroup, 32);
        this.fUpdateOnStartup.setText(Messages.MiscPreferencePage_UPDATE_ON_STARTUP);
        this.fUpdateOnStartup.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.UPDATE_ON_STARTUP));
    }

    private void createTrayOptions(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.MiscPreferencePage_SYSTEM_TRAY);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Composite group = new Composite(container, 0);
        group.setLayout((Layout)LayoutUtils.createGridLayout(1, 7, 3));
        ((GridLayout)group.getLayout()).marginBottom = 5;
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(group, 0);
        label.setText(Messages.MiscPreferencePage_MOVE_TO_TRAY);
        this.fMinimizeToTray = new Button(group, 32);
        this.fMinimizeToTray.setText(Messages.MiscPreferencePage_ON_MINIMIZE);
        this.fMinimizeToTray.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.TRAY_ON_MINIMIZE));
        this.fMinimizeToTray.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MiscPreferencePage.this.updateRestoreEnablement();
            }
        });
        this.fMoveToTrayOnStart = new Button(group, 32);
        this.fMoveToTrayOnStart.setText(Messages.MiscPreferencePage_ON_START);
        this.fMoveToTrayOnStart.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.TRAY_ON_START));
        this.fMoveToTrayOnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MiscPreferencePage.this.updateRestoreEnablement();
            }
        });
        this.fMoveToTrayOnExit = new Button(group, 32);
        this.fMoveToTrayOnExit.setText(Messages.MiscPreferencePage_ON_CLOSE);
        this.fMoveToTrayOnExit.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.TRAY_ON_CLOSE));
        this.fMoveToTrayOnExit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MiscPreferencePage.this.updateRestoreEnablement();
            }
        });
        label = new Label(group, 0);
        label.setText(Messages.MiscPreferencePage_RESTORE_FROM_TRAY);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)label.getLayoutData()).verticalIndent = 5;
        Composite buttonContainer = new Composite(group, 0);
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        this.fSingleClickRestore = new Button(buttonContainer, 16);
        this.fSingleClickRestore.setText(Messages.MiscPreferencePage_SINGLE_CLICK_RESTORE);
        this.fSingleClickRestore.setSelection(!this.fGlobalScope.getBoolean(DefaultPreferences.RESTORE_TRAY_DOUBLECLICK));
        this.fDoubleClickRestore = new Button(buttonContainer, 16);
        this.fDoubleClickRestore.setText(Messages.MiscPreferencePage_DOUBLE_CLICK_RESTORE);
        this.fDoubleClickRestore.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.RESTORE_TRAY_DOUBLECLICK));
        this.updateRestoreEnablement();
    }

    private void updateRestoreEnablement() {
        boolean enable = this.fMinimizeToTray.getSelection() || this.fMoveToTrayOnStart.getSelection() || this.fMoveToTrayOnExit.getSelection();
        this.fSingleClickRestore.setEnabled(enable);
        this.fDoubleClickRestore.setEnabled(enable);
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        return composite;
    }

    public boolean performOk() {
        this.fGlobalScope.putBoolean(DefaultPreferences.UPDATE_ON_STARTUP, this.fUpdateOnStartup.getSelection());
        this.fEclipseScope.putBoolean(DefaultPreferences.ECLIPSE_SINGLE_CLICK_OPEN, this.fOpenOnSingleClick.getSelection());
        OpenStrategy.setOpenMethod((int)(this.fOpenOnSingleClick.getSelection() ? 5 : 0));
        this.fEclipseScope.putBoolean(DefaultPreferences.ECLIPSE_RESTORE_TABS, this.fReopenFeedsOnStartupCheck.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.ALWAYS_REUSE_FEEDVIEW, this.fAlwaysReuseFeedView.getSelection());
        this.fEclipseScope.putBoolean(DefaultPreferences.ECLIPSE_MULTIPLE_TABS, this.fUseMultipleTabsCheck.getSelection());
        this.fEclipseScope.putBoolean(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS, this.fAutoCloseTabsCheck.getSelection());
        this.fEclipseScope.putInteger(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS_THRESHOLD, this.fAutoCloseTabsSpinner.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.TRAY_ON_MINIMIZE, this.fMinimizeToTray.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.TRAY_ON_START, this.fMoveToTrayOnStart.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.TRAY_ON_CLOSE, this.fMoveToTrayOnExit.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.RESTORE_TRAY_DOUBLECLICK, this.fDoubleClickRestore.getSelection());
        return super.performOk();
    }

    protected void performApply() {
        super.performApply();
        this.updateApplyEnablement(false);
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        this.fUpdateOnStartup.setSelection(defaultScope.getBoolean(DefaultPreferences.UPDATE_ON_STARTUP));
        this.fOpenOnSingleClick.setSelection(defaultScope.getBoolean(DefaultPreferences.ECLIPSE_SINGLE_CLICK_OPEN));
        OpenStrategy.setOpenMethod((int)(this.fOpenOnSingleClick.getSelection() ? 5 : 0));
        this.fReopenFeedsOnStartupCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.ECLIPSE_RESTORE_TABS));
        this.fAlwaysReuseFeedView.setSelection(true);
        this.fUseMultipleTabsCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.ECLIPSE_MULTIPLE_TABS));
        this.fAutoCloseTabsCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS));
        this.fAutoCloseTabsSpinner.setSelection(defaultScope.getInteger(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS_THRESHOLD));
        this.fAutoCloseTabsSpinner.setEnabled(this.fAutoCloseTabsCheck.getSelection());
        this.fMinimizeToTray.setSelection(defaultScope.getBoolean(DefaultPreferences.TRAY_ON_MINIMIZE));
        this.fMoveToTrayOnStart.setSelection(defaultScope.getBoolean(DefaultPreferences.TRAY_ON_START));
        this.fMoveToTrayOnExit.setSelection(defaultScope.getBoolean(DefaultPreferences.TRAY_ON_CLOSE));
        this.fSingleClickRestore.setSelection(!defaultScope.getBoolean(DefaultPreferences.RESTORE_TRAY_DOUBLECLICK));
        this.fDoubleClickRestore.setSelection(defaultScope.getBoolean(DefaultPreferences.RESTORE_TRAY_DOUBLECLICK));
        this.updateRestoreEnablement();
        this.fAlwaysReuseFeedView.setEnabled(!this.fAutoCloseTabsCheck.getSelection() || this.fAutoCloseTabsSpinner.getSelection() > 1);
        this.updateApplyEnablement(true);
    }

    private void updateApplyEnablement(boolean enable) {
        Button applyButton = this.getApplyButton();
        if (applyButton != null && !applyButton.isDisposed() && applyButton.isEnabled() != enable) {
            applyButton.setEnabled(enable);
        }
    }
}

