/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.ShareProvider;
import org.rssowl.ui.internal.dialogs.preferences.Messages;
import org.rssowl.ui.internal.util.CColumnLayoutData;
import org.rssowl.ui.internal.util.CTable;
import org.rssowl.ui.internal.util.LayoutUtils;

public class SharingPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.rssowl.ui.SharingPreferencesPage";
    private LocalResourceManager fResources;
    private IPreferenceScope fPreferences;
    private Button fMoveDownButton;
    private Button fMoveUpButton;
    private CheckboxTableViewer fViewer;
    private int[] fInitialShareProviderState;

    public SharingPreferencesPage() {
        this.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/share.gif"));
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.fPreferences = Owl.getPreferenceService().getGlobalScope();
    }

    public void init(IWorkbench workbench) {
        this.fInitialShareProviderState = this.fPreferences.getIntegers(DefaultPreferences.SHARE_PROVIDER_STATE);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateApplyEnablement(false);
    }

    protected Control createContents(Composite parent) {
        TableItem[] items;
        Composite container = this.createContainer(parent);
        Label infoText = new Label(container, 64);
        infoText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        ((GridData)infoText.getLayoutData()).widthHint = 200;
        infoText.setText(Messages.SharingPreferencesPage_SELECT_COMMUNITY);
        Composite tableContainer = new Composite(container, 0);
        tableContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        CTable cTable = new CTable(tableContainer, 67618);
        this.fViewer = new CheckboxTableViewer(cTable.getControl());
        this.fViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.getTable().setHeaderVisible(true);
        ((GridData)this.fViewer.getTable().getLayoutData()).heightHint = this.fViewer.getTable().getItemHeight() * 15;
        this.fViewer.getTable().setFocus();
        this.fViewer.getTable().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        TableColumn nameCol = new TableColumn(this.fViewer.getTable(), 0);
        CColumnLayoutData data = new CColumnLayoutData(CColumnLayoutData.Size.FILL, 100);
        cTable.manageColumn(nameCol, data, Messages.SharingPreferencesPage_AVAILABLE_COMMUNITIES, null, null, false, false);
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return Controller.getDefault().getShareProviders().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ShareProvider provider = (ShareProvider)cell.getElement();
                cell.setText(provider.getName());
                if (StringUtils.isSet((String)provider.getIconPath())) {
                    cell.setImage(SharingPreferencesPage.this.fResources.createImage(OwlUI.getImageDescriptor(provider.getPluginId(), provider.getIconPath())));
                }
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SharingPreferencesPage.this.updateMoveEnablement();
            }
        });
        this.fViewer.addDragSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(final DragSourceEvent event) {
                SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        IStructuredSelection selection = (IStructuredSelection)SharingPreferencesPage.this.fViewer.getSelection();
                        boolean bl = event.doit = selection.size() < SharingPreferencesPage.this.fViewer.getTable().getItemCount();
                        if (event.doit) {
                            LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                            LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                        }
                    }
                });
            }

            public void dragSetData(final DragSourceEvent event) {
                SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                            event.data = LocalSelectionTransfer.getTransfer().getSelection();
                        }
                    }
                });
            }

            public void dragFinished(DragSourceEvent event) {
                SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        LocalSelectionTransfer.getTransfer().setSelection(null);
                        LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
                    }
                });
            }
        });
        ViewerDropAdapter dropSupport = new ViewerDropAdapter((Viewer)this.fViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }

            public boolean performDrop(Object data) {
                ShareProvider target = (ShareProvider)this.getCurrentTarget();
                if (target != null) {
                    SharingPreferencesPage.this.onMove((StructuredSelection)data, target, this.getCurrentLocation());
                    return true;
                }
                return false;
            }
        };
        dropSupport.setFeedbackEnabled(true);
        dropSupport.setScrollEnabled(true);
        dropSupport.setSelectionFeedbackEnabled(true);
        this.fViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)dropSupport);
        this.fViewer.setInput((Object)this);
        this.updateCheckedState();
        TableItem[] tableItemArray = items = this.fViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                this.fViewer.getTable().showItem(item);
                break;
            }
            ++n2;
        }
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ShareProvider provider = (ShareProvider)event.getElement();
                provider.setEnabled(event.getChecked());
                SharingPreferencesPage.this.save();
                SharingPreferencesPage.this.fViewer.update((Object)provider, null);
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        buttonContainer.setLayoutData((Object)new GridData(1, 4, false, false));
        this.fMoveUpButton = new Button(buttonContainer, 8);
        this.fMoveUpButton.setText(Messages.SharingPreferencesPage_MOVE_UP);
        this.fMoveUpButton.setEnabled(false);
        Dialog.applyDialogFont((Control)this.fMoveUpButton);
        this.setButtonLayoutData(this.fMoveUpButton);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SharingPreferencesPage.this.onMove(true);
            }
        });
        this.fMoveDownButton = new Button(buttonContainer, 8);
        this.fMoveDownButton.setText(Messages.SharingPreferencesPage_MOVE_DOWN);
        this.fMoveDownButton.setEnabled(false);
        Dialog.applyDialogFont((Control)this.fMoveDownButton);
        this.setButtonLayoutData(this.fMoveDownButton);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SharingPreferencesPage.this.onMove(false);
            }
        });
        Button selectAllButton = new Button(buttonContainer, 8);
        selectAllButton.setText(Messages.SharingPreferencesPage_SELECT_ALL);
        Dialog.applyDialogFont((Control)selectAllButton);
        this.setButtonLayoutData(selectAllButton);
        ((GridData)selectAllButton.getLayoutData()).verticalIndent = 10;
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SharingPreferencesPage.this.onSelectAll(false);
            }
        });
        Button deSelectAllButton = new Button(buttonContainer, 8);
        deSelectAllButton.setText(Messages.SharingPreferencesPage_DESELECT_ALL);
        Dialog.applyDialogFont((Control)deSelectAllButton);
        this.setButtonLayoutData(deSelectAllButton);
        deSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SharingPreferencesPage.this.onSelectAll(true);
            }
        });
        Composite infoContainer = new Composite(container, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        Label infoImg = new Label(infoContainer, 0);
        infoImg.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/info.gif"));
        infoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label infoTextLabel = new Label(infoContainer, 64);
        infoTextLabel.setText(Messages.SharingPreferencesPage_COMMUNITY_INFO);
        infoTextLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.applyDialogFont(container);
        OwlUI.runOnSelection(new Runnable(){

            public void run() {
                SharingPreferencesPage.this.updateApplyEnablement(true);
            }
        }, new Control[]{container});
        return container;
    }

    private Composite createContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        return composite;
    }

    private void onSelectAll(boolean deselect) {
        TableItem[] items = this.fViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem tableItem = items[i];
            ShareProvider provider = (ShareProvider)tableItem.getData();
            provider.setEnabled(!deselect);
            this.fViewer.setChecked((Object)provider, !deselect);
            ++i;
        }
        this.save();
        this.fViewer.refresh();
    }

    private void save() {
        TableItem[] items = this.fViewer.getTable().getItems();
        int[] newState = new int[items.length];
        int i = 0;
        while (i < items.length) {
            TableItem tableItem = items[i];
            ShareProvider provider = (ShareProvider)tableItem.getData();
            int index = provider.getIndex();
            ++index;
            if (!provider.isEnabled()) {
                index *= -1;
            }
            newState[i] = index;
            ++i;
        }
        this.fPreferences.putIntegers(DefaultPreferences.SHARE_PROVIDER_STATE, newState);
    }

    private void updateMoveEnablement() {
        boolean enableMoveUp = true;
        boolean enableMoveDown = true;
        int[] selectionIndices = this.fViewer.getTable().getSelectionIndices();
        if (selectionIndices.length == 1) {
            enableMoveUp = selectionIndices[0] != 0;
            enableMoveDown = selectionIndices[0] != this.fViewer.getTable().getItemCount() - 1;
        } else {
            enableMoveUp = false;
            enableMoveDown = false;
        }
        this.fMoveUpButton.setEnabled(enableMoveUp);
        this.fMoveDownButton.setEnabled(enableMoveDown);
    }

    private void onMove(boolean up) {
        TableItem[] items = this.fViewer.getTable().getItems();
        ArrayList<ShareProvider> sortedProviders = new ArrayList<ShareProvider>(items.length);
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            sortedProviders.add((ShareProvider)item.getData());
            ++n2;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        ShareProvider selectedProvider = (ShareProvider)selection.getFirstElement();
        int[] order = this.fPreferences.getIntegers(DefaultPreferences.SHARE_PROVIDER_STATE);
        int selectedIndex = sortedProviders.indexOf(selectedProvider);
        if (up && selectedIndex > 0) {
            int order2;
            int order1 = order[selectedIndex];
            order[selectedIndex] = order2 = order[selectedIndex - 1];
            order[selectedIndex - 1] = order1;
        } else if (!up && selectedIndex < sortedProviders.size() - 1) {
            int order2;
            int order1 = order[selectedIndex];
            order[selectedIndex] = order2 = order[selectedIndex + 1];
            order[selectedIndex + 1] = order1;
        }
        this.fPreferences.putIntegers(DefaultPreferences.SHARE_PROVIDER_STATE, order);
        this.fViewer.refresh();
        this.fViewer.getTable().showSelection();
        this.updateCheckedState();
        this.updateMoveEnablement();
    }

    private void onMove(StructuredSelection selection, ShareProvider destination, int location) {
        TableItem[] items;
        Object[] selectedElements;
        ArrayList<ShareProvider> movedItems = new ArrayList<ShareProvider>();
        Object[] objectArray = selectedElements = selection.toArray();
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            movedItems.add((ShareProvider)element);
            ++n2;
        }
        ArrayList<ShareProvider> visibleItems = new ArrayList<ShareProvider>();
        TableItem[] tableItemArray = items = this.fViewer.getTable().getItems();
        int n3 = items.length;
        int n4 = 0;
        while (n4 < n3) {
            TableItem item = tableItemArray[n4];
            visibleItems.add((ShareProvider)item.getData());
            ++n4;
        }
        if (movedItems.isEmpty() || visibleItems.isEmpty()) {
            return;
        }
        visibleItems.removeAll(movedItems);
        int destinationIndex = visibleItems.indexOf(destination);
        if (destinationIndex >= 0) {
            if (location == 3 || location == 2) {
                ++destinationIndex;
            }
            visibleItems.addAll(destinationIndex, movedItems);
            int[] newState = new int[items.length];
            int i = 0;
            while (i < visibleItems.size()) {
                ShareProvider provider = (ShareProvider)visibleItems.get(i);
                int index = provider.getIndex();
                ++index;
                if (!provider.isEnabled()) {
                    index *= -1;
                }
                newState[i] = index;
                ++i;
            }
            this.fPreferences.putIntegers(DefaultPreferences.SHARE_PROVIDER_STATE, newState);
            this.fViewer.refresh();
            this.fViewer.getTable().setSelection(destinationIndex, destinationIndex + movedItems.size() - 1);
            this.updateCheckedState();
            this.updateMoveEnablement();
        }
    }

    private void updateCheckedState() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.fViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ShareProvider provider = (ShareProvider)item.getData();
            this.fViewer.setChecked((Object)provider, provider.isEnabled());
            ++n2;
        }
    }

    public boolean performOk() {
        this.save();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        int[] defaultState = defaultScope.getIntegers(DefaultPreferences.SHARE_PROVIDER_STATE);
        Owl.getPreferenceService().getGlobalScope().putIntegers(DefaultPreferences.SHARE_PROVIDER_STATE, defaultState);
        this.fViewer.refresh();
        this.updateCheckedState();
        this.updateMoveEnablement();
        this.updateApplyEnablement(true);
    }

    protected void performApply() {
        super.performApply();
        this.fInitialShareProviderState = this.fPreferences.getIntegers(DefaultPreferences.SHARE_PROVIDER_STATE);
        this.updateApplyEnablement(false);
    }

    public boolean performCancel() {
        this.fPreferences.putIntegers(DefaultPreferences.SHARE_PROVIDER_STATE, this.fInitialShareProviderState);
        return super.performCancel();
    }

    public void dispose() {
        super.dispose();
        this.fResources.dispose();
    }

    private void updateApplyEnablement(boolean enable) {
        Button applyButton = this.getApplyButton();
        if (applyButton != null && !applyButton.isDisposed() && applyButton.isEnabled() != enable) {
            applyButton.setEnabled(enable);
        }
    }
}

