/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.dialogs.properties.IEntityPropertyPage;
import org.rssowl.ui.dialogs.properties.IPropertyDialogSite;
import org.rssowl.ui.internal.editors.feed.NewsColumn;
import org.rssowl.ui.internal.editors.feed.NewsColumnViewModel;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.NewsColumnSelectionControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsPropertyPage
implements IEntityPropertyPage {
    private List<IEntity> fEntities;
    private NewsColumnSelectionControl fColumnSelectionControl;
    private List<IPreferenceScope> fEntityPreferences;
    private int[] fPrefSelectedColumns;
    private int fPrefSortColumn;
    private boolean fPrefAscending;
    private boolean fSettingsChanged;

    @Override
    public void init(IPropertyDialogSite site, List<IEntity> entities) {
        Assert.isTrue((!entities.isEmpty() ? 1 : 0) != 0);
        this.fEntities = entities;
        this.fEntityPreferences = new ArrayList<IPreferenceScope>(this.fEntities.size());
        for (IEntity entity : entities) {
            this.fEntityPreferences.add(Owl.getPreferenceService().getEntityScope(entity));
        }
        this.loadInitialSettings();
    }

    private void loadInitialSettings() {
        IPreferenceScope firstScope = this.fEntityPreferences.get(0);
        this.fPrefSelectedColumns = firstScope.getIntegers(DefaultPreferences.BM_NEWS_COLUMNS);
        this.fPrefSortColumn = firstScope.getInteger(DefaultPreferences.BM_NEWS_SORT_COLUMN);
        this.fPrefAscending = firstScope.getBoolean(DefaultPreferences.BM_NEWS_SORT_ASCENDING);
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        int i = 1;
        while (i < this.fEntityPreferences.size()) {
            IPreferenceScope otherScope = this.fEntityPreferences.get(i);
            if (!Arrays.equals(otherScope.getIntegers(DefaultPreferences.BM_NEWS_COLUMNS), this.fPrefSelectedColumns)) {
                this.fPrefSelectedColumns = defaultScope.getIntegers(DefaultPreferences.BM_NEWS_COLUMNS);
            }
            if (otherScope.getInteger(DefaultPreferences.BM_NEWS_SORT_COLUMN) != this.fPrefSortColumn) {
                this.fPrefSortColumn = defaultScope.getInteger(DefaultPreferences.BM_NEWS_SORT_COLUMN);
            }
            if (otherScope.getBoolean(DefaultPreferences.BM_NEWS_SORT_ASCENDING) != this.fPrefAscending) {
                this.fPrefAscending = defaultScope.getBoolean(DefaultPreferences.BM_NEWS_SORT_ASCENDING);
            }
            ++i;
        }
    }

    @Override
    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10));
        this.fColumnSelectionControl = new NewsColumnSelectionControl(container, 0);
        this.fColumnSelectionControl.setLayoutData(new GridData(4, 1, true, false));
        this.fColumnSelectionControl.setInput(NewsColumnViewModel.createFrom(this.fPrefSelectedColumns, this.fPrefSortColumn, this.fPrefAscending));
        return container;
    }

    @Override
    public ImageDescriptor getImage() {
        return null;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public boolean performOk(Set<IEntity> entitiesToSave) {
        this.fSettingsChanged = false;
        for (IPreferenceScope scope : this.fEntityPreferences) {
            if (!this.updatePreferences(scope)) continue;
            IEntity entityToSave = this.fEntities.get(this.fEntityPreferences.indexOf(scope));
            entitiesToSave.add(entityToSave);
            this.fSettingsChanged = true;
        }
        for (IEntity entity : this.fEntities) {
            if (!this.fSettingsChanged || !(entity instanceof IFolder)) continue;
            this.updateChildPreferences((IFolder)entity);
        }
        return true;
    }

    private void updateChildPreferences(IFolder folder) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            IPreferenceScope scope = Owl.getPreferenceService().getEntityScope((IEntity)mark);
            this.updatePreferences(scope);
        }
        List folders = folder.getFolders();
        for (IFolder childFolder : folders) {
            IPreferenceScope scope = Owl.getPreferenceService().getEntityScope((IEntity)childFolder);
            this.updatePreferences(scope);
            this.updateChildPreferences(childFolder);
        }
    }

    private boolean updatePreferences(IPreferenceScope scope) {
        boolean ascending;
        int sortColumn;
        boolean changed = false;
        NewsColumnViewModel model = this.fColumnSelectionControl.getModel();
        List<NewsColumn> columns = model.getColumns();
        int[] columnsInt = new int[columns.size()];
        int i = 0;
        while (i < columns.size()) {
            columnsInt[i] = columns.get(i).ordinal();
            ++i;
        }
        if (!Arrays.equals(this.fPrefSelectedColumns, columnsInt)) {
            changed = true;
        }
        if (this.fPrefSortColumn != (sortColumn = model.getSortColumn().ordinal())) {
            changed = true;
        }
        if (this.fPrefAscending != (ascending = model.isAscending())) {
            changed = true;
        }
        if (changed) {
            model.saveTo(scope);
        }
        return changed;
    }

    @Override
    public void finish() {
        if (this.fSettingsChanged) {
            EditorUtils.updateColumns();
        }
    }
}

