/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.browser;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.reference.BookMarkReference;
import org.rssowl.core.persist.reference.FolderReference;
import org.rssowl.core.persist.reference.ModelReference;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.reference.SearchMarkReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;

public class WebBrowserContext {
    private NewsReference fNewsReference;
    private ModelReference fNewsMarkReference;
    private String fTitle;

    private WebBrowserContext() {
    }

    public static WebBrowserContext createFrom(String text) {
        WebBrowserContext context = new WebBrowserContext();
        if (!StringUtils.isSet((String)text)) {
            return context;
        }
        context.fTitle = text;
        return context;
    }

    public static WebBrowserContext createFrom(INews news, INewsMark mark) {
        WebBrowserContext context = new WebBrowserContext();
        if (news == null || mark == null) {
            return context;
        }
        context.fNewsReference = news.toReference();
        context.fTitle = CoreUtils.getHeadline((INews)news, (boolean)true);
        context.fNewsMarkReference = mark instanceof FolderNewsMark ? new FolderReference(mark.getId().longValue()) : mark.toReference();
        return context;
    }

    public static WebBrowserContext createFrom(ISelection selection, FeedView feedview) {
        if (selection == null || feedview == null) {
            return new WebBrowserContext();
        }
        INews news = WebBrowserContext.getNews(selection);
        INewsMark mark = ((FeedViewInput)feedview.getEditorInput()).getMark();
        return WebBrowserContext.createFrom(news, mark);
    }

    private static INews getNews(ISelection selection) {
        Object element;
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof INews) {
            return (INews)element;
        }
        return null;
    }

    public NewsReference getNewsReference() {
        return this.fNewsReference;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public INewsMark getNewsMark() {
        if (this.fNewsMarkReference == null) {
            return null;
        }
        if (this.fNewsMarkReference instanceof BookMarkReference) {
            return (IBookMark)this.fNewsMarkReference.resolve();
        }
        if (this.fNewsMarkReference instanceof SearchMarkReference) {
            return (ISearchMark)this.fNewsMarkReference.resolve();
        }
        if (this.fNewsMarkReference instanceof NewsBinReference) {
            return (INewsBin)this.fNewsMarkReference.resolve();
        }
        if (this.fNewsMarkReference instanceof FolderReference) {
            return new FolderNewsMark((IFolder)this.fNewsMarkReference.resolve());
        }
        return null;
    }
}

