/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.Messages;
import org.rssowl.ui.internal.editors.feed.NewsColumn;
import org.rssowl.ui.internal.editors.feed.NewsColumnViewModel;

public class NewsTableLabelProvider
extends OwnerDrawLabelProvider {
    protected NewsColumnViewModel fColumnModel;
    private static final String LABEL_COLOR_BLACK = "0,0,0";
    private static final String LABEL_COLOR_WHITE = "255,255,255";
    protected LocalResourceManager fResources;
    private final DateFormat fDateFormat = OwlUI.getShortDateFormat();
    private DateFormat fTimeFormat = OwlUI.getShortTimeFormat();
    private Color fStickyBgColor;
    private Color fGradientFgColor;
    private Color fGradientBgColor;
    private Color fGradientEndColor;
    private Color fGroupFgColor;
    private Color fGroupBgColor;
    private Color fNewsBgGradientStartColor;
    private Color fNewsBgGradientEndColor;
    private RGB fListBackground;
    private RGB fListSelectionBackground;
    private Image fNewsUnreadIcon;
    private Image fNewsNewIcon;
    private Image fNewsUpdatedIcon;
    private Image fNewsReadIcon;
    private Image fNewsStickyIcon;
    private Image fNewsNonStickyIcon;
    private Image fGroupIcon;
    private Font fBoldFont;
    private Map<Long, String> fMapBinIdToLocation = new HashMap<Long, String>();
    private Map<String, String> fMapFeedLinkToLocation = new HashMap<String, String>();
    private Map<String, ImageDescriptor> fMapFeedLinkToFeedIcon = new HashMap<String, ImageDescriptor>();
    private final long fTodayInMillies;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$rssowl$ui$internal$editors$feed$NewsColumn;

    public NewsTableLabelProvider(NewsColumnViewModel model) {
        this.fColumnModel = model;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.fTodayInMillies = DateUtils.getToday().getTimeInMillis();
        this.createResources();
    }

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column, false);
    }

    public void init(NewsColumnViewModel model) {
        this.fColumnModel = model;
    }

    void updateResources() {
        this.fStickyBgColor = OwlUI.getThemeColor("org.rssowl.ui.StickyBGColor", (ResourceManager)this.fResources, new RGB(255, 255, 180));
        this.createNewsListBackgroundResources();
    }

    private void createResources() {
        this.fStickyBgColor = OwlUI.getThemeColor("org.rssowl.ui.StickyBGColor", (ResourceManager)this.fResources, new RGB(255, 255, 180));
        this.fGradientFgColor = OwlUI.getColor((ResourceManager)this.fResources, OwlUI.GROUP_GRADIENT_FG_COLOR);
        this.fGradientBgColor = OwlUI.getColor((ResourceManager)this.fResources, OwlUI.GROUP_GRADIENT_BG_COLOR);
        this.fGradientEndColor = OwlUI.getColor((ResourceManager)this.fResources, OwlUI.GROUP_GRADIENT_END_COLOR);
        this.fGroupFgColor = OwlUI.getColor((ResourceManager)this.fResources, OwlUI.GROUP_FG_COLOR);
        this.fGroupBgColor = OwlUI.getColor((ResourceManager)this.fResources, OwlUI.GROUP_BG_COLOR);
        this.fListBackground = this.fResources.getDevice().getSystemColor(25).getRGB();
        this.fListSelectionBackground = this.fResources.getDevice().getSystemColor(26).getRGB();
        this.createNewsListBackgroundResources();
        this.fNewsUnreadIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.NEWS_STATE_UNREAD);
        this.fNewsNewIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.NEWS_STATE_NEW);
        this.fNewsUpdatedIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.NEWS_STATE_UPDATED);
        this.fNewsReadIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.NEWS_STATE_READ);
        this.fNewsStickyIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.NEWS_PINNED);
        this.fNewsNonStickyIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.NEWS_PIN);
        this.fGroupIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.GROUP);
        this.fBoldFont = OwlUI.getThemeFont("org.rssowl.ui.HeadlinesFont", 1);
    }

    private void createNewsListBackgroundResources() {
        this.fNewsBgGradientStartColor = null;
        this.fNewsBgGradientEndColor = null;
        RGB listBackgroundRGB = Display.getDefault().getSystemColor(25).getRGB();
        RGB newsBgColorRGB = OwlUI.getThemeRGB("org.rssowl.ui.NewsListBackgroundColor", listBackgroundRGB);
        if (newsBgColorRGB != null && !listBackgroundRGB.equals((Object)newsBgColorRGB) && !this.isInvalidColor(newsBgColorRGB)) {
            this.fNewsBgGradientEndColor = OwlUI.getColor((ResourceManager)this.fResources, newsBgColorRGB);
            RGB newsBgColorRGBLighter = new RGB(0, 0, 0);
            newsBgColorRGBLighter.red = Math.min(newsBgColorRGB.red + 5, 255);
            newsBgColorRGBLighter.green = Math.min(newsBgColorRGB.green + 5, 255);
            newsBgColorRGBLighter.blue = Math.min(newsBgColorRGB.blue + 5, 255);
            this.fNewsBgGradientStartColor = OwlUI.getColor((ResourceManager)this.fResources, newsBgColorRGBLighter);
        }
    }

    public void update(ViewerCell cell) {
        NewsColumn column = this.fColumnModel.getColumn(cell.getColumnIndex());
        cell.setText(this.getColumnText(cell.getElement(), column, cell.getColumnIndex()));
        cell.setImage(this.getColumnImage(cell.getElement(), column, cell.getColumnIndex()));
        cell.setFont(this.getFont(cell.getElement(), cell.getColumnIndex()));
        Color foreground = this.getForeground(cell.getElement(), cell.getColumnIndex());
        if (!OwlUI.isHighContrast()) {
            Item item = (Item)cell.getItem();
            if (item instanceof TreeItem) {
                ((TreeItem)cell.getItem()).setForeground(foreground);
            } else if (item instanceof TableItem) {
                ((TableItem)cell.getItem()).setForeground(foreground);
            }
        }
        if (!OwlUI.isHighContrast()) {
            cell.setBackground(this.getBackground(cell.getElement(), cell.getColumnIndex()));
        }
    }

    public String getToolTipText(Object element) {
        if (element instanceof INews) {
            INewsBin bin;
            INews news = (INews)element;
            String feedRef = news.getFeedLinkAsText();
            IBookMark bookMark = CoreUtils.getBookMark((String)feedRef);
            String name = null;
            name = bookMark != null ? bookMark.getName() : feedRef;
            if (news.getParentId() != 0L && (bin = (INewsBin)DynamicDAO.load(INewsBin.class, (long)news.getParentId())) != null) {
                name = NLS.bind((String)Messages.NewsTableLabelProvider_BIN_NAME, (Object)bin.getName(), (Object)name);
            }
            return StringUtils.replaceAll((String)name, (String)"&", (String)"&&");
        }
        if (element instanceof EntityGroup) {
            return StringUtils.replaceAll((String)((EntityGroup)element).getName(), (String)"&", (String)"&&");
        }
        return super.getToolTipText(element);
    }

    public Point getToolTipShift(Object object) {
        if (Application.IS_WINDOWS) {
            return new Point(0, 21);
        }
        return super.getToolTipShift(object);
    }

    protected String getColumnText(Object element, NewsColumn column, int colIndex) {
        String text;
        block39: {
            block38: {
                text = null;
                if (!(element instanceof INews)) break block38;
                INews news = (INews)element;
                switch (NewsTableLabelProvider.$SWITCH_TABLE$org$rssowl$ui$internal$editors$feed$NewsColumn()[column.ordinal()]) {
                    case 1: {
                        text = CoreUtils.getHeadline((INews)news, (boolean)true);
                        break;
                    }
                    case 2: {
                        Date date = DateUtils.getRecentDate((INews)news);
                        text = DateUtils.isAfterIncludingToday((Date)date, (long)this.fTodayInMillies) ? this.fTimeFormat.format(date) : this.fDateFormat.format(date);
                        break;
                    }
                    case 3: {
                        Date published = news.getPublishDate();
                        if (published != null) {
                            text = DateUtils.isAfterIncludingToday((Date)published, (long)this.fTodayInMillies) ? this.fTimeFormat.format(published) : this.fDateFormat.format(published);
                            break;
                        }
                        break block39;
                    }
                    case 4: {
                        Date modified = news.getModifiedDate();
                        if (modified != null) {
                            text = DateUtils.isAfterIncludingToday((Date)modified, (long)this.fTodayInMillies) ? this.fTimeFormat.format(modified) : this.fDateFormat.format(modified);
                            break;
                        }
                        break block39;
                    }
                    case 5: {
                        Date received = news.getReceiveDate();
                        if (received != null) {
                            text = DateUtils.isAfterIncludingToday((Date)received, (long)this.fTodayInMillies) ? this.fTimeFormat.format(received) : this.fDateFormat.format(received);
                            break;
                        }
                        break block39;
                    }
                    case 6: {
                        IPerson author = news.getAuthor();
                        if (author != null) {
                            if (author.getName() != null) {
                                text = author.getName();
                                break;
                            }
                            if (author.getEmail() != null) {
                                text = author.getEmail().toString();
                                break;
                            }
                        }
                        break block39;
                    }
                    case 7: {
                        List categories = news.getCategories();
                        if (!categories.isEmpty()) {
                            StringBuilder str = new StringBuilder();
                            for (ICategory category : categories) {
                                if (StringUtils.isSet((String)category.getName())) {
                                    str.append(category.getName().trim()).append(", ");
                                    continue;
                                }
                                if (!StringUtils.isSet((String)category.getDomain())) continue;
                                str.append(category.getDomain().trim()).append(", ");
                            }
                            if (str.length() > 0) {
                                str = str.delete(str.length() - 2, str.length());
                            }
                            text = str.toString();
                            break;
                        }
                        break block39;
                    }
                    case 8: {
                        Set labels = CoreUtils.getSortedLabels((INews)news);
                        if (!labels.isEmpty()) {
                            StringBuilder str = new StringBuilder();
                            for (ILabel label : labels) {
                                str.append(label.getName()).append(", ");
                            }
                            if (str.length() > 0) {
                                str = str.delete(str.length() - 2, str.length());
                            }
                            text = str.toString();
                            break;
                        }
                        break block39;
                    }
                    case 9: {
                        INews.State state = news.getState();
                        if (state == INews.State.NEW) {
                            text = Messages.NewsTableLabelProvider_NEW;
                            break;
                        }
                        if (state == INews.State.UNREAD) {
                            text = Messages.NewsTableLabelProvider_UNREAD;
                            break;
                        }
                        if (state == INews.State.UPDATED) {
                            text = Messages.NewsTableLabelProvider_UPDATED;
                            break;
                        }
                        if (state == INews.State.READ) {
                            text = Messages.NewsTableLabelProvider_READ;
                            break;
                        }
                        break block39;
                    }
                    case 14: {
                        IBookMark bookmark;
                        if (news.getParentId() > 0L) {
                            String location = this.fMapBinIdToLocation.get(news.getParentId());
                            if (location == null) {
                                NewsBinReference ref = new NewsBinReference(news.getParentId());
                                INewsBin bin = ref.resolve();
                                location = bin.getName();
                                this.fMapBinIdToLocation.put(news.getParentId(), location);
                            }
                            text = location;
                            break;
                        }
                        String location = this.fMapFeedLinkToLocation.get(news.getFeedLinkAsText());
                        if (location == null && (bookmark = CoreUtils.getBookMark((String)news.getFeedLinkAsText())) != null) {
                            location = bookmark.getName();
                            this.fMapFeedLinkToLocation.put(news.getFeedLinkAsText(), location);
                        }
                        text = location;
                        break;
                    }
                    case 15: {
                        text = CoreUtils.getLink((INews)news);
                        if (!StringUtils.isSet((String)text)) break block39;
                        text = StringUtils.replaceAll((String)text, (String)"http://", (String)"");
                        text = StringUtils.replaceAll((String)text, (String)"www.", (String)"");
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block39;
            }
            if (element instanceof EntityGroup && column == NewsColumn.TITLE) {
                text = ((EntityGroup)element).getName();
            }
        }
        return text != null ? StringUtils.normalizeString(text) : null;
    }

    protected Image getColumnImage(Object element, NewsColumn newsColumn, int colIndex) {
        if (element instanceof INews) {
            INews news = (INews)element;
            if (newsColumn == NewsColumn.TITLE) {
                if (news.getState() == INews.State.UNREAD) {
                    return this.fNewsUnreadIcon;
                }
                if (news.getState() == INews.State.NEW) {
                    return this.fNewsNewIcon;
                }
                if (news.getState() == INews.State.UPDATED) {
                    return this.fNewsUpdatedIcon;
                }
                if (news.getState() == INews.State.READ) {
                    return this.fNewsReadIcon;
                }
            } else {
                List attachments;
                if (newsColumn == NewsColumn.FEED) {
                    String feedRef = news.getFeedLinkAsText();
                    ImageDescriptor feedIcon = this.fMapFeedLinkToFeedIcon.get(feedRef);
                    if (feedIcon == null) {
                        IBookMark bookMark = CoreUtils.getBookMark((String)feedRef);
                        if (bookMark != null) {
                            feedIcon = OwlUI.getFavicon(bookMark);
                        }
                        if (feedIcon == null) {
                            feedIcon = OwlUI.BOOKMARK;
                        }
                        this.fMapFeedLinkToFeedIcon.put(feedRef, feedIcon);
                    }
                    return OwlUI.getImage((ResourceManager)this.fResources, feedIcon);
                }
                if (newsColumn == NewsColumn.STICKY) {
                    if (news.isFlagged()) {
                        return this.fNewsStickyIcon;
                    }
                    return this.fNewsNonStickyIcon;
                }
                if (newsColumn == NewsColumn.ATTACHMENTS && !(attachments = news.getAttachments()).isEmpty()) {
                    return OwlUI.getImage((ResourceManager)this.fResources, OwlUI.ATTACHMENT);
                }
            }
        } else if (element instanceof EntityGroup && newsColumn == NewsColumn.TITLE) {
            EntityGroup group = (EntityGroup)element;
            if (group.getImage() != null) {
                return OwlUI.getImage((ResourceManager)this.fResources, group.getImage());
            }
            return this.fGroupIcon;
        }
        return null;
    }

    protected Font getFont(Object element, int columnIndex) {
        if (element instanceof INews) {
            INews news = (INews)element;
            INews.State state = news.getState();
            if (state == null) {
                return null;
            }
            if (state == INews.State.NEW || state == INews.State.UPDATED || state == INews.State.UNREAD) {
                return this.fBoldFont;
            }
        }
        if (element instanceof EntityGroup) {
            return this.fBoldFont;
        }
        return null;
    }

    protected Color getBackground(Object element, int columnIndex) {
        if (element instanceof INews && ((INews)element).isFlagged()) {
            return this.fStickyBgColor;
        }
        if (element instanceof EntityGroup) {
            return this.fGroupBgColor;
        }
        return null;
    }

    protected Color getForeground(Object element, int columnIndex) {
        RGB labelRGB;
        Set labels;
        if (element instanceof EntityGroup) {
            EntityGroup group = (EntityGroup)element;
            if (group.getColorHint() != null && !this.fListBackground.equals((Object)group.getColorHint()) && !this.fListSelectionBackground.equals((Object)group.getColorHint())) {
                return OwlUI.getColor((ResourceManager)this.fResources, group.getColorHint());
            }
            return this.fGroupFgColor;
        }
        if (element instanceof INews && !(labels = CoreUtils.getSortedLabels((INews)((INews)element))).isEmpty() && !this.fListBackground.equals((Object)(labelRGB = OwlUI.getRGB((ILabel)labels.iterator().next()))) && !this.fListSelectionBackground.equals((Object)labelRGB)) {
            return OwlUI.getColor((ResourceManager)this.fResources, labelRGB);
        }
        return null;
    }

    public void dispose() {
        this.fResources.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void erase(Event event, Object element) {
        if (element instanceof INews) {
            this.eraseNews(event, (INews)element);
        } else if (element instanceof EntityGroup) {
            this.eraseGroup(event, (EntityGroup)element);
        }
    }

    private void eraseGroup(Event event, EntityGroup group) {
        Scrollable scrollable = (Scrollable)event.widget;
        GC gc = event.gc;
        if (group.getColorHint() != null && (event.detail & 2) != 0) {
            if (!scrollable.isFocusControl() || this.isInvalidColor(group.getColorHint())) {
                return;
            }
            Rectangle clArea = scrollable.getClientArea();
            Rectangle itemRect = event.getBounds();
            OwlUI.codExpandRegion(event, scrollable, gc, clArea);
            Color oldBackground = gc.getBackground();
            gc.setBackground(OwlUI.getColor((ResourceManager)this.fResources, group.getColorHint()));
            gc.fillRectangle(0, itemRect.y, clArea.width, itemRect.height);
            gc.setBackground(oldBackground);
            gc.setForeground(scrollable.getDisplay().getSystemColor(25));
            event.detail &= 0xFFFFFFFD;
        } else {
            OwlUI.codDrawGradient(event, this.fGradientFgColor, this.fGradientBgColor, this.fGradientEndColor);
        }
    }

    private void eraseNews(Event event, INews news) {
        Scrollable scrollable = (Scrollable)event.widget;
        GC gc = event.gc;
        if ((event.detail & 2) != 0 && (Application.IS_WINDOWS || !news.isFlagged())) {
            if (!scrollable.isFocusControl()) {
                return;
            }
            Set labels = CoreUtils.getSortedLabels((INews)news);
            if (labels.isEmpty()) {
                return;
            }
            ILabel label = (ILabel)labels.iterator().next();
            if (this.isInvalidColor(label)) {
                return;
            }
            Rectangle clArea = scrollable.getClientArea();
            Rectangle itemRect = event.getBounds();
            OwlUI.codExpandRegion(event, scrollable, gc, clArea);
            Color oldBackground = gc.getBackground();
            gc.setBackground(OwlUI.getColor((ResourceManager)this.fResources, label));
            gc.fillRectangle(0, itemRect.y, clArea.width, itemRect.height);
            gc.setBackground(oldBackground);
            gc.setForeground(scrollable.getDisplay().getSystemColor(25));
            event.detail &= 0xFFFFFFFD;
        } else if (news.isFlagged()) {
            Rectangle clArea = scrollable.getClientArea();
            Rectangle itemRect = event.getBounds();
            OwlUI.codExpandRegion(event, scrollable, gc, clArea);
            Color oldBackground = gc.getBackground();
            gc.setBackground(this.fStickyBgColor);
            gc.fillRectangle(0, itemRect.y, clArea.width, itemRect.height);
            gc.setBackground(oldBackground);
            event.detail &= 0xFFFFFFF7;
        } else if (this.fNewsBgGradientStartColor != null && this.fNewsBgGradientEndColor != null) {
            int index = 0;
            if (event.item instanceof TreeItem) {
                TreeItem item = (TreeItem)event.item;
                TreeItem parentItem = item.getParentItem();
                index = parentItem != null ? parentItem.indexOf(item) : item.getParent().indexOf(item);
            } else if (event.item instanceof TableItem) {
                TableItem item = (TableItem)event.item;
                index = item.getParent().indexOf(item);
            }
            if (index % 2 != 0) {
                OwlUI.codDrawGradient(event, this.fNewsBgGradientStartColor, this.fNewsBgGradientEndColor, this.fNewsBgGradientEndColor);
            }
        }
    }

    private boolean isInvalidColor(ILabel label) {
        return label.getColor().equals(LABEL_COLOR_BLACK) || label.getColor().equals(LABEL_COLOR_WHITE);
    }

    private boolean isInvalidColor(RGB color) {
        if (color.blue == 0 && color.red == 0 && color.green == 0) {
            return true;
        }
        return color.blue == 255 && color.red == 255 && color.green == 255;
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$rssowl$ui$internal$editors$feed$NewsColumn() {
        if ($SWITCH_TABLE$org$rssowl$ui$internal$editors$feed$NewsColumn != null) {
            return $SWITCH_TABLE$org$rssowl$ui$internal$editors$feed$NewsColumn;
        }
        int[] nArray = new int[NewsColumn.values().length];
        try {
            nArray[NewsColumn.ATTACHMENTS.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.AUTHOR.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.CATEGORY.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.DATE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.FEED.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.LABELS.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.LINK.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.LOCATION.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.MODIFIED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.PUBLISHED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.RECEIVED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.RELEVANCE.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.STATUS.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.STICKY.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NewsColumn.TITLE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$rssowl$ui$internal$editors$feed$NewsColumn = nArray;
        return nArray;
    }
}

