/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.filter;

import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.filter.INewsActionPresentation;
import org.rssowl.ui.internal.filter.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class ShowGrowlActionPresentation
implements INewsActionPresentation {
    private static final String DEFAULT_GROWLNOTIFY_LOCATION = "/usr/local/bin/growlnotify";
    private Link fGrowlPathLink;
    private Composite fContainer;

    public void create(Composite parent, Object data) {
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        ((GridLayout)this.fContainer.getLayout()).marginLeft = 5;
        this.fContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fGrowlPathLink = new Link(this.fContainer, 64);
        this.fGrowlPathLink.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ((GridData)this.fGrowlPathLink.getLayoutData()).widthHint = 100;
        this.updateLink(data);
        this.fGrowlPathLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowGrowlActionPresentation.this.onSelect();
            }
        });
    }

    private void onSelect() {
        String folderPath;
        File file;
        FileDialog dialog = new FileDialog(this.fGrowlPathLink.getShell(), 4096);
        dialog.setText(Messages.ShowGrowlActionPresentation_SELECT_GROWL_TITLE);
        if (this.fGrowlPathLink.getData() != null && (file = new File(this.fGrowlPathLink.getData().toString())).exists()) {
            dialog.setFilterPath(file.toString());
        }
        if (!StringUtils.isSet((String)dialog.getFilterPath()) && new File(DEFAULT_GROWLNOTIFY_LOCATION).exists()) {
            dialog.setFilterPath(DEFAULT_GROWLNOTIFY_LOCATION);
        }
        if ((folderPath = dialog.open()) != null) {
            this.updateLink(folderPath);
            this.fGrowlPathLink.getShell().layout(true, true);
        }
    }

    private void updateLink(Object data) {
        if (data == null) {
            this.resetLink();
        } else {
            File file = new File(data.toString());
            if (file.exists()) {
                this.fGrowlPathLink.setText("<a>" + file.getAbsolutePath() + "</a>");
                this.fGrowlPathLink.setData(data);
            } else {
                this.resetLink();
            }
        }
    }

    private void resetLink() {
        this.fGrowlPathLink.setText(Messages.ShowGrowlActionPresentation_SELECT_GROWL_LINK);
        this.fGrowlPathLink.setData(null);
    }

    public void dispose() {
        this.fContainer.dispose();
    }

    public Object getData() {
        return this.fGrowlPathLink.getData();
    }
}

