/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.notifier;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.rssowl.ui.internal.OwlUI;

public class NotifierColors {
    private Display fDisplay;
    private Color fGradientBegin;
    private Color fGradientEnd;
    private Color fBorder;
    private ResourceManager fResources;

    NotifierColors(Display display, ResourceManager resources) {
        this.fDisplay = display;
        this.fResources = resources;
        this.createColors();
    }

    private void createColors() {
        this.createBorderColor();
        this.createGradientColors();
    }

    Color getGradientBegin() {
        return this.fGradientBegin;
    }

    Color getGradientEnd() {
        return this.fGradientEnd;
    }

    Color getBorder() {
        return this.fBorder;
    }

    private void createBorderColor() {
        RGB tbBorder = this.getSystemColor(31);
        RGB bg = this.getImpliedBackground().getRGB();
        tbBorder = this.testTwoPrimaryColors(tbBorder, 179, 256) ? this.blend(tbBorder, bg, 70) : (this.testTwoPrimaryColors(tbBorder, 120, 180) ? this.blend(tbBorder, bg, 50) : this.blend(tbBorder, bg, 30));
        this.fBorder = OwlUI.getColor(this.fResources, tbBorder);
    }

    private void createGradientColors() {
        RGB top;
        RGB bottom;
        RGB titleBg = this.getSystemColor(31);
        Color bgColor = this.getImpliedBackground();
        RGB bg = bgColor.getRGB();
        if (this.testTwoPrimaryColors(titleBg, 179, 256)) {
            bottom = this.blend(titleBg, bg, 30);
            top = bg;
        } else if (this.testTwoPrimaryColors(titleBg, 120, 180)) {
            bottom = this.blend(titleBg, bg, 20);
            top = bg;
        } else {
            bottom = this.blend(titleBg, bg, 10);
            top = bg;
        }
        this.fGradientBegin = OwlUI.getColor(this.fResources, top);
        this.fGradientEnd = OwlUI.getColor(this.fResources, bottom);
    }

    private RGB blend(RGB c1, RGB c2, int ratio) {
        int r = this.blend(c1.red, c2.red, ratio);
        int g = this.blend(c1.green, c2.green, ratio);
        int b = this.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    private boolean testTwoPrimaryColors(RGB rgb, int from, int to) {
        int total = 0;
        if (this.testPrimaryColor(rgb.red, from, to)) {
            ++total;
        }
        if (this.testPrimaryColor(rgb.green, from, to)) {
            ++total;
        }
        if (this.testPrimaryColor(rgb.blue, from, to)) {
            ++total;
        }
        return total >= 2;
    }

    private boolean testPrimaryColor(int value, int from, int to) {
        return value > from && value < to;
    }

    private RGB getSystemColor(int code) {
        return this.getDisplay().getSystemColor(code).getRGB();
    }

    private Color getImpliedBackground() {
        return this.fDisplay.getSystemColor(25);
    }

    private Display getDisplay() {
        return this.fDisplay;
    }
}

